/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.regionserver.PeerActionListener;
import org.apache.hadoop.hbase.replication.regionserver.SyncReplicationPeerInfoProvider;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.IOExceptionConsumer;
import org.apache.hadoop.hbase.util.IOExceptionRunnable;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hbase.thirdparty.com.google.common.collect.Streams;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractWALProvider
implements WALProvider,
PeerActionListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWALProvider.class);
    public static final String WAL_FILE_NAME_DELIMITER = ".";
    protected WALFactory factory;
    protected Configuration conf;
    protected List<WALActionsListener> listeners = new ArrayList<WALActionsListener>();
    protected String providerId;
    protected AtomicBoolean initialized = new AtomicBoolean(false);
    protected String logPrefix;
    protected Abortable abortable;
    private final ConcurrentMap<String, Optional<WAL>> peerId2WAL = new ConcurrentHashMap<String, Optional<WAL>>();
    private final KeyLocker<String> createLock = new KeyLocker();
    private final Lock numRemoteWALUnderCreationLock = new ReentrantLock();
    private final Condition noRemoteWALUnderCreationCond = this.numRemoteWALUnderCreationLock.newCondition();
    private int numRemoteWALUnderCreation;
    private SyncReplicationPeerInfoProvider peerInfoProvider = new SyncReplicationPeerInfoProvider(){

        @Override
        public Optional<Pair<String, String>> getPeerIdAndRemoteWALDir(TableName table) {
            return Optional.empty();
        }

        @Override
        public boolean checkState(TableName table, BiPredicate<SyncReplicationState, SyncReplicationState> checker) {
            return false;
        }
    };
    private static final Pattern LOG_PREFIX_PATTERN = Pattern.compile(".*-\\d+-(.+)");

    @Override
    public final void init(WALFactory factory, Configuration conf, String providerId, Abortable server) throws IOException {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        this.factory = factory;
        this.conf = conf;
        this.abortable = server;
        this.doInit(factory, conf, providerId);
    }

    protected final void initWAL(WAL wal) throws IOException {
        boolean succ = false;
        try {
            wal.init();
            succ = true;
        }
        finally {
            if (!succ) {
                AbstractWALProvider.safeClose(wal);
            }
        }
    }

    private String getRemoteWALPrefix(String peerId) {
        return this.factory.factoryId + "-" + EnvironmentEdgeManager.currentTime() + "-" + peerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WAL getRemoteWAL(RegionInfo region, String peerId, String remoteWALDir) throws IOException {
        Optional opt = (Optional)this.peerId2WAL.get(peerId);
        if (opt != null) {
            return opt.orElse(null);
        }
        ReentrantLock lock = this.createLock.acquireLock(peerId);
        try {
            opt = (Optional)this.peerId2WAL.get(peerId);
            if (opt != null) {
                WAL wAL = opt.orElse(null);
                return wAL;
            }
            WAL wal = this.createRemoteWAL(region, ReplicationUtils.getRemoteWALFileSystem(this.conf, remoteWALDir), ReplicationUtils.getPeerRemoteWALDir(remoteWALDir, peerId), this.getRemoteWALPrefix(peerId), ".syncrep");
            this.numRemoteWALUnderCreationLock.lock();
            try {
                ++this.numRemoteWALUnderCreation;
            }
            finally {
                this.numRemoteWALUnderCreationLock.unlock();
            }
            this.initWAL(wal);
            this.peerId2WAL.put(peerId, Optional.of(wal));
            WAL wAL = wal;
            return wAL;
        }
        finally {
            lock.unlock();
            this.numRemoteWALUnderCreationLock.lock();
            try {
                --this.numRemoteWALUnderCreation;
                if (this.numRemoteWALUnderCreation == 0) {
                    this.noRemoteWALUnderCreationCond.signalAll();
                }
            }
            finally {
                this.numRemoteWALUnderCreationLock.unlock();
            }
        }
    }

    @Override
    public final WAL getWAL(RegionInfo region) throws IOException {
        Pair<String, String> pair;
        WAL wal;
        if (region == null) {
            return this.getWAL0(null);
        }
        Optional<Pair<String, String>> peerIdAndRemoteWALDir = this.peerInfoProvider.getPeerIdAndRemoteWALDir(region.getTable());
        if (peerIdAndRemoteWALDir.isPresent() && (wal = this.getRemoteWAL(region, (pair = peerIdAndRemoteWALDir.get()).getFirst(), pair.getSecond())) != null) {
            return wal;
        }
        return this.getWAL0(region);
    }

    @Override
    public final List<WAL> getWALs() {
        ArrayList wals = new ArrayList();
        this.numRemoteWALUnderCreationLock.lock();
        try {
            while (this.numRemoteWALUnderCreation > 0) {
                this.noRemoteWALUnderCreationCond.awaitUninterruptibly();
            }
            this.peerId2WAL.values().stream().filter(Optional::isPresent).map(Optional::get).forEach(wals::add);
        }
        finally {
            this.numRemoteWALUnderCreationLock.unlock();
        }
        return Streams.concat(this.peerId2WAL.values().stream().filter(Optional::isPresent).map(Optional::get), this.getWALs0().stream()).collect(Collectors.toList());
    }

    @Override
    public PeerActionListener getPeerActionListener() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerSyncReplicationStateChange(String peerId, SyncReplicationState from, SyncReplicationState to, int stage) {
        if (from == SyncReplicationState.ACTIVE) {
            if (stage == 0) {
                ReentrantLock lock = this.createLock.acquireLock(peerId);
                try {
                    Optional opt = (Optional)this.peerId2WAL.get(peerId);
                    if (opt != null) {
                        opt.ifPresent(w -> w.skipRemoteWAL(to == SyncReplicationState.STANDBY));
                    }
                    this.peerId2WAL.put(peerId, Optional.empty());
                }
                finally {
                    lock.unlock();
                }
            } else if (stage == 1) {
                ((Optional)this.peerId2WAL.remove(peerId)).ifPresent(AbstractWALProvider::safeClose);
            }
        }
    }

    @Override
    public void setSyncReplicationPeerInfoProvider(SyncReplicationPeerInfoProvider provider) {
        this.peerInfoProvider = provider;
    }

    private static void safeClose(WAL wal) {
        if (wal != null) {
            try {
                wal.close();
            }
            catch (IOException e) {
                LOG.error("Close WAL failed", (Throwable)e);
            }
        }
    }

    @Override
    public void addWALActionsListener(WALActionsListener listener) {
        this.listeners.add(listener);
    }

    private void cleanup(IOExceptionConsumer<WAL> cleanupWAL, IOExceptionRunnable finalCleanup) throws IOException {
        MultipleIOException.Builder builder = new MultipleIOException.Builder();
        for (Optional wal : this.peerId2WAL.values()) {
            if (!wal.isPresent()) continue;
            try {
                cleanupWAL.accept((WAL)wal.get());
            }
            catch (IOException e) {
                LOG.error("cleanup WAL failed", (Throwable)e);
                builder.add((Throwable)e);
            }
        }
        try {
            finalCleanup.run();
        }
        catch (IOException e) {
            LOG.error("cleanup WAL failed", (Throwable)e);
            builder.add((Throwable)e);
        }
        if (!builder.isEmpty()) {
            throw builder.build();
        }
    }

    @Override
    public final void shutdown() throws IOException {
        this.cleanup(WAL::shutdown, this::shutdown0);
    }

    @Override
    public final void close() throws IOException {
        this.cleanup(WAL::close, this::close0);
    }

    private Stream<AbstractFSWAL<?>> remoteWALStream() {
        return this.peerId2WAL.values().stream().filter(Optional::isPresent).map(Optional::get).filter(w -> w instanceof AbstractFSWAL).map(w -> (AbstractFSWAL)w);
    }

    @Override
    public final long getNumLogFiles() {
        return this.remoteWALStream().mapToLong(AbstractFSWAL::getNumLogFiles).sum() + this.getNumLogFiles0();
    }

    @Override
    public final long getLogFileSize() {
        return this.remoteWALStream().mapToLong(AbstractFSWAL::getLogFileSize).sum() + this.getLogFileSize0();
    }

    public static Optional<String> getSyncReplicationPeerIdFromWALName(String name) {
        if (!name.endsWith(".syncrep")) {
            return Optional.empty();
        }
        String logPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(name);
        Matcher matcher = LOG_PREFIX_PATTERN.matcher(logPrefix);
        if (matcher.matches()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    protected abstract WAL createRemoteWAL(RegionInfo var1, FileSystem var2, Path var3, String var4, String var5) throws IOException;

    protected abstract void doInit(WALFactory var1, Configuration var2, String var3) throws IOException;

    protected abstract WAL getWAL0(RegionInfo var1) throws IOException;

    protected abstract List<WAL> getWALs0();

    protected abstract void shutdown0() throws IOException;

    protected abstract void close0() throws IOException;

    protected abstract long getNumLogFiles0();

    protected abstract long getLogFileSize0();
}

