/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coordination;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogCounters;
import org.apache.hadoop.hbase.SplitLogTask;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.coordination.SplitLogManagerCoordination;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.AsyncCallback;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.CreateMode;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.ZooDefs;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Stat;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class ZKSplitLogManagerCoordination
extends ZooKeeperListener
implements SplitLogManagerCoordination {
    public static final int DEFAULT_TIMEOUT = 120000;
    public static final int DEFAULT_ZK_RETRIES = 3;
    public static final int DEFAULT_MAX_RESUBMIT = 3;
    private static final Log LOG = LogFactory.getLog(SplitLogManagerCoordination.class);
    private Server server;
    private long zkretries;
    private long resubmitThreshold;
    private long timeout;
    private TaskFinisher taskFinisher;
    SplitLogManagerCoordination.SplitLogManagerDetails details;
    private volatile long lastRecoveringNodeCreationTime = 0L;
    private Configuration conf;
    public boolean ignoreZKDeleteForTesting = false;
    private ZooKeeperProtos.SplitLogTask.RecoveryMode recoveryMode;
    private boolean isDrainingDone = false;

    public ZKSplitLogManagerCoordination(final CoordinatedStateManager manager, ZooKeeperWatcher watcher) {
        super(watcher);
        this.taskFinisher = new TaskFinisher(){

            @Override
            public TaskFinisher.Status finish(ServerName workerName, String logfile) {
                try {
                    WALSplitter.finishSplitLogFile(logfile, manager.getServer().getConfiguration());
                }
                catch (IOException e) {
                    LOG.warn((Object)("Could not finish splitting of log file " + logfile), (Throwable)e);
                    return TaskFinisher.Status.ERR;
                }
                return TaskFinisher.Status.DONE;
            }
        };
        this.server = manager.getServer();
        this.conf = this.server.getConfiguration();
    }

    @Override
    public void init() throws IOException {
        this.zkretries = this.conf.getLong("hbase.splitlog.zk.retries", 3L);
        this.resubmitThreshold = this.conf.getLong("hbase.splitlog.max.resubmit", 3L);
        this.timeout = this.conf.getInt("hbase.splitlog.manager.timeout", 120000);
        this.setRecoveryMode(true);
        if (this.watcher != null) {
            this.watcher.registerListener(this);
            this.lookForOrphans();
        }
    }

    @Override
    public String prepareTask(String taskname) {
        return ZKSplitLog.getEncodedNodeName(this.watcher, taskname);
    }

    @Override
    public int remainingTasksInCoordination() {
        int count = 0;
        try {
            List<String> tasks = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.splitLogZNode);
            if (tasks != null) {
                int listSize = tasks.size();
                for (int i = 0; i < listSize; ++i) {
                    if (ZKSplitLog.isRescanNode(tasks.get(i))) continue;
                    ++count;
                }
            }
        }
        catch (KeeperException ke) {
            LOG.warn((Object)"Failed to check remaining tasks", (Throwable)ke);
            count = -1;
        }
        return count;
    }

    private void handleUnassignedTask(String path) {
        if (ZKSplitLog.isRescanNode(this.watcher, path)) {
            return;
        }
        SplitLogManager.Task task = this.findOrCreateOrphanTask(path);
        if (task.isOrphan() && task.incarnation == 0) {
            LOG.info((Object)("resubmitting unassigned orphan task " + path));
            this.resubmitTask(path, task, SplitLogManager.ResubmitDirective.FORCE);
        }
    }

    @Override
    public void deleteTask(String path) {
        this.deleteNode(path, this.zkretries);
    }

    @Override
    public boolean resubmitTask(String path, SplitLogManager.Task task, SplitLogManager.ResubmitDirective directive) {
        int version;
        if (task.status != SplitLogManager.TerminationStatus.IN_PROGRESS) {
            return false;
        }
        if (directive != SplitLogManager.ResubmitDirective.FORCE) {
            boolean alive;
            long time = EnvironmentEdgeManager.currentTime() - task.last_update;
            boolean bl = alive = this.details.getMaster().getServerManager() != null ? this.details.getMaster().getServerManager().isServerOnline(task.cur_worker_name) : true;
            if (alive && time < this.timeout) {
                LOG.trace((Object)("Skipping the resubmit of " + task.toString() + "  because the server " + task.cur_worker_name + " is not marked as dead, we waited for " + time + " while the timeout is " + this.timeout));
                return false;
            }
            if ((long)task.unforcedResubmits.get() >= this.resubmitThreshold) {
                if (!task.resubmitThresholdReached) {
                    task.resubmitThresholdReached = true;
                    SplitLogCounters.tot_mgr_resubmit_threshold_reached.incrementAndGet();
                    LOG.info((Object)("Skipping resubmissions of task " + path + " because threshold " + this.resubmitThreshold + " reached"));
                }
                return false;
            }
            version = task.last_version;
        } else {
            SplitLogCounters.tot_mgr_resubmit_force.incrementAndGet();
            version = -1;
        }
        LOG.info((Object)("resubmitting task " + path));
        ++task.incarnation;
        boolean result = this.resubmit(this.details.getServerName(), path, version);
        if (!result) {
            task.heartbeatNoDetails(EnvironmentEdgeManager.currentTime());
            return false;
        }
        if (directive != SplitLogManager.ResubmitDirective.FORCE) {
            task.unforcedResubmits.incrementAndGet();
        }
        task.setUnassigned();
        this.rescan(Long.MAX_VALUE);
        SplitLogCounters.tot_mgr_resubmit.incrementAndGet();
        return true;
    }

    @Override
    public void checkTasks() {
        this.rescan(Long.MAX_VALUE);
    }

    private void rescan(long retries) {
        SplitLogTask.Done slt = new SplitLogTask.Done(this.details.getServerName(), this.getRecoveryMode());
        this.watcher.getRecoverableZooKeeper().getZooKeeper().create(ZKSplitLog.getRescanNode(this.watcher), slt.toByteArray(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new CreateRescanAsyncCallback(), retries);
    }

    @Override
    public void submitTask(String path) {
        this.createNode(path, this.zkretries);
    }

    @Override
    public void checkTaskStillAvailable(String path) {
        this.watcher.getRecoverableZooKeeper().getZooKeeper().getData(path, this.watcher, (AsyncCallback.DataCallback)new GetDataAsyncCallback(), (Object)-1L);
        SplitLogCounters.tot_mgr_get_data_queued.incrementAndGet();
    }

    @Override
    public void removeRecoveringRegions(Set<String> recoveredServerNameSet, Boolean isMetaRecovery) throws IOException {
        String metaEncodeRegionName = HRegionInfo.FIRST_META_REGIONINFO.getEncodedName();
        int count = 0;
        try {
            List<String> regions;
            List<String> tasks = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.splitLogZNode);
            if (tasks != null) {
                int listSize = tasks.size();
                for (int i = 0; i < listSize; ++i) {
                    if (ZKSplitLog.isRescanNode(tasks.get(i))) continue;
                    ++count;
                }
            }
            if (count == 0 && this.details.getMaster().isInitialized() && !this.details.getMaster().getServerManager().areDeadServersInProgress()) {
                ZKSplitLog.deleteRecoveringRegionZNodes(this.watcher, null);
                this.lastRecoveringNodeCreationTime = Long.MAX_VALUE;
            } else if (!recoveredServerNameSet.isEmpty() && (regions = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.recoveringRegionsZNode)) != null) {
                int listSize = regions.size();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Processing recovering " + regions + " and servers " + recoveredServerNameSet + ", isMetaRecovery=" + isMetaRecovery));
                }
                for (int i = 0; i < listSize; ++i) {
                    String region = regions.get(i);
                    if (isMetaRecovery != null && (isMetaRecovery.booleanValue() && !region.equalsIgnoreCase(metaEncodeRegionName) || !isMetaRecovery.booleanValue() && region.equalsIgnoreCase(metaEncodeRegionName))) continue;
                    String nodePath = ZKUtil.joinZNode(this.watcher.recoveringRegionsZNode, region);
                    List<String> failedServers = ZKUtil.listChildrenNoWatch(this.watcher, nodePath);
                    if (failedServers == null || failedServers.isEmpty()) {
                        ZKUtil.deleteNode(this.watcher, nodePath);
                        continue;
                    }
                    if (recoveredServerNameSet.containsAll(failedServers)) {
                        ZKUtil.deleteNodeRecursively(this.watcher, nodePath);
                        continue;
                    }
                    int tmpFailedServerSize = failedServers.size();
                    for (int j = 0; j < tmpFailedServerSize; ++j) {
                        String failedServer = failedServers.get(j);
                        if (!recoveredServerNameSet.contains(failedServer)) continue;
                        String tmpPath = ZKUtil.joinZNode(nodePath, failedServer);
                        ZKUtil.deleteNode(this.watcher, tmpPath);
                    }
                }
            }
        }
        catch (KeeperException ke) {
            LOG.warn((Object)"removeRecoveringRegionsFromZK got zookeeper exception. Will retry", (Throwable)ke);
            throw new IOException(ke);
        }
    }

    private void deleteNode(String path, Long retries) {
        SplitLogCounters.tot_mgr_node_delete_queued.incrementAndGet();
        this.watcher.getRecoverableZooKeeper().getZooKeeper().delete(path, -1, new DeleteAsyncCallback(), retries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNodeSuccess(String path) {
        if (this.ignoreZKDeleteForTesting) {
            return;
        }
        SplitLogManager.Task task = (SplitLogManager.Task)this.details.getTasks().remove(path);
        if (task == null) {
            if (ZKSplitLog.isRescanNode(this.watcher, path)) {
                SplitLogCounters.tot_mgr_rescan_deleted.incrementAndGet();
            }
            SplitLogCounters.tot_mgr_missing_state_in_delete.incrementAndGet();
            LOG.debug((Object)("deleted task without in memory state " + path));
            return;
        }
        SplitLogManager.Task task2 = task;
        synchronized (task2) {
            task.status = SplitLogManager.TerminationStatus.DELETED;
            task.notify();
        }
        SplitLogCounters.tot_mgr_task_deleted.incrementAndGet();
    }

    private void deleteNodeFailure(String path) {
        LOG.info((Object)("Failed to delete node " + path + " and will retry soon."));
    }

    private void createRescanSuccess(String path) {
        SplitLogCounters.tot_mgr_rescan.incrementAndGet();
        this.getDataSetWatch(path, this.zkretries);
    }

    private void createRescanFailure() {
        LOG.fatal((Object)"logic failure, rescan failure must not happen");
    }

    private boolean needAbandonRetries(int statusCode, String action) {
        if (statusCode == KeeperException.Code.SESSIONEXPIRED.intValue()) {
            LOG.error((Object)("ZK session expired. Master is expected to shut down. Abandoning retries for action=" + action));
            return true;
        }
        return false;
    }

    private void createNode(String path, Long retry_count) {
        SplitLogTask.Unassigned slt = new SplitLogTask.Unassigned(this.details.getServerName(), this.getRecoveryMode());
        ZKUtil.asyncCreate(this.watcher, path, slt.toByteArray(), new CreateAsyncCallback(), retry_count);
        SplitLogCounters.tot_mgr_node_create_queued.incrementAndGet();
    }

    private void createNodeSuccess(String path) {
        LOG.debug((Object)("put up splitlog task at znode " + path));
        this.getDataSetWatch(path, this.zkretries);
    }

    private void createNodeFailure(String path) {
        LOG.warn((Object)("failed to create task node" + path));
        this.setDone(path, SplitLogManager.TerminationStatus.FAILURE);
    }

    private void getDataSetWatch(String path, Long retry_count) {
        this.watcher.getRecoverableZooKeeper().getZooKeeper().getData(path, this.watcher, (AsyncCallback.DataCallback)new GetDataAsyncCallback(), (Object)retry_count);
        SplitLogCounters.tot_mgr_get_data_queued.incrementAndGet();
    }

    private void getDataSetWatchSuccess(String path, byte[] data, int version) throws DeserializationException {
        if (data == null) {
            if (version == Integer.MIN_VALUE) {
                this.setDone(path, SplitLogManager.TerminationStatus.SUCCESS);
                return;
            }
            SplitLogCounters.tot_mgr_null_data.incrementAndGet();
            LOG.fatal((Object)("logic error - got null data " + path));
            this.setDone(path, SplitLogManager.TerminationStatus.FAILURE);
            return;
        }
        data = this.watcher.getRecoverableZooKeeper().removeMetaData(data);
        SplitLogTask slt = SplitLogTask.parseFrom(data);
        if (slt.isUnassigned()) {
            LOG.debug((Object)("task not yet acquired " + path + " ver = " + version));
            this.handleUnassignedTask(path);
        } else if (slt.isOwned()) {
            this.heartbeat(path, version, slt.getServerName());
        } else if (slt.isResigned()) {
            LOG.info((Object)("task " + path + " entered state: " + slt.toString()));
            this.resubmitOrFail(path, SplitLogManager.ResubmitDirective.FORCE);
        } else if (slt.isDone()) {
            LOG.info((Object)("task " + path + " entered state: " + slt.toString()));
            if (this.taskFinisher != null && !ZKSplitLog.isRescanNode(this.watcher, path)) {
                if (this.taskFinisher.finish(slt.getServerName(), ZKSplitLog.getFileName(path)) == TaskFinisher.Status.DONE) {
                    this.setDone(path, SplitLogManager.TerminationStatus.SUCCESS);
                } else {
                    this.resubmitOrFail(path, SplitLogManager.ResubmitDirective.CHECK);
                }
            } else {
                this.setDone(path, SplitLogManager.TerminationStatus.SUCCESS);
            }
        } else if (slt.isErr()) {
            LOG.info((Object)("task " + path + " entered state: " + slt.toString()));
            this.resubmitOrFail(path, SplitLogManager.ResubmitDirective.CHECK);
        } else {
            LOG.fatal((Object)("logic error - unexpected zk state for path = " + path + " data = " + slt.toString()));
            this.setDone(path, SplitLogManager.TerminationStatus.FAILURE);
        }
    }

    private void resubmitOrFail(String path, SplitLogManager.ResubmitDirective directive) {
        if (!this.resubmitTask(path, this.findOrCreateOrphanTask(path), directive)) {
            this.setDone(path, SplitLogManager.TerminationStatus.FAILURE);
        }
    }

    private void getDataSetWatchFailure(String path) {
        LOG.warn((Object)("failed to set data watch " + path));
        this.setDone(path, SplitLogManager.TerminationStatus.FAILURE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDone(String path, SplitLogManager.TerminationStatus status) {
        SplitLogManager.Task task = (SplitLogManager.Task)this.details.getTasks().get(path);
        if (task == null) {
            if (!ZKSplitLog.isRescanNode(this.watcher, path)) {
                SplitLogCounters.tot_mgr_unacquired_orphan_done.incrementAndGet();
                LOG.debug((Object)("unacquired orphan task is done " + path));
            }
        } else {
            SplitLogManager.Task task2 = task;
            synchronized (task2) {
                if (task.status == SplitLogManager.TerminationStatus.IN_PROGRESS) {
                    if (status == SplitLogManager.TerminationStatus.SUCCESS) {
                        SplitLogCounters.tot_mgr_log_split_success.incrementAndGet();
                        LOG.info((Object)("Done splitting " + path));
                    } else {
                        SplitLogCounters.tot_mgr_log_split_err.incrementAndGet();
                        LOG.warn((Object)("Error splitting " + path));
                    }
                    task.status = status;
                    if (task.batch != null) {
                        SplitLogManager.TaskBatch taskBatch = task.batch;
                        synchronized (taskBatch) {
                            if (status == SplitLogManager.TerminationStatus.SUCCESS) {
                                ++task.batch.done;
                            } else {
                                ++task.batch.error;
                            }
                            task.batch.notify();
                        }
                    }
                }
            }
        }
        this.deleteNode(path, this.zkretries);
    }

    SplitLogManager.Task findOrCreateOrphanTask(String path) {
        SplitLogManager.Task orphanTask = new SplitLogManager.Task();
        SplitLogManager.Task task = this.details.getTasks().putIfAbsent(path, orphanTask);
        if (task == null) {
            LOG.info((Object)("creating orphan task " + path));
            SplitLogCounters.tot_mgr_orphan_task_acquired.incrementAndGet();
            task = orphanTask;
        }
        return task;
    }

    private void heartbeat(String path, int new_version, ServerName workerName) {
        SplitLogManager.Task task = this.findOrCreateOrphanTask(path);
        if (new_version != task.last_version) {
            if (task.isUnassigned()) {
                LOG.info((Object)("task " + path + " acquired by " + workerName));
            }
            task.heartbeat(EnvironmentEdgeManager.currentTime(), new_version, workerName);
            SplitLogCounters.tot_mgr_heartbeat.incrementAndGet();
        }
    }

    private void lookForOrphans() {
        List<String> orphans;
        try {
            orphans = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.splitLogZNode);
            if (orphans == null) {
                LOG.warn((Object)("could not get children of " + this.watcher.splitLogZNode));
                return;
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)("could not get children of " + this.watcher.splitLogZNode + " " + StringUtils.stringifyException(e)));
            return;
        }
        int rescan_nodes = 0;
        int listSize = orphans.size();
        for (int i = 0; i < listSize; ++i) {
            String path = orphans.get(i);
            String nodepath = ZKUtil.joinZNode(this.watcher.splitLogZNode, path);
            if (ZKSplitLog.isRescanNode(this.watcher, nodepath)) {
                ++rescan_nodes;
                LOG.debug((Object)("found orphan rescan node " + path));
            } else {
                LOG.info((Object)("found orphan task " + path));
            }
            this.getDataSetWatch(nodepath, this.zkretries);
        }
        LOG.info((Object)("Found " + (orphans.size() - rescan_nodes) + " orphan tasks and " + rescan_nodes + " rescan nodes"));
    }

    @Override
    public void markRegionsRecovering(ServerName serverName, Set<HRegionInfo> userRegions) throws IOException, InterruptedIOException {
        this.lastRecoveringNodeCreationTime = EnvironmentEdgeManager.currentTime();
        block5: for (HRegionInfo region : userRegions) {
            String regionEncodeName = region.getEncodedName();
            long retries = this.zkretries;
            do {
                String nodePath = ZKUtil.joinZNode(this.watcher.recoveringRegionsZNode, regionEncodeName);
                long lastRecordedFlushedSequenceId = -1L;
                try {
                    long lastSequenceId = this.details.getMaster().getServerManager().getLastFlushedSequenceId(regionEncodeName.getBytes()).getLastFlushedSequenceId();
                    byte[] data = ZKUtil.getData(this.watcher, nodePath);
                    if (data == null) {
                        ZKUtil.createSetData(this.watcher, nodePath, ZKUtil.positionToByteArray(lastSequenceId));
                    } else {
                        lastRecordedFlushedSequenceId = ZKSplitLog.parseLastFlushedSequenceIdFrom(data);
                        if (lastRecordedFlushedSequenceId < lastSequenceId) {
                            ZKUtil.setData(this.watcher, nodePath, ZKUtil.positionToByteArray(lastSequenceId));
                        }
                    }
                    nodePath = ZKUtil.joinZNode(nodePath, serverName.getServerName());
                    if (lastSequenceId <= lastRecordedFlushedSequenceId) {
                        lastSequenceId = lastRecordedFlushedSequenceId;
                    }
                    ZKUtil.createSetData(this.watcher, nodePath, ZKUtil.regionSequenceIdsToByteArray(lastSequenceId, null));
                    if (!LOG.isDebugEnabled()) continue block5;
                    LOG.debug((Object)("Marked " + regionEncodeName + " as recovering from " + serverName + ": " + nodePath));
                    continue block5;
                }
                catch (KeeperException e) {
                    if (retries <= 1L) {
                        throw new IOException(e);
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e1) {
                        throw new InterruptedIOException();
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            } while (--retries > 0L);
        }
    }

    @Override
    public void nodeDataChanged(String path) {
        SplitLogManager.Task task = (SplitLogManager.Task)this.details.getTasks().get(path);
        if (task != null || ZKSplitLog.isRescanNode(this.watcher, path)) {
            if (task != null) {
                task.heartbeatNoDetails(EnvironmentEdgeManager.currentTime());
            }
            this.getDataSetWatch(path, this.zkretries);
        }
    }

    @Override
    public void removeStaleRecoveringRegions(Set<String> knownFailedServers) throws IOException, InterruptedIOException {
        try {
            List<String> regions;
            List<String> tasks = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.splitLogZNode);
            if (tasks != null) {
                int listSize = tasks.size();
                for (int i = 0; i < listSize; ++i) {
                    ServerName serverName;
                    byte[] data;
                    String t = tasks.get(i);
                    try {
                        data = ZKUtil.getData(this.watcher, ZKUtil.joinZNode(this.watcher.splitLogZNode, t));
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                    if (data != null) {
                        SplitLogTask slt = null;
                        try {
                            slt = SplitLogTask.parseFrom(data);
                        }
                        catch (DeserializationException e) {
                            LOG.warn((Object)("Failed parse data for znode " + t), (Throwable)e);
                        }
                        if (slt != null && slt.isDone()) continue;
                    }
                    if ((serverName = DefaultWALProvider.getServerNameFromWALDirectoryName(new Path(t = ZKSplitLog.getFileName(t)))) != null) {
                        knownFailedServers.add(serverName.getServerName());
                        continue;
                    }
                    LOG.warn((Object)("Found invalid WAL log file name:" + t));
                }
            }
            if ((regions = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.recoveringRegionsZNode)) != null) {
                int listSize = regions.size();
                for (int i = 0; i < listSize; ++i) {
                    String nodePath = ZKUtil.joinZNode(this.watcher.recoveringRegionsZNode, regions.get(i));
                    List<String> regionFailedServers = ZKUtil.listChildrenNoWatch(this.watcher, nodePath);
                    if (regionFailedServers == null || regionFailedServers.isEmpty()) {
                        ZKUtil.deleteNode(this.watcher, nodePath);
                        continue;
                    }
                    boolean needMoreRecovery = false;
                    int tmpFailedServerSize = regionFailedServers.size();
                    for (int j = 0; j < tmpFailedServerSize; ++j) {
                        if (!knownFailedServers.contains(regionFailedServers.get(j))) continue;
                        needMoreRecovery = true;
                        break;
                    }
                    if (needMoreRecovery) continue;
                    ZKUtil.deleteNodeRecursively(this.watcher, nodePath);
                }
            }
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
    }

    @Override
    public synchronized boolean isReplaying() {
        return this.recoveryMode == ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY;
    }

    @Override
    public synchronized boolean isSplitting() {
        return this.recoveryMode == ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING;
    }

    private List<String> listSplitLogTasks() throws KeeperException {
        List<String> taskOrRescanList = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.splitLogZNode);
        if (taskOrRescanList == null || taskOrRescanList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> taskList = new ArrayList<String>();
        for (String taskOrRescan : taskOrRescanList) {
            if (ZKSplitLog.isRescanNode(taskOrRescan)) continue;
            taskList.add(taskOrRescan);
        }
        return taskList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecoveryMode(boolean isForInitialization) throws IOException {
        ZooKeeperProtos.SplitLogTask.RecoveryMode recoveryModeInConfig;
        ZooKeeperProtos.SplitLogTask.RecoveryMode previousRecoveryMode;
        boolean hasRecoveringRegions;
        boolean hasSplitLogTask;
        block24: {
            ZKSplitLogManagerCoordination zKSplitLogManagerCoordination = this;
            synchronized (zKSplitLogManagerCoordination) {
                if (this.isDrainingDone) {
                    return;
                }
            }
            if (this.watcher == null) {
                zKSplitLogManagerCoordination = this;
                synchronized (zKSplitLogManagerCoordination) {
                    this.isDrainingDone = true;
                    this.recoveryMode = ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING;
                }
                return;
            }
            hasSplitLogTask = false;
            hasRecoveringRegions = false;
            previousRecoveryMode = ZooKeeperProtos.SplitLogTask.RecoveryMode.UNKNOWN;
            recoveryModeInConfig = this.isDistributedLogReplay(this.conf) ? ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY : ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING;
            try {
                List<String> tasks;
                List<String> regions = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.recoveringRegionsZNode);
                if (regions != null && !regions.isEmpty()) {
                    hasRecoveringRegions = true;
                    previousRecoveryMode = ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY;
                }
                if (previousRecoveryMode != ZooKeeperProtos.SplitLogTask.RecoveryMode.UNKNOWN || (tasks = this.listSplitLogTasks()).isEmpty()) break block24;
                hasSplitLogTask = true;
                if (!isForInitialization) break block24;
                int listSize = tasks.size();
                for (int i = 0; i < listSize; ++i) {
                    String task = tasks.get(i);
                    try {
                        byte[] data = ZKUtil.getData(this.watcher, ZKUtil.joinZNode(this.watcher.splitLogZNode, task));
                        if (data == null) continue;
                        SplitLogTask slt = SplitLogTask.parseFrom(data);
                        previousRecoveryMode = slt.getMode();
                        if (previousRecoveryMode == ZooKeeperProtos.SplitLogTask.RecoveryMode.UNKNOWN) {
                            previousRecoveryMode = ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING;
                        }
                        break;
                    }
                    catch (DeserializationException e) {
                        LOG.warn((Object)("Failed parse data for znode " + task), (Throwable)e);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
            }
            catch (KeeperException e) {
                throw new IOException(e);
            }
        }
        ZKSplitLogManagerCoordination zKSplitLogManagerCoordination = this;
        synchronized (zKSplitLogManagerCoordination) {
            if (this.isDrainingDone) {
                return;
            }
            if (!hasSplitLogTask && !hasRecoveringRegions) {
                this.isDrainingDone = true;
                this.recoveryMode = recoveryModeInConfig;
                return;
            }
            if (!isForInitialization) {
                return;
            }
            if (previousRecoveryMode != ZooKeeperProtos.SplitLogTask.RecoveryMode.UNKNOWN) {
                this.isDrainingDone = previousRecoveryMode == recoveryModeInConfig;
                this.recoveryMode = previousRecoveryMode;
            } else {
                this.recoveryMode = recoveryModeInConfig;
            }
        }
    }

    private boolean isDistributedLogReplay(Configuration conf) {
        boolean dlr = conf.getBoolean("hbase.master.distributed.log.replay", false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Distributed log replay=" + dlr));
        }
        return dlr;
    }

    private boolean resubmit(ServerName serverName, String path, int version) {
        try {
            SplitLogTask.Unassigned slt = new SplitLogTask.Unassigned(this.details.getServerName(), this.getRecoveryMode());
            if (!ZKUtil.setData(this.watcher, path, slt.toByteArray(), version)) {
                LOG.debug((Object)("failed to resubmit task " + path + " version changed"));
                return false;
            }
        }
        catch (KeeperException.NoNodeException e) {
            LOG.warn((Object)("failed to resubmit because znode doesn't exist " + path + " task done (or forced done by removing the znode)"));
            try {
                this.getDataSetWatchSuccess(path, null, Integer.MIN_VALUE);
            }
            catch (DeserializationException e1) {
                LOG.debug((Object)("Failed to re-resubmit task " + path + " because of deserialization issue"), (Throwable)e1);
                return false;
            }
            return false;
        }
        catch (KeeperException.BadVersionException e) {
            LOG.debug((Object)("failed to resubmit task " + path + " version changed"));
            return false;
        }
        catch (KeeperException e) {
            SplitLogCounters.tot_mgr_resubmit_failed.incrementAndGet();
            LOG.warn((Object)("failed to resubmit " + path), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void setDetails(SplitLogManagerCoordination.SplitLogManagerDetails details) {
        this.details = details;
    }

    @Override
    public SplitLogManagerCoordination.SplitLogManagerDetails getDetails() {
        return this.details;
    }

    @Override
    public synchronized ZooKeeperProtos.SplitLogTask.RecoveryMode getRecoveryMode() {
        return this.recoveryMode;
    }

    @Override
    public long getLastRecoveryTime() {
        return this.lastRecoveringNodeCreationTime;
    }

    public void setIgnoreDeleteForTesting(boolean b) {
        this.ignoreZKDeleteForTesting = b;
    }

    public class CreateRescanAsyncCallback
    implements AsyncCallback.StringCallback {
        private final Log LOG = LogFactory.getLog(CreateRescanAsyncCallback.class);

        @Override
        public void processResult(int rc, String path, Object ctx, String name) {
            if (rc != 0) {
                if (ZKSplitLogManagerCoordination.this.needAbandonRetries(rc, "CreateRescan znode " + path)) {
                    return;
                }
                Long retry_count = (Long)ctx;
                this.LOG.warn((Object)("rc=" + KeeperException.Code.get(rc) + " for " + path + " remaining retries=" + retry_count));
                if (retry_count == 0L) {
                    ZKSplitLogManagerCoordination.this.createRescanFailure();
                } else {
                    ZKSplitLogManagerCoordination.this.rescan(retry_count - 1L);
                }
                return;
            }
            ZKSplitLogManagerCoordination.this.createRescanSuccess(name);
        }
    }

    public class DeleteAsyncCallback
    implements AsyncCallback.VoidCallback {
        private final Log LOG = LogFactory.getLog(DeleteAsyncCallback.class);

        @Override
        public void processResult(int rc, String path, Object ctx) {
            SplitLogCounters.tot_mgr_node_delete_result.incrementAndGet();
            if (rc != 0) {
                if (ZKSplitLogManagerCoordination.this.needAbandonRetries(rc, "Delete znode " + path)) {
                    ZKSplitLogManagerCoordination.this.details.getFailedDeletions().add(path);
                    return;
                }
                if (rc != KeeperException.Code.NONODE.intValue()) {
                    SplitLogCounters.tot_mgr_node_delete_err.incrementAndGet();
                    Long retry_count = (Long)ctx;
                    this.LOG.warn((Object)("delete rc=" + KeeperException.Code.get(rc) + " for " + path + " remaining retries=" + retry_count));
                    if (retry_count == 0L) {
                        this.LOG.warn((Object)("delete failed " + path));
                        ZKSplitLogManagerCoordination.this.details.getFailedDeletions().add(path);
                        ZKSplitLogManagerCoordination.this.deleteNodeFailure(path);
                    } else {
                        ZKSplitLogManagerCoordination.this.deleteNode(path, retry_count - 1L);
                    }
                    return;
                }
                this.LOG.info((Object)(path + " does not exist. Either was created but deleted behind our" + " back by another pending delete OR was deleted" + " in earlier retry rounds. zkretries = " + ctx));
            } else {
                this.LOG.debug((Object)("deleted " + path));
            }
            ZKSplitLogManagerCoordination.this.deleteNodeSuccess(path);
        }
    }

    public class GetDataAsyncCallback
    implements AsyncCallback.DataCallback {
        private final Log LOG = LogFactory.getLog(GetDataAsyncCallback.class);

        @Override
        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            SplitLogCounters.tot_mgr_get_data_result.incrementAndGet();
            if (rc != 0) {
                if (ZKSplitLogManagerCoordination.this.needAbandonRetries(rc, "GetData from znode " + path)) {
                    return;
                }
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    SplitLogCounters.tot_mgr_get_data_nonode.incrementAndGet();
                    this.LOG.warn((Object)("task znode " + path + " vanished or not created yet."));
                    return;
                }
                Long retry_count = (Long)ctx;
                if (retry_count < 0L) {
                    this.LOG.warn((Object)("getdata rc = " + KeeperException.Code.get(rc) + " " + path + ". Ignoring error. No error handling. No retrying."));
                    return;
                }
                this.LOG.warn((Object)("getdata rc = " + KeeperException.Code.get(rc) + " " + path + " remaining retries=" + retry_count));
                if (retry_count == 0L) {
                    SplitLogCounters.tot_mgr_get_data_err.incrementAndGet();
                    ZKSplitLogManagerCoordination.this.getDataSetWatchFailure(path);
                } else {
                    SplitLogCounters.tot_mgr_get_data_retry.incrementAndGet();
                    ZKSplitLogManagerCoordination.this.getDataSetWatch(path, retry_count - 1L);
                }
                return;
            }
            try {
                ZKSplitLogManagerCoordination.this.getDataSetWatchSuccess(path, data, stat.getVersion());
            }
            catch (DeserializationException e) {
                this.LOG.warn((Object)"Deserialization problem", (Throwable)e);
            }
        }
    }

    public class CreateAsyncCallback
    implements AsyncCallback.StringCallback {
        private final Log LOG = LogFactory.getLog(CreateAsyncCallback.class);

        @Override
        public void processResult(int rc, String path, Object ctx, String name) {
            SplitLogCounters.tot_mgr_node_create_result.incrementAndGet();
            if (rc != 0) {
                if (ZKSplitLogManagerCoordination.this.needAbandonRetries(rc, "Create znode " + path)) {
                    ZKSplitLogManagerCoordination.this.createNodeFailure(path);
                    return;
                }
                if (rc == KeeperException.Code.NODEEXISTS.intValue()) {
                    this.LOG.debug((Object)("found pre-existing znode " + path));
                    SplitLogCounters.tot_mgr_node_already_exists.incrementAndGet();
                } else {
                    Long retry_count = (Long)ctx;
                    this.LOG.warn((Object)("create rc =" + KeeperException.Code.get(rc) + " for " + path + " remaining retries=" + retry_count));
                    if (retry_count == 0L) {
                        SplitLogCounters.tot_mgr_node_create_err.incrementAndGet();
                        ZKSplitLogManagerCoordination.this.createNodeFailure(path);
                    } else {
                        SplitLogCounters.tot_mgr_node_create_retry.incrementAndGet();
                        ZKSplitLogManagerCoordination.this.createNode(path, retry_count - 1L);
                    }
                    return;
                }
            }
            ZKSplitLogManagerCoordination.this.createNodeSuccess(path);
        }
    }

    public static interface TaskFinisher {
        public Status finish(ServerName var1, String var2);

        public static enum Status {
            DONE,
            ERR;

        }
    }

    public static class ZkSplitLogManagerDetails
    extends SplitLogManagerCoordination.SplitLogManagerDetails {
        ZkSplitLogManagerDetails(ConcurrentMap<String, SplitLogManager.Task> tasks, MasterServices master, Set<String> failedDeletions, ServerName serverName) {
            super(tasks, master, failedDeletions, serverName);
        }
    }
}

