/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatImpl;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TableSnapshotInputFormat
implements InputFormat<ImmutableBytesWritable, Result> {
    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        List<TableSnapshotInputFormatImpl.InputSplit> splits = TableSnapshotInputFormatImpl.getSplits(job);
        InputSplit[] results = new InputSplit[splits.size()];
        for (int i = 0; i < splits.size(); ++i) {
            results[i] = new TableSnapshotRegionSplit(splits.get(i));
        }
        return results;
    }

    @Override
    public RecordReader<ImmutableBytesWritable, Result> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new TableSnapshotRecordReader((TableSnapshotRegionSplit)split, job);
    }

    public static void setInput(JobConf job, String snapshotName, Path restoreDir) throws IOException {
        TableSnapshotInputFormatImpl.setInput(job, snapshotName, restoreDir);
    }

    static class TableSnapshotRecordReader
    implements RecordReader<ImmutableBytesWritable, Result> {
        private TableSnapshotInputFormatImpl.RecordReader delegate = new TableSnapshotInputFormatImpl.RecordReader();

        public TableSnapshotRecordReader(TableSnapshotRegionSplit split, JobConf job) throws IOException {
            this.delegate.initialize(split.delegate, job);
        }

        @Override
        public boolean next(ImmutableBytesWritable key, Result value) throws IOException {
            if (!this.delegate.nextKeyValue()) {
                return false;
            }
            ImmutableBytesWritable currentKey = this.delegate.getCurrentKey();
            key.set(currentKey.get(), currentKey.getOffset(), currentKey.getLength());
            value.copyFrom(this.delegate.getCurrentValue());
            return true;
        }

        @Override
        public ImmutableBytesWritable createKey() {
            return new ImmutableBytesWritable();
        }

        @Override
        public Result createValue() {
            return new Result();
        }

        @Override
        public long getPos() throws IOException {
            return this.delegate.getPos();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public float getProgress() throws IOException {
            return this.delegate.getProgress();
        }
    }

    public static class TableSnapshotRegionSplit
    implements InputSplit {
        private TableSnapshotInputFormatImpl.InputSplit delegate;

        public TableSnapshotRegionSplit() {
            this.delegate = new TableSnapshotInputFormatImpl.InputSplit();
        }

        public TableSnapshotRegionSplit(TableSnapshotInputFormatImpl.InputSplit delegate) {
            this.delegate = delegate;
        }

        public TableSnapshotRegionSplit(HTableDescriptor htd, HRegionInfo regionInfo, List<String> locations) {
            this.delegate = new TableSnapshotInputFormatImpl.InputSplit(htd, regionInfo, locations);
        }

        @Override
        public long getLength() throws IOException {
            return this.delegate.getLength();
        }

        @Override
        public String[] getLocations() throws IOException {
            return this.delegate.getLocations();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            this.delegate.write(out);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.delegate.readFields(in);
        }
    }
}

