/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.MasterDDLOperationHelper;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class ModifyTableProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.ModifyTableState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(ModifyTableProcedure.class);
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private HTableDescriptor unmodifiedHTableDescriptor = null;
    private HTableDescriptor modifiedHTableDescriptor;
    private UserGroupInformation user;
    private boolean deleteColumnFamilyInModify;
    private List<HRegionInfo> regionInfoList;
    private Boolean traceEnabled = null;

    public ModifyTableProcedure() {
        this.initilize();
    }

    public ModifyTableProcedure(MasterProcedureEnv env, HTableDescriptor htd) {
        this.initilize();
        this.modifiedHTableDescriptor = htd;
        this.user = env.getRequestUser().getUGI();
        this.setOwner(this.user.getShortUserName());
    }

    private void initilize() {
        this.unmodifiedHTableDescriptor = null;
        this.regionInfoList = null;
        this.traceEnabled = null;
        this.deleteColumnFamilyInModify = false;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case MODIFY_TABLE_PREPARE: {
                    this.prepareModify(env);
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_PRE_OPERATION);
                    break;
                }
                case MODIFY_TABLE_PRE_OPERATION: {
                    this.preModify(env, state);
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_UPDATE_TABLE_DESCRIPTOR);
                    break;
                }
                case MODIFY_TABLE_UPDATE_TABLE_DESCRIPTOR: {
                    this.updateTableDescriptor(env);
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_REMOVE_REPLICA_COLUMN);
                    break;
                }
                case MODIFY_TABLE_REMOVE_REPLICA_COLUMN: {
                    this.updateReplicaColumnsIfNeeded(env, this.unmodifiedHTableDescriptor, this.modifiedHTableDescriptor);
                    if (this.deleteColumnFamilyInModify) {
                        this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_DELETE_FS_LAYOUT);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_POST_OPERATION);
                    break;
                }
                case MODIFY_TABLE_DELETE_FS_LAYOUT: {
                    this.deleteFromFs(env, this.unmodifiedHTableDescriptor, this.modifiedHTableDescriptor);
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_POST_OPERATION);
                    break;
                }
                case MODIFY_TABLE_POST_OPERATION: {
                    this.postModify(env, state);
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_REOPEN_ALL_REGIONS);
                    break;
                }
                case MODIFY_TABLE_REOPEN_ALL_REGIONS: {
                    this.reOpenAllRegionsIfTableIsOnline(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException | InterruptedException e) {
            if (!this.isRollbackSupported(state)) {
                LOG.warn((Object)("Error trying to modify table=" + this.getTableName() + " state=" + state), (Throwable)e);
            }
            LOG.error((Object)("Error trying to modify table=" + this.getTableName() + " state=" + state), (Throwable)e);
            this.setFailure("master-modify-table", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws IOException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " rollback state=" + state));
        }
        try {
            switch (state) {
                case MODIFY_TABLE_REOPEN_ALL_REGIONS: {
                    break;
                }
                case MODIFY_TABLE_POST_OPERATION: {
                    break;
                }
                case MODIFY_TABLE_DELETE_FS_LAYOUT: {
                    assert (this.deleteColumnFamilyInModify);
                    throw new UnsupportedOperationException(this + " rollback of state=" + state + " is unsupported.");
                }
                case MODIFY_TABLE_REMOVE_REPLICA_COLUMN: {
                    this.updateReplicaColumnsIfNeeded(env, this.modifiedHTableDescriptor, this.unmodifiedHTableDescriptor);
                    break;
                }
                case MODIFY_TABLE_UPDATE_TABLE_DESCRIPTOR: {
                    this.restoreTableDescriptor(env);
                    break;
                }
                case MODIFY_TABLE_PRE_OPERATION: {
                    break;
                }
                case MODIFY_TABLE_PREPARE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Fail trying to rollback modify table=" + this.getTableName() + " state=" + state), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected MasterProcedureProtos.ModifyTableState getState(int stateId) {
        return MasterProcedureProtos.ModifyTableState.valueOf(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.ModifyTableState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.ModifyTableState getInitialState() {
        return MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_PREPARE;
    }

    @Override
    protected void setNextState(MasterProcedureProtos.ModifyTableState state) {
        if (this.aborted.get() && this.isRollbackSupported(state)) {
            this.setAbortFailure("modify-table", "abort requested");
        } else {
            super.setNextState(state);
        }
    }

    @Override
    public boolean abort(MasterProcedureEnv env) {
        this.aborted.set(true);
        return true;
    }

    @Override
    protected boolean acquireLock(MasterProcedureEnv env) {
        if (!env.isInitialized()) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireTableWrite(this.getTableName(), EventType.C_M_MODIFY_TABLE.toString());
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseTableWrite(this.getTableName());
    }

    @Override
    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        MasterProcedureProtos.ModifyTableStateData.Builder modifyTableMsg = MasterProcedureProtos.ModifyTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.user)).setModifiedTableSchema(this.modifiedHTableDescriptor.convert()).setDeleteColumnFamilyInModify(this.deleteColumnFamilyInModify);
        if (this.unmodifiedHTableDescriptor != null) {
            modifyTableMsg.setUnmodifiedTableSchema(this.unmodifiedHTableDescriptor.convert());
        }
        modifyTableMsg.build().writeDelimitedTo(stream);
    }

    @Override
    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        MasterProcedureProtos.ModifyTableStateData modifyTableMsg = MasterProcedureProtos.ModifyTableStateData.parseDelimitedFrom(stream);
        this.user = MasterProcedureUtil.toUserInfo(modifyTableMsg.getUserInfo());
        this.modifiedHTableDescriptor = HTableDescriptor.convert(modifyTableMsg.getModifiedTableSchema());
        this.deleteColumnFamilyInModify = modifyTableMsg.getDeleteColumnFamilyInModify();
        if (modifyTableMsg.hasUnmodifiedTableSchema()) {
            this.unmodifiedHTableDescriptor = HTableDescriptor.convert(modifyTableMsg.getUnmodifiedTableSchema());
        }
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.getTableName());
        sb.append(")");
    }

    @Override
    public TableName getTableName() {
        return this.modifiedHTableDescriptor.getTableName();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    private void prepareModify(MasterProcedureEnv env) throws IOException {
        if (!MetaTableAccessor.tableExists(env.getMasterServices().getConnection(), this.getTableName())) {
            throw new TableNotFoundException(this.getTableName());
        }
        this.unmodifiedHTableDescriptor = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        if (env.getMasterServices().getAssignmentManager().getTableStateManager().isTableState(this.getTableName(), ZooKeeperProtos.Table.State.ENABLED)) {
            if (!MasterDDLOperationHelper.isOnlineSchemaChangeAllowed(env)) {
                throw new TableNotDisabledException(this.getTableName());
            }
            if (this.modifiedHTableDescriptor.getRegionReplication() != this.unmodifiedHTableDescriptor.getRegionReplication()) {
                throw new IOException("REGION_REPLICATION change is not supported for enabled tables");
            }
        }
        Set<byte[]> oldFamilies = this.unmodifiedHTableDescriptor.getFamiliesKeys();
        Set<byte[]> newFamilies = this.modifiedHTableDescriptor.getFamiliesKeys();
        for (byte[] familyName : oldFamilies) {
            if (newFamilies.contains(familyName)) continue;
            this.deleteColumnFamilyInModify = true;
            break;
        }
    }

    private void preModify(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void updateTableDescriptor(MasterProcedureEnv env) throws IOException {
        env.getMasterServices().getTableDescriptors().add(this.modifiedHTableDescriptor);
    }

    private void restoreTableDescriptor(MasterProcedureEnv env) throws IOException {
        env.getMasterServices().getTableDescriptors().add(this.unmodifiedHTableDescriptor);
        this.deleteFromFs(env, this.modifiedHTableDescriptor, this.unmodifiedHTableDescriptor);
        this.reOpenAllRegionsIfTableIsOnline(env);
    }

    private void deleteFromFs(MasterProcedureEnv env, HTableDescriptor oldHTableDescriptor, HTableDescriptor newHTableDescriptor) throws IOException {
        Set<byte[]> oldFamilies = oldHTableDescriptor.getFamiliesKeys();
        Set<byte[]> newFamilies = newHTableDescriptor.getFamiliesKeys();
        for (byte[] familyName : oldFamilies) {
            if (newFamilies.contains(familyName)) continue;
            MasterDDLOperationHelper.deleteColumnFamilyFromFileSystem(env, this.getTableName(), this.getRegionInfoList(env), familyName);
        }
    }

    private void updateReplicaColumnsIfNeeded(MasterProcedureEnv env, HTableDescriptor oldHTableDescriptor, HTableDescriptor newHTableDescriptor) throws IOException {
        int oldReplicaCount = oldHTableDescriptor.getRegionReplication();
        int newReplicaCount = newHTableDescriptor.getRegionReplication();
        if (newReplicaCount < oldReplicaCount) {
            HashSet<byte[]> tableRows = new HashSet<byte[]>();
            ClusterConnection connection = env.getMasterServices().getConnection();
            Scan scan = MetaTableAccessor.getScanForTableName(this.getTableName());
            scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            try (Table metaTable = connection.getTable(TableName.META_TABLE_NAME);){
                ResultScanner resScanner = metaTable.getScanner(scan);
                for (Result result : resScanner) {
                    tableRows.add(result.getRow());
                }
                MetaTableAccessor.removeRegionReplicasFromMeta(tableRows, newReplicaCount, oldReplicaCount - newReplicaCount, connection);
            }
        }
        if (newReplicaCount > 1 && oldReplicaCount <= 1) {
            ServerRegionReplicaUtil.setupRegionReplicaReplication(env.getMasterConfiguration());
        }
    }

    private void postModify(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void reOpenAllRegionsIfTableIsOnline(MasterProcedureEnv env) throws IOException {
        if (!env.getMasterServices().getAssignmentManager().getTableStateManager().isTableState(this.getTableName(), ZooKeeperProtos.Table.State.ENABLED)) {
            return;
        }
        if (MasterDDLOperationHelper.reOpenAllRegions(env, this.getTableName(), this.getRegionInfoList(env))) {
            LOG.info((Object)("Completed modify table operation on table " + this.getTableName()));
        } else {
            LOG.warn((Object)("Error on reopening the regions on table " + this.getTableName()));
        }
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }

    private void runCoprocessorAction(MasterProcedureEnv env, final MasterProcedureProtos.ModifyTableState state) throws IOException, InterruptedException {
        final MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            this.user.doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    switch (state) {
                        case MODIFY_TABLE_PRE_OPERATION: {
                            cpHost.preModifyTableHandler(ModifyTableProcedure.this.getTableName(), ModifyTableProcedure.this.modifiedHTableDescriptor);
                            break;
                        }
                        case MODIFY_TABLE_POST_OPERATION: {
                            cpHost.postModifyTableHandler(ModifyTableProcedure.this.getTableName(), ModifyTableProcedure.this.modifiedHTableDescriptor);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(this + " unhandled state=" + state);
                        }
                    }
                    return null;
                }
            });
        }
    }

    private boolean isRollbackSupported(MasterProcedureProtos.ModifyTableState state) {
        if (this.deleteColumnFamilyInModify) {
            switch (state) {
                case MODIFY_TABLE_DELETE_FS_LAYOUT: 
                case MODIFY_TABLE_POST_OPERATION: 
                case MODIFY_TABLE_REOPEN_ALL_REGIONS: {
                    return false;
                }
            }
        }
        return true;
    }

    private List<HRegionInfo> getRegionInfoList(MasterProcedureEnv env) throws IOException {
        if (this.regionInfoList == null) {
            this.regionInfoList = ProcedureSyncWait.getRegionsFromMeta(env, this.getTableName());
        }
        return this.regionInfoList;
    }
}

