/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionMergeTransactionImpl;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
class RegionMergeRequest
implements Runnable {
    static final Log LOG = LogFactory.getLog(RegionMergeRequest.class);
    private final HRegion region_a;
    private final HRegion region_b;
    private final HRegionServer server;
    private final boolean forcible;
    private TableLockManager.TableLock tableLock;
    private final long masterSystemTime;
    private final User user;

    RegionMergeRequest(Region a, Region b, HRegionServer hrs, boolean forcible, long masterSystemTime, User user) {
        Preconditions.checkNotNull(hrs);
        this.region_a = (HRegion)a;
        this.region_b = (HRegion)b;
        this.server = hrs;
        this.forcible = forcible;
        this.masterSystemTime = masterSystemTime;
        this.user = user;
    }

    public String toString() {
        return "MergeRequest,regions:" + this.region_a + ", " + this.region_b + ", forcible=" + this.forcible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block21: {
            if (this.server.isStopping() || this.server.isStopped()) {
                LOG.debug((Object)("Skipping merge because server is stopping=" + this.server.isStopping() + " or stopped=" + this.server.isStopped()));
                return;
            }
            try {
                long startTime = EnvironmentEdgeManager.currentTime();
                RegionMergeTransactionImpl mt = new RegionMergeTransactionImpl(this.region_a, this.region_b, this.forcible, this.masterSystemTime);
                this.tableLock = this.server.getTableLockManager().readLock(this.region_a.getTableDesc().getTableName(), "MERGE_REGIONS:" + this.region_a.getRegionInfo().getRegionNameAsString() + ", " + this.region_b.getRegionInfo().getRegionNameAsString());
                try {
                    this.tableLock.acquire();
                }
                catch (IOException ex) {
                    this.tableLock = null;
                    throw ex;
                }
                if (!mt.prepare(this.server)) {
                    return;
                }
                try {
                    mt.execute(this.server, this.server, this.user);
                }
                catch (Exception e) {
                    block20: {
                        if (this.server.isStopping() || this.server.isStopped()) {
                            LOG.info((Object)("Skip rollback/cleanup of failed merge of " + this.region_a + " and " + this.region_b + " because server is" + (this.server.isStopping() ? " stopping" : " stopped")), (Throwable)e);
                            this.releaseTableLock();
                            return;
                        }
                        if (!(e instanceof DroppedSnapshotException)) break block20;
                        this.server.abort("Replay of WAL required. Forcing server shutdown", e);
                        this.releaseTableLock();
                        return;
                    }
                    try {
                        LOG.warn((Object)("Running rollback/cleanup of failed merge of " + this.region_a + " and " + this.region_b + "; " + e.getMessage()), (Throwable)e);
                        if (mt.rollback(this.server, this.server)) {
                            LOG.info((Object)("Successful rollback of failed merge of " + this.region_a + " and " + this.region_b));
                        } else {
                            this.server.abort("Abort; we got an error after point-of-no-returnwhen merging " + this.region_a + " and " + this.region_b);
                        }
                    }
                    catch (RuntimeException ee) {
                        String msg = "Failed rollback of failed merge of " + this.region_a + " and " + this.region_b + " -- aborting server";
                        LOG.info((Object)msg, (Throwable)ee);
                        this.server.abort(msg);
                    }
                    this.releaseTableLock();
                    return;
                }
                LOG.info((Object)("Regions merged, hbase:meta updated, and report to master. region_a=" + this.region_a + ", region_b=" + this.region_b + ",merged region=" + mt.getMergedRegionInfo().getRegionNameAsString() + ". Region merge took " + StringUtils.formatTimeDiff(EnvironmentEdgeManager.currentTime(), startTime)));
                break block21;
                {
                    catch (IOException ex) {
                        LOG.error((Object)("Merge failed " + this), (Throwable)RemoteExceptionHandler.checkIOException(ex));
                        this.server.checkFileSystem();
                        break block21;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.releaseTableLock();
            }
        }
    }

    protected void releaseTableLock() {
        if (this.tableLock != null) {
            try {
                this.tableLock.release();
            }
            catch (IOException ex) {
                LOG.error((Object)"Could not release the table lock (something is really wrong). Aborting this server to avoid holding the lock forever.");
                this.server.abort("Abort; we got an error when releasing the table lock on " + this.region_a.getRegionInfo().getRegionNameAsString());
            }
        }
    }
}

