/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.compactions.OffPeakHours;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class PressureAwareCompactionThroughputController
extends Configured
implements CompactionThroughputController,
Stoppable {
    private static final Log LOG = LogFactory.getLog(PressureAwareCompactionThroughputController.class);
    public static final String HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_HIGHER_BOUND = "hbase.hstore.compaction.throughput.higher.bound";
    private static final long DEFAULT_HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_HIGHER_BOUND = 0x1400000L;
    public static final String HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_LOWER_BOUND = "hbase.hstore.compaction.throughput.lower.bound";
    private static final long DEFAULT_HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_LOWER_BOUND = 0xA00000L;
    public static final String HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_OFFPEAK = "hbase.hstore.compaction.throughput.offpeak";
    private static final long DEFAULT_HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_OFFPEAK = Long.MAX_VALUE;
    public static final String HBASE_HSTORE_COMPACTION_THROUGHPUT_TUNE_PERIOD = "hbase.hstore.compaction.throughput.tune.period";
    private static final int DEFAULT_HSTORE_COMPACTION_THROUGHPUT_TUNE_PERIOD = 60000;
    private long maxThroughputHigherBound;
    private long maxThroughputLowerBound;
    private long maxThroughputOffpeak;
    private OffPeakHours offPeakHours;
    private long controlPerSize;
    private int tuningPeriod;
    volatile double maxThroughput;
    private final ConcurrentMap<String, ActiveCompaction> activeCompactions = new ConcurrentHashMap<String, ActiveCompaction>();
    private volatile boolean stopped = false;

    @Override
    public void setup(final RegionServerServices server) {
        server.getChoreService().scheduleChore(new ScheduledChore("CompactionThroughputTuner", this, this.tuningPeriod){

            @Override
            protected void chore() {
                PressureAwareCompactionThroughputController.this.tune(server.getCompactionPressure());
            }
        });
    }

    private void tune(double compactionPressure) {
        double maxThroughputToSet = compactionPressure > 1.0 ? Double.MAX_VALUE : (this.offPeakHours.isOffPeakHour() ? (double)this.maxThroughputOffpeak : (double)this.maxThroughputLowerBound + (double)(this.maxThroughputHigherBound - this.maxThroughputLowerBound) * compactionPressure);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("compactionPressure is " + compactionPressure + ", tune compaction throughput to " + this.throughputDesc(maxThroughputToSet)));
        }
        this.maxThroughput = maxThroughputToSet;
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        this.maxThroughputHigherBound = conf.getLong(HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_HIGHER_BOUND, 0x1400000L);
        this.maxThroughputLowerBound = conf.getLong(HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_LOWER_BOUND, 0xA00000L);
        this.maxThroughputOffpeak = conf.getLong(HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_OFFPEAK, Long.MAX_VALUE);
        this.offPeakHours = OffPeakHours.getInstance(conf);
        this.controlPerSize = this.maxThroughputLowerBound;
        this.maxThroughput = this.maxThroughputLowerBound;
        this.tuningPeriod = this.getConf().getInt(HBASE_HSTORE_COMPACTION_THROUGHPUT_TUNE_PERIOD, 60000);
        LOG.info((Object)("Compaction throughput configurations, higher bound: " + this.throughputDesc(this.maxThroughputHigherBound) + ", lower bound " + this.throughputDesc(this.maxThroughputLowerBound) + ", off peak: " + this.throughputDesc(this.maxThroughputOffpeak) + ", tuning period: " + this.tuningPeriod + " ms"));
    }

    private String throughputDesc(long deltaSize, long elapsedTime) {
        return this.throughputDesc((double)deltaSize / (double)elapsedTime * 1000.0);
    }

    private String throughputDesc(double speed) {
        if (speed >= 1.0E15) {
            return "unlimited";
        }
        return String.format("%.2f MB/sec", speed / 1024.0 / 1024.0);
    }

    @Override
    public void start(String compactionName) {
        this.activeCompactions.put(compactionName, new ActiveCompaction());
    }

    @Override
    public long control(String compactionName, long size) throws InterruptedException {
        ActiveCompaction compaction = (ActiveCompaction)this.activeCompactions.get(compactionName);
        compaction.totalSize += size;
        long deltaSize = compaction.totalSize - compaction.lastControlSize;
        if (deltaSize < this.controlPerSize) {
            return 0L;
        }
        long now = EnvironmentEdgeManager.currentTime();
        double maxThroughputPerCompaction = this.maxThroughput / (double)this.activeCompactions.size();
        long minTimeAllowed = (long)((double)deltaSize / maxThroughputPerCompaction * 1000.0);
        long elapsedTime = now - compaction.lastControlTime;
        compaction.lastControlSize = compaction.totalSize;
        if (elapsedTime >= minTimeAllowed) {
            compaction.lastControlTime = EnvironmentEdgeManager.currentTime();
            return 0L;
        }
        long sleepTime = minTimeAllowed - elapsedTime;
        if (LOG.isDebugEnabled() && now - compaction.lastLogTime > 60000L) {
            LOG.debug((Object)(compactionName + " sleep " + sleepTime + " ms because current throughput is " + this.throughputDesc(deltaSize, elapsedTime) + ", max allowed is " + this.throughputDesc(maxThroughputPerCompaction) + ", already slept " + compaction.numberOfSleeps + " time(s) and total slept time is " + compaction.totalSleepTime + " ms till now."));
            compaction.lastLogTime = now;
        }
        Thread.sleep(sleepTime);
        compaction.numberOfSleeps++;
        compaction.totalSleepTime += sleepTime;
        compaction.lastControlTime = EnvironmentEdgeManager.currentTime();
        return sleepTime;
    }

    @Override
    public void finish(String compactionName) {
        ActiveCompaction compaction = (ActiveCompaction)this.activeCompactions.remove(compactionName);
        long elapsedTime = Math.max(1L, EnvironmentEdgeManager.currentTime() - compaction.startTime);
        LOG.info((Object)(compactionName + " average throughput is " + this.throughputDesc(compaction.totalSize, elapsedTime) + ", slept " + compaction.numberOfSleeps + " time(s) and total slept time is " + compaction.totalSleepTime + " ms. " + this.activeCompactions.size() + " active compactions remaining, total limit is " + this.throughputDesc(this.maxThroughput)));
    }

    @Override
    public void stop(String why) {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public String toString() {
        return "DefaultCompactionThroughputController [maxThroughput=" + this.throughputDesc(this.maxThroughput) + ", activeCompactions=" + this.activeCompactions.size() + "]";
    }

    private static final class ActiveCompaction {
        private final long startTime;
        private long lastControlTime;
        private long lastControlSize;
        private long totalSize;
        private long numberOfSleeps;
        private long totalSleepTime;
        private long lastLogTime;

        ActiveCompaction() {
            long currentTime;
            this.startTime = currentTime = EnvironmentEdgeManager.currentTime();
            this.lastControlTime = currentTime;
            this.lastLogTime = currentTime;
        }
    }
}

