/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.Compressor;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
@Deprecated
public class HLogKey
extends WALKey
implements Writable {
    public static final Log LOG = LogFactory.getLog(HLogKey.class);

    public HLogKey() {
    }

    @VisibleForTesting
    public HLogKey(byte[] encodedRegionName, TableName tablename, long logSeqNum, long now, UUID clusterId) {
        super(encodedRegionName, tablename, logSeqNum, now, clusterId);
    }

    public HLogKey(byte[] encodedRegionName, TableName tablename) {
        super(encodedRegionName, tablename);
    }

    public HLogKey(byte[] encodedRegionName, TableName tablename, long now) {
        super(encodedRegionName, tablename, now);
    }

    public HLogKey(byte[] encodedRegionName, TableName tablename, long logSeqNum, long now, List<UUID> clusterIds, long nonceGroup, long nonce) {
        super(encodedRegionName, tablename, logSeqNum, now, clusterIds, nonceGroup, nonce);
    }

    public HLogKey(byte[] encodedRegionName, TableName tablename, long now, List<UUID> clusterIds, long nonceGroup, long nonce) {
        super(encodedRegionName, tablename, now, clusterIds, nonceGroup, nonce);
    }

    public HLogKey(byte[] encodedRegionName, TableName tablename, long logSeqNum, long nonceGroup, long nonce) {
        super(encodedRegionName, tablename, logSeqNum, nonceGroup, nonce);
    }

    @Override
    @Deprecated
    public void write(DataOutput out) throws IOException {
        LOG.warn((Object)"HLogKey is being serialized to writable - only expected in test code");
        WritableUtils.writeVInt(out, HLogKey.VERSION.code);
        if (this.compressionContext == null) {
            Bytes.writeByteArray(out, this.encodedRegionName);
            Bytes.writeByteArray(out, this.tablename.getName());
        } else {
            Compressor.writeCompressed(this.encodedRegionName, 0, this.encodedRegionName.length, out, this.compressionContext.regionDict);
            Compressor.writeCompressed(this.tablename.getName(), 0, this.tablename.getName().length, out, this.compressionContext.tableDict);
        }
        out.writeLong(this.logSeqNum);
        out.writeLong(this.writeTime);
        Iterator iterator = this.clusterIds.iterator();
        if (iterator.hasNext()) {
            out.writeBoolean(true);
            UUID clusterId = (UUID)iterator.next();
            out.writeLong(clusterId.getMostSignificantBits());
            out.writeLong(clusterId.getLeastSignificantBits());
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        byte[] tablenameBytes;
        block13: {
            WALKey.Version version = WALKey.Version.UNVERSIONED;
            this.setScopes(null);
            int len = WritableUtils.readVInt(in);
            tablenameBytes = null;
            if (len < 0) {
                version = WALKey.Version.fromCode(len);
                if (this.compressionContext == null || !version.atLeast(WALKey.Version.COMPRESSED)) {
                    len = WritableUtils.readVInt(in);
                }
            }
            if (this.compressionContext == null || !version.atLeast(WALKey.Version.COMPRESSED)) {
                this.encodedRegionName = new byte[len];
                in.readFully(this.encodedRegionName);
                tablenameBytes = Bytes.readByteArray(in);
            } else {
                this.encodedRegionName = Compressor.readCompressed(in, this.compressionContext.regionDict);
                tablenameBytes = Compressor.readCompressed(in, this.compressionContext.tableDict);
            }
            this.logSeqNum = in.readLong();
            this.writeTime = in.readLong();
            this.clusterIds.clear();
            if (version.atLeast(WALKey.Version.INITIAL)) {
                if (in.readBoolean()) {
                    this.clusterIds.add(new UUID(in.readLong(), in.readLong()));
                }
            } else {
                try {
                    in.readByte();
                }
                catch (EOFException e) {
                    if (!LOG.isTraceEnabled()) break block13;
                    LOG.trace((Object)e);
                }
            }
        }
        try {
            this.tablename = TableName.valueOf(tablenameBytes);
        }
        catch (IllegalArgumentException iae) {
            if (Bytes.toString(tablenameBytes).equals(".META.")) {
                LOG.info((Object)"Got an old .META. edit, continuing with new format ");
                this.tablename = TableName.META_TABLE_NAME;
                this.encodedRegionName = HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes();
            }
            if (Bytes.toString(tablenameBytes).equals("-ROOT-")) {
                this.tablename = TableName.OLD_ROOT_TABLE_NAME;
                throw iae;
            }
            throw iae;
        }
    }
}

