/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.KeyValueCompression;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.LimitedPrivate(value={"Replication", "Coprocesssor"})
public class WALEdit
implements Writable,
HeapSize {
    public static final Log LOG = LogFactory.getLog(WALEdit.class);
    public static final byte[] METAFAMILY = Bytes.toBytes("METAFAMILY");
    static final byte[] METAROW = Bytes.toBytes("METAROW");
    static final byte[] COMPACTION = Bytes.toBytes("HBASE::COMPACTION");
    static final byte[] FLUSH = Bytes.toBytes("HBASE::FLUSH");
    static final byte[] REGION_EVENT = Bytes.toBytes("HBASE::REGION_EVENT");
    @VisibleForTesting
    public static final byte[] BULK_LOAD = Bytes.toBytes("HBASE::BULK_LOAD");
    private final int VERSION_2 = -1;
    private final boolean isReplay;
    private final ArrayList<Cell> cells = new ArrayList(1);
    public static final WALEdit EMPTY_WALEDIT = new WALEdit();
    @Deprecated
    private NavigableMap<byte[], Integer> scopes;
    private CompressionContext compressionContext;

    public WALEdit() {
        this(false);
    }

    public WALEdit(boolean isReplay) {
        this.isReplay = isReplay;
    }

    public static boolean isMetaEditFamily(byte[] f) {
        return Bytes.equals(METAFAMILY, f);
    }

    public static boolean isMetaEditFamily(Cell cell) {
        return CellUtil.matchingFamily(cell, METAFAMILY);
    }

    public boolean isMetaEdit() {
        for (Cell cell : this.cells) {
            if (WALEdit.isMetaEditFamily(cell)) continue;
            return false;
        }
        return true;
    }

    public boolean isReplay() {
        return this.isReplay;
    }

    public void setCompressionContext(CompressionContext compressionContext) {
        this.compressionContext = compressionContext;
    }

    public WALEdit add(Cell cell) {
        this.cells.add(cell);
        return this;
    }

    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    public int size() {
        return this.cells.size();
    }

    public ArrayList<Cell> getCells() {
        return this.cells;
    }

    public NavigableMap<byte[], Integer> getAndRemoveScopes() {
        NavigableMap<byte[], Integer> result = this.scopes;
        this.scopes = null;
        return result;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int versionOrLength;
        this.cells.clear();
        if (this.scopes != null) {
            this.scopes.clear();
        }
        if ((versionOrLength = in.readInt()) == -1) {
            int numEdits = in.readInt();
            for (int idx = 0; idx < numEdits; ++idx) {
                if (this.compressionContext != null) {
                    this.add(KeyValueCompression.readKV(in, this.compressionContext));
                    continue;
                }
                this.add(KeyValue.create(in));
            }
            int numFamilies = in.readInt();
            if (numFamilies > 0) {
                if (this.scopes == null) {
                    this.scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
                }
                for (int i = 0; i < numFamilies; ++i) {
                    byte[] fam = Bytes.readByteArray(in);
                    int scope = in.readInt();
                    this.scopes.put(fam, scope);
                }
            }
        } else {
            this.add(KeyValue.create(versionOrLength, in));
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        LOG.warn((Object)"WALEdit is being serialized to writable - only expected in test code");
        out.writeInt(-1);
        out.writeInt(this.cells.size());
        for (Cell cell : this.cells) {
            KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
            if (this.compressionContext != null) {
                KeyValueCompression.writeKV(out, kv, this.compressionContext);
                continue;
            }
            KeyValue.write(kv, out);
        }
        if (this.scopes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.scopes.size());
            for (byte[] key : this.scopes.keySet()) {
                Bytes.writeByteArray(out, key);
                out.writeInt((Integer)this.scopes.get(key));
            }
        }
    }

    public int readFromCells(Codec.Decoder cellDecoder, int expectedCount) throws IOException {
        this.cells.clear();
        this.cells.ensureCapacity(expectedCount);
        while (this.cells.size() < expectedCount && cellDecoder.advance()) {
            this.cells.add(cellDecoder.current());
        }
        return this.cells.size();
    }

    @Override
    public long heapSize() {
        long ret = ClassSize.ARRAYLIST;
        for (Cell cell : this.cells) {
            ret += CellUtil.estimatedHeapSizeOf(cell);
        }
        if (this.scopes != null) {
            ret += (long)ClassSize.TREEMAP;
            ret += (long)ClassSize.align(this.scopes.size() * ClassSize.MAP_ENTRY);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[#edits: " + this.cells.size() + " = <");
        for (Cell cell : this.cells) {
            sb.append(cell);
            sb.append("; ");
        }
        if (this.scopes != null) {
            sb.append(" scopes: " + this.scopes.toString());
        }
        sb.append(">]");
        return sb.toString();
    }

    public static WALEdit createFlushWALEdit(HRegionInfo hri, WALProtos.FlushDescriptor f) {
        KeyValue kv = new KeyValue(WALEdit.getRowForRegion(hri), METAFAMILY, FLUSH, EnvironmentEdgeManager.currentTime(), f.toByteArray());
        return new WALEdit().add(kv);
    }

    public static WALProtos.FlushDescriptor getFlushDescriptor(Cell cell) throws IOException {
        if (CellUtil.matchingColumn(cell, METAFAMILY, FLUSH)) {
            return WALProtos.FlushDescriptor.parseFrom(cell.getValue());
        }
        return null;
    }

    public static WALEdit createRegionEventWALEdit(HRegionInfo hri, WALProtos.RegionEventDescriptor regionEventDesc) {
        KeyValue kv = new KeyValue(WALEdit.getRowForRegion(hri), METAFAMILY, REGION_EVENT, EnvironmentEdgeManager.currentTime(), regionEventDesc.toByteArray());
        return new WALEdit().add(kv);
    }

    public static WALProtos.RegionEventDescriptor getRegionEventDescriptor(Cell cell) throws IOException {
        if (CellUtil.matchingColumn(cell, METAFAMILY, REGION_EVENT)) {
            return WALProtos.RegionEventDescriptor.parseFrom(cell.getValue());
        }
        return null;
    }

    public static WALEdit createCompaction(HRegionInfo hri, WALProtos.CompactionDescriptor c) {
        byte[] pbbytes = c.toByteArray();
        KeyValue kv = new KeyValue(WALEdit.getRowForRegion(hri), METAFAMILY, COMPACTION, EnvironmentEdgeManager.currentTime(), pbbytes);
        return new WALEdit().add(kv);
    }

    private static byte[] getRowForRegion(HRegionInfo hri) {
        byte[] startKey = hri.getStartKey();
        if (startKey.length == 0) {
            return new byte[]{0};
        }
        return startKey;
    }

    public static WALProtos.CompactionDescriptor getCompaction(Cell kv) throws IOException {
        if (CellUtil.matchingColumn(kv, METAFAMILY, COMPACTION)) {
            return WALProtos.CompactionDescriptor.parseFrom(kv.getValue());
        }
        return null;
    }

    public static WALEdit createBulkLoadEvent(HRegionInfo hri, WALProtos.BulkLoadDescriptor bulkLoadDescriptor) {
        KeyValue kv = new KeyValue(WALEdit.getRowForRegion(hri), METAFAMILY, BULK_LOAD, EnvironmentEdgeManager.currentTime(), bulkLoadDescriptor.toByteArray());
        return new WALEdit().add(kv);
    }

    public static WALProtos.BulkLoadDescriptor getBulkLoadDescriptor(Cell cell) throws IOException {
        if (CellUtil.matchingColumn(cell, METAFAMILY, BULK_LOAD)) {
            return WALProtos.BulkLoadDescriptor.parseFrom(cell.getValue());
        }
        return null;
    }
}

