/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.org.jamon.AbstractRenderer;
import org.apache.hadoop.hbase.shaded.org.jamon.AbstractTemplateImpl;
import org.apache.hadoop.hbase.shaded.org.jamon.AbstractTemplateProxy;
import org.apache.hadoop.hbase.shaded.org.jamon.Renderer;
import org.apache.hadoop.hbase.shaded.org.jamon.TemplateManager;
import org.apache.hadoop.hbase.shaded.org.jamon.annotations.Argument;
import org.apache.hadoop.hbase.shaded.org.jamon.annotations.Template;
import org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmplImpl;

@Template(signature="453B1D06C1C069660F1255077D1DC0CE", requiredArguments={@Argument(name="regionServer", type="HRegionServer"), @Argument(name="onlineRegions", type="List<HRegionInfo>")})
public class RegionListTmpl
extends AbstractTemplateProxy {
    public RegionListTmpl(TemplateManager p_manager) {
        super(p_manager);
    }

    public RegionListTmpl() {
        super("/org/apache/hadoop/hbase/tmpl/regionserver/RegionListTmpl");
    }

    @Override
    protected ImplData makeImplData() {
        return new ImplData();
    }

    @Override
    public ImplData getImplData() {
        return (ImplData)super.getImplData();
    }

    @Override
    public AbstractTemplateImpl constructImpl(Class<? extends AbstractTemplateImpl> p_class) {
        try {
            return p_class.getConstructor(TemplateManager.class, ImplData.class).newInstance(this.getTemplateManager(), this.getImplData());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected AbstractTemplateImpl constructImpl() {
        return new RegionListTmplImpl(this.getTemplateManager(), this.getImplData());
    }

    public Renderer makeRenderer(final HRegionServer regionServer, final List<HRegionInfo> onlineRegions) {
        return new AbstractRenderer(){

            @Override
            public void renderTo(Writer jamonWriter) throws IOException {
                RegionListTmpl.this.render(jamonWriter, regionServer, onlineRegions);
            }
        };
    }

    public void render(Writer jamonWriter, HRegionServer regionServer, List<HRegionInfo> onlineRegions) throws IOException {
        this.renderNoFlush(jamonWriter, regionServer, onlineRegions);
        jamonWriter.flush();
    }

    public void renderNoFlush(Writer jamonWriter, HRegionServer regionServer, List<HRegionInfo> onlineRegions) throws IOException {
        ImplData implData = this.getImplData();
        implData.setRegionServer(regionServer);
        implData.setOnlineRegions(onlineRegions);
        Intf instance = (Intf)this.getTemplateManager().constructImpl(this);
        instance.renderNoFlush(jamonWriter);
        this.reset();
    }

    public static class ImplData
    extends AbstractTemplateProxy.ImplData {
        private HRegionServer m_regionServer;
        private List<HRegionInfo> m_onlineRegions;

        public void setRegionServer(HRegionServer regionServer) {
            this.m_regionServer = regionServer;
        }

        public HRegionServer getRegionServer() {
            return this.m_regionServer;
        }

        public void setOnlineRegions(List<HRegionInfo> onlineRegions) {
            this.m_onlineRegions = onlineRegions;
        }

        public List<HRegionInfo> getOnlineRegions() {
            return this.m_onlineRegions;
        }
    }

    protected static interface Intf
    extends AbstractTemplateProxy.Intf {
        public void renderNoFlush(Writer var1) throws IOException;
    }
}

