/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.InlineBlockWriter;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.ByteBloomFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CompoundBloomFilterBase;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
public class CompoundBloomFilterWriter
extends CompoundBloomFilterBase
implements BloomFilterWriter,
InlineBlockWriter {
    protected static final Log LOG = LogFactory.getLog(CompoundBloomFilterWriter.class);
    private ByteBloomFilter chunk;
    private ByteBloomFilter prevChunk;
    private int maxFold;
    private int chunkByteSize;
    private Queue<ReadyChunk> readyChunks = new LinkedList<ReadyChunk>();
    private byte[] firstKeyInChunk = null;
    private HFileBlockIndex.BlockIndexWriter bloomBlockIndexWriter = new HFileBlockIndex.BlockIndexWriter();
    private boolean cacheOnWrite;

    public CompoundBloomFilterWriter(int chunkByteSizeHint, float errorRate, int hashType, int maxFold, boolean cacheOnWrite, KeyValue.KVComparator comparator) {
        this.chunkByteSize = ByteBloomFilter.computeFoldableByteSize((long)chunkByteSizeHint * 8L, maxFold);
        this.errorRate = errorRate;
        this.hashType = hashType;
        this.maxFold = maxFold;
        this.cacheOnWrite = cacheOnWrite;
        this.comparator = comparator;
    }

    @Override
    public boolean shouldWriteBlock(boolean closing) {
        this.enqueueReadyChunk(closing);
        return !this.readyChunks.isEmpty();
    }

    private void enqueueReadyChunk(boolean closing) {
        if (this.chunk == null || this.chunk.getKeyCount() < this.chunk.getMaxKeys() && !closing) {
            return;
        }
        if (this.firstKeyInChunk == null) {
            throw new NullPointerException("Trying to enqueue a chunk, but first key is null: closing=" + closing + ", keyCount=" + this.chunk.getKeyCount() + ", maxKeys=" + this.chunk.getMaxKeys());
        }
        ReadyChunk readyChunk = new ReadyChunk();
        readyChunk.chunkId = this.numChunks - 1;
        readyChunk.chunk = this.chunk;
        readyChunk.firstKey = this.firstKeyInChunk;
        this.readyChunks.add(readyChunk);
        long prevMaxKeys = this.chunk.getMaxKeys();
        long prevByteSize = this.chunk.getByteSize();
        this.chunk.compactBloom();
        if (LOG.isTraceEnabled() && prevByteSize != this.chunk.getByteSize()) {
            LOG.trace((Object)("Compacted Bloom chunk #" + readyChunk.chunkId + " from [" + prevMaxKeys + " max keys, " + prevByteSize + " bytes] to [" + this.chunk.getMaxKeys() + " max keys, " + this.chunk.getByteSize() + " bytes]"));
        }
        this.totalMaxKeys += this.chunk.getMaxKeys();
        this.totalByteSize += this.chunk.getByteSize();
        this.firstKeyInChunk = null;
        this.prevChunk = this.chunk;
        this.chunk = null;
    }

    @Override
    public void add(byte[] bloomKey, int keyOffset, int keyLength) {
        if (bloomKey == null) {
            throw new NullPointerException();
        }
        this.enqueueReadyChunk(false);
        if (this.chunk == null) {
            if (this.firstKeyInChunk != null) {
                throw new IllegalStateException("First key in chunk already set: " + Bytes.toStringBinary(this.firstKeyInChunk));
            }
            this.firstKeyInChunk = Arrays.copyOfRange(bloomKey, keyOffset, keyOffset + keyLength);
            this.chunk = this.prevChunk == null ? ByteBloomFilter.createBySize(this.chunkByteSize, this.errorRate, this.hashType, this.maxFold) : this.prevChunk.createAnother();
            if (this.chunk.getKeyCount() != 0L) {
                throw new IllegalStateException("keyCount=" + this.chunk.getKeyCount() + " > 0");
            }
            this.chunk.allocBloom();
            ++this.numChunks;
        }
        this.chunk.add(bloomKey, keyOffset, keyLength);
        ++this.totalKeyCount;
    }

    @Override
    public void writeInlineBlock(DataOutput out) throws IOException {
        ReadyChunk readyChunk = this.readyChunks.peek();
        ByteBloomFilter readyChunkBloom = readyChunk.chunk;
        readyChunkBloom.getDataWriter().write(out);
    }

    @Override
    public void blockWritten(long offset, int onDiskSize, int uncompressedSize) {
        ReadyChunk readyChunk = this.readyChunks.remove();
        this.bloomBlockIndexWriter.addEntry(readyChunk.firstKey, offset, onDiskSize);
    }

    @Override
    public BlockType getInlineBlockType() {
        return BlockType.BLOOM_CHUNK;
    }

    @Override
    public Writable getMetaWriter() {
        return new MetaWriter();
    }

    @Override
    public void compactBloom() {
    }

    @Override
    public void allocBloom() {
    }

    @Override
    public Writable getDataWriter() {
        return null;
    }

    @Override
    public boolean getCacheOnWrite() {
        return this.cacheOnWrite;
    }

    private class MetaWriter
    implements Writable {
        protected MetaWriter() {
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            throw new IOException("Cant read with this class.");
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(3);
            out.writeLong(CompoundBloomFilterWriter.this.getByteSize());
            out.writeInt(CompoundBloomFilterWriter.this.prevChunk.getHashCount());
            out.writeInt(CompoundBloomFilterWriter.this.prevChunk.getHashType());
            out.writeLong(CompoundBloomFilterWriter.this.getKeyCount());
            out.writeLong(CompoundBloomFilterWriter.this.getMaxKeys());
            out.writeInt(CompoundBloomFilterWriter.this.numChunks);
            Bytes.writeByteArray(out, Bytes.toBytes(CompoundBloomFilterWriter.this.comparator.getClass().getName()));
            CompoundBloomFilterWriter.this.bloomBlockIndexWriter.writeSingleLevelIndex(out, "Bloom filter");
        }
    }

    private static class ReadyChunk {
        int chunkId;
        byte[] firstKey;
        ByteBloomFilter chunk;

        private ReadyChunk() {
        }
    }
}

