/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.api.ResourceTracker;

public class ServerRMProxy<T>
extends RMProxy<T> {
    private static final Log LOG = LogFactory.getLog(ServerRMProxy.class);
    private static final ServerRMProxy INSTANCE = new ServerRMProxy();

    private ServerRMProxy() {
    }

    public static <T> T createRMProxy(Configuration configuration, Class<T> protocol) throws IOException {
        return ServerRMProxy.createRMProxy(configuration, protocol, INSTANCE);
    }

    @Override
    @InterfaceAudience.Private
    protected InetSocketAddress getRMAddress(YarnConfiguration conf, Class<?> protocol) {
        if (protocol == ResourceTracker.class) {
            return conf.getSocketAddr("yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", 8031);
        }
        String message = "Unsupported protocol found when creating the proxy connection to ResourceManager: " + (protocol != null ? protocol.getClass().getName() : "null");
        LOG.error((Object)message);
        throw new IllegalStateException(message);
    }

    @Override
    @InterfaceAudience.Private
    protected void checkAllowedProtocols(Class<?> protocol) {
        Preconditions.checkArgument(protocol.isAssignableFrom(ResourceTracker.class), "ResourceManager does not support this protocol");
    }
}

