/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class MutationSerialization
implements Serialization<Mutation> {
    @Override
    public boolean accept(Class<?> c) {
        return Mutation.class.isAssignableFrom(c);
    }

    @Override
    public Deserializer<Mutation> getDeserializer(Class<Mutation> c) {
        return new MutationDeserializer();
    }

    @Override
    public Serializer<Mutation> getSerializer(Class<Mutation> c) {
        return new MutationSerializer();
    }

    private static class MutationSerializer
    implements Serializer<Mutation> {
        private OutputStream out;

        private MutationSerializer() {
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void open(OutputStream out) throws IOException {
            this.out = out;
        }

        @Override
        public void serialize(Mutation mutation) throws IOException {
            ClientProtos.MutationProto.MutationType type;
            if (mutation instanceof Put) {
                type = ClientProtos.MutationProto.MutationType.PUT;
            } else if (mutation instanceof Delete) {
                type = ClientProtos.MutationProto.MutationType.DELETE;
            } else {
                throw new IllegalArgumentException("Only Put and Delete are supported");
            }
            ProtobufUtil.toMutation(type, mutation).writeDelimitedTo(this.out);
        }
    }

    private static class MutationDeserializer
    implements Deserializer<Mutation> {
        private InputStream in;

        private MutationDeserializer() {
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public Mutation deserialize(Mutation mutation) throws IOException {
            ClientProtos.MutationProto.Builder builder = ClientProtos.MutationProto.newBuilder();
            ProtobufUtil.mergeDelimitedFrom(builder, this.in);
            ClientProtos.MutationProto proto = builder.build();
            return ProtobufUtil.toMutation(proto);
        }

        @Override
        public void open(InputStream in) throws IOException {
            this.in = in;
        }
    }
}

