/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public class LoadBalancerFactory {
    public static Class<? extends LoadBalancer> getDefaultLoadBalancerClass() {
        return StochasticLoadBalancer.class;
    }

    public static LoadBalancer getLoadBalancer(Configuration conf) {
        Class<LoadBalancer> balancerKlass = conf.getClass("hbase.master.loadbalancer.class", LoadBalancerFactory.getDefaultLoadBalancerClass(), LoadBalancer.class);
        return ReflectionUtils.newInstance(balancerKlass, conf);
    }
}

