/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.StringUtils;

public class ServerCrashProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.ServerCrashState>
implements ServerProcedureInterface {
    private static final Log LOG = LogFactory.getLog(ServerCrashProcedure.class);
    public static final String KEY_SHORT_WAIT_ON_META = "hbase.master.servercrash.short.wait.on.meta.ms";
    public static final int DEFAULT_SHORT_WAIT_ON_META = 1000;
    public static final String KEY_RETRIES_ON_META = "hbase.master.servercrash.meta.retries";
    public static final int DEFAULT_RETRIES_ON_META = 10;
    public static final String KEY_WAIT_ON_RIT = "hbase.master.servercrash.wait.on.rit.ms";
    public static final int DEFAULT_WAIT_ON_RIT = 30000;
    private static final Set<HRegionInfo> META_REGION_SET = new HashSet<HRegionInfo>();
    private ServerName serverName;
    private boolean notifiedDeadServer = false;
    private Set<HRegionInfo> regionsOnCrashedServer;
    private List<HRegionInfo> regionsAssigned;
    private boolean distributedLogReplay = false;
    private boolean carryingMeta = false;
    private boolean shouldSplitWal;
    private int cycles = 0;
    private int previousState;

    public ServerCrashProcedure(ServerName serverName, boolean shouldSplitWal, boolean carryingMeta) {
        this.serverName = serverName;
        this.shouldSplitWal = shouldSplitWal;
        this.carryingMeta = carryingMeta;
    }

    public ServerCrashProcedure() {
    }

    private void throwProcedureYieldException(String msg) throws ProcedureYieldException {
        String logMsg = msg + "; cycle=" + this.cycles + ", running for " + StringUtils.formatTimeDiff(System.currentTimeMillis(), this.getStartTime());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)logMsg);
        }
        throw new ProcedureYieldException(logMsg);
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ServerCrashState state) throws ProcedureYieldException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)state);
        }
        if (state.ordinal() != this.previousState) {
            this.previousState = state.ordinal();
            this.cycles = 0;
        } else {
            ++this.cycles;
        }
        MasterServices services = env.getMasterServices();
        if (!services.getAssignmentManager().isFailoverCleanupDone()) {
            this.throwProcedureYieldException("Waiting on master failover to complete");
        }
        if (!this.notifiedDeadServer) {
            services.getServerManager().getDeadServers().notifyServer(this.serverName);
            this.notifiedDeadServer = true;
        }
        try {
            switch (state) {
                case SERVER_CRASH_START: {
                    LOG.info((Object)("Start processing crashed " + this.serverName));
                    this.start(env);
                    if (this.carryingMeta) {
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_PROCESS_META);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_GET_REGIONS);
                    break;
                }
                case SERVER_CRASH_GET_REGIONS: {
                    if (!this.isMetaAssignedQuickTest(env)) {
                        this.throwProcedureYieldException("Waiting on hbase:meta assignment");
                    }
                    this.regionsOnCrashedServer = services.getAssignmentManager().getRegionStates().getServerRegions(this.serverName);
                    if (!this.shouldSplitWal) {
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN);
                        break;
                    }
                    if (this.distributedLogReplay) {
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_PREPARE_LOG_REPLAY);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_SPLIT_LOGS);
                    break;
                }
                case SERVER_CRASH_PROCESS_META: {
                    if (!this.processMeta(env)) {
                        this.throwProcedureYieldException("Waiting on regions-in-transition to clear");
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_GET_REGIONS);
                    break;
                }
                case SERVER_CRASH_PREPARE_LOG_REPLAY: {
                    this.prepareLogReplay(env, this.regionsOnCrashedServer);
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN);
                    break;
                }
                case SERVER_CRASH_SPLIT_LOGS: {
                    this.splitLogs(env);
                    if (this.distributedLogReplay) {
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_FINISH);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN);
                    break;
                }
                case SERVER_CRASH_ASSIGN: {
                    boolean regions;
                    List<HRegionInfo> regionsToAssign = this.calcRegionsToAssign(env);
                    boolean bl = regions = regionsToAssign != null && !regionsToAssign.isEmpty();
                    if (regions) {
                        this.regionsAssigned = regionsToAssign;
                        if (!this.assign(env, regionsToAssign)) {
                            this.throwProcedureYieldException("Failed assign; will retry");
                        }
                    }
                    if (this.shouldSplitWal && this.distributedLogReplay) {
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_WAIT_ON_ASSIGN);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_FINISH);
                    break;
                }
                case SERVER_CRASH_WAIT_ON_ASSIGN: {
                    if (this.regionsAssigned != null && !this.regionsAssigned.isEmpty() && !this.waitOnAssign(env, this.regionsAssigned)) {
                        this.throwProcedureYieldException("Waiting on region assign");
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_SPLIT_LOGS);
                    break;
                }
                case SERVER_CRASH_FINISH: {
                    LOG.info((Object)("Finished processing of crashed " + this.serverName));
                    services.getServerManager().getDeadServers().finish(this.serverName);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed serverName=" + this.serverName + ", state=" + state + "; retry"), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Interrupted serverName=" + this.serverName + ", state=" + state + "; retry"), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private void start(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        mfs.setLogRecoveryMode();
        this.distributedLogReplay = mfs.getLogRecoveryMode() == ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY;
    }

    private boolean processMeta(MasterProcedureEnv env) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing hbase:meta that was on " + this.serverName));
        }
        MasterServices services = env.getMasterServices();
        MasterFileSystem mfs = services.getMasterFileSystem();
        AssignmentManager am = services.getAssignmentManager();
        HRegionInfo metaHRI = HRegionInfo.FIRST_META_REGIONINFO;
        if (this.shouldSplitWal) {
            if (this.distributedLogReplay) {
                this.prepareLogReplay(env, META_REGION_SET);
            } else {
                mfs.splitMetaLog(this.serverName);
                am.getRegionStates().logSplit(metaHRI);
            }
        }
        boolean processed = true;
        boolean shouldAssignMeta = false;
        AssignmentManager.ServerHostRegion rsCarryingMetaRegion = am.isCarryingMeta(this.serverName);
        switch (rsCarryingMetaRegion) {
            case HOSTING_REGION: {
                LOG.info((Object)("Server " + this.serverName + " was carrying META. Trying to assign."));
                am.regionOffline(HRegionInfo.FIRST_META_REGIONINFO);
                shouldAssignMeta = true;
                break;
            }
            case UNKNOWN: {
                if (!services.getMetaTableLocator().isLocationAvailable(services.getZooKeeper())) {
                    shouldAssignMeta = true;
                    break;
                }
            }
            case NOT_HOSTING_REGION: {
                LOG.info((Object)"META has been assigned to otherwhere, skip assigning.");
                break;
            }
            default: {
                throw new IOException("Unsupported action in MetaServerShutdownHandler");
            }
        }
        if (shouldAssignMeta) {
            this.verifyAndAssignMetaWithRetries(env);
            if (this.shouldSplitWal && this.distributedLogReplay) {
                int timeout = env.getMasterConfiguration().getInt(KEY_WAIT_ON_RIT, 30000);
                if (!this.waitOnRegionToClearRegionsInTransition(am, metaHRI, timeout)) {
                    processed = false;
                } else {
                    mfs.splitMetaLog(this.serverName);
                }
            }
        }
        return processed;
    }

    private boolean waitOnRegionToClearRegionsInTransition(AssignmentManager am, HRegionInfo hri, int timeout) throws InterruptedIOException {
        try {
            if (!am.waitOnRegionToClearRegionsInTransition(hri, timeout)) {
                LOG.warn((Object)("Region " + hri.getEncodedName() + " didn't complete assignment in time"));
                return false;
            }
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException("Caught " + ie + " during waitOnRegionToClearRegionsInTransition for " + hri);
        }
        return true;
    }

    private void prepareLogReplay(MasterProcedureEnv env, Set<HRegionInfo> regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Mark " + ServerCrashProcedure.size(this.regionsOnCrashedServer) + " regions-in-recovery from " + this.serverName));
        }
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        mfs.prepareLogReplay(this.serverName, regions);
        am.getRegionStates().logSplit(this.serverName);
    }

    private void splitLogs(MasterProcedureEnv env) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Splitting logs from " + this.serverName + "; region count=" + ServerCrashProcedure.size(this.regionsOnCrashedServer)));
        }
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        mfs.splitLog(this.serverName);
        am.getRegionStates().logSplit(this.serverName);
    }

    static int size(Collection<HRegionInfo> hris) {
        return hris == null ? 0 : hris.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HRegionInfo> calcRegionsToAssign(MasterProcedureEnv env) throws IOException {
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        ArrayList<HRegionInfo> regionsToAssignAggregator = new ArrayList<HRegionInfo>();
        int replicaCount = env.getMasterConfiguration().getInt("hbase.meta.replica.count", 1);
        for (int i = 1; i < replicaCount; ++i) {
            HRegionInfo metaHri = RegionReplicaUtil.getRegionInfoForReplica(HRegionInfo.FIRST_META_REGIONINFO, i);
            if (am.isCarryingMetaReplica(this.serverName, metaHri) != AssignmentManager.ServerHostRegion.HOSTING_REGION) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reassigning meta replica" + metaHri + " that was on " + this.serverName));
            }
            regionsToAssignAggregator.add(metaHri);
        }
        List<HRegionInfo> regionsInTransition = am.cleanOutCrashedServerReferences(this.serverName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reassigning " + ServerCrashProcedure.size(this.regionsOnCrashedServer) + " region(s) that " + (this.serverName == null ? "null" : this.serverName) + " was carrying (and " + regionsInTransition.size() + " regions(s) that were opening on this server)"));
        }
        regionsToAssignAggregator.addAll(regionsInTransition);
        if (this.regionsOnCrashedServer != null && !this.regionsOnCrashedServer.isEmpty()) {
            RegionStates regionStates = am.getRegionStates();
            for (HRegionInfo hri : this.regionsOnCrashedServer) {
                if (regionsInTransition.contains(hri)) continue;
                String encodedName = hri.getEncodedName();
                Lock lock = am.acquireRegionLock(encodedName);
                try {
                    RegionState rit = regionStates.getRegionTransitionState(hri);
                    if (ServerCrashProcedure.processDeadRegion(hri, am)) {
                        ServerName addressFromAM = regionStates.getRegionServerOfRegion(hri);
                        if (addressFromAM != null && !addressFromAM.equals(this.serverName)) {
                            LOG.info((Object)("Skip assigning " + hri.getRegionNameAsString() + " because opened on " + addressFromAM.getServerName()));
                            continue;
                        }
                        if (rit != null) {
                            if (rit.getServerName() != null && !rit.isOnServer(this.serverName)) {
                                LOG.info((Object)("Skip assigning region in transition on other server" + rit));
                                continue;
                            }
                            LOG.info((Object)("Reassigning region " + rit + " and clearing zknode if exists"));
                            try {
                                ZKAssign.deleteNodeFailSilent(env.getMasterServices().getZooKeeper(), hri);
                            }
                            catch (KeeperException e) {
                                env.getMasterServices().abort("Unexpected error deleting RIT " + hri, e);
                                throw new IOException(e);
                            }
                            regionStates.updateRegionState(hri, RegionState.State.OFFLINE);
                        } else if (regionStates.isRegionInState(hri, RegionState.State.SPLITTING_NEW, RegionState.State.MERGING_NEW)) {
                            regionStates.updateRegionState(hri, RegionState.State.OFFLINE);
                        }
                        regionsToAssignAggregator.add(hri);
                        continue;
                    }
                    if (rit == null) continue;
                    if ((rit.isPendingCloseOrClosing() || rit.isOffline()) && am.getTableStateManager().isTableState(hri.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING) || am.getReplicasToClose().contains(hri)) {
                        regionStates.updateRegionState(hri, RegionState.State.OFFLINE);
                        am.deleteClosingOrClosedNode(hri, rit.getServerName());
                        am.offlineDisabledRegion(hri);
                        continue;
                    }
                    LOG.warn((Object)("THIS SHOULD NOT HAPPEN: unexpected region in transition " + rit + " not to be assigned by SSH of server " + this.serverName));
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return regionsToAssignAggregator;
    }

    private boolean assign(MasterProcedureEnv env, List<HRegionInfo> hris) throws InterruptedIOException {
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        try {
            am.assign(hris);
        }
        catch (InterruptedException ie) {
            LOG.error((Object)("Caught " + ie + " during round-robin assignment"));
            throw (InterruptedIOException)new InterruptedIOException().initCause(ie);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Caught " + ioe + " during region assignment, will retry"));
            return false;
        }
        return true;
    }

    private boolean waitOnAssign(MasterProcedureEnv env, List<HRegionInfo> hris) throws InterruptedIOException {
        int timeout = env.getMasterConfiguration().getInt(KEY_WAIT_ON_RIT, 30000);
        for (HRegionInfo hri : hris) {
            if (this.waitOnRegionToClearRegionsInTransition(env.getMasterServices().getAssignmentManager(), hri, timeout)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ServerCrashState state) throws IOException {
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected MasterProcedureProtos.ServerCrashState getState(int stateId) {
        return MasterProcedureProtos.ServerCrashState.valueOf(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.ServerCrashState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.ServerCrashState getInitialState() {
        return MasterProcedureProtos.ServerCrashState.SERVER_CRASH_START;
    }

    @Override
    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    @Override
    protected boolean acquireLock(MasterProcedureEnv env) {
        if (env.waitServerCrashProcessingEnabled(this)) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireServerExclusiveLock(this, this.getServerName());
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseServerExclusiveLock(this, this.getServerName());
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" serverName=");
        sb.append(this.serverName);
        sb.append(", shouldSplitWal=");
        sb.append(this.shouldSplitWal);
        sb.append(", carryingMeta=");
        sb.append(this.carryingMeta);
    }

    @Override
    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        MasterProcedureProtos.ServerCrashStateData.Builder state = MasterProcedureProtos.ServerCrashStateData.newBuilder().setServerName(ProtobufUtil.toServerName(this.serverName)).setDistributedLogReplay(this.distributedLogReplay).setCarryingMeta(this.carryingMeta).setShouldSplitWal(this.shouldSplitWal);
        if (this.regionsOnCrashedServer != null && !this.regionsOnCrashedServer.isEmpty()) {
            for (HRegionInfo hri : this.regionsOnCrashedServer) {
                state.addRegionsOnCrashedServer(HRegionInfo.convert(hri));
            }
        }
        if (this.regionsAssigned != null && !this.regionsAssigned.isEmpty()) {
            for (HRegionInfo hri : this.regionsAssigned) {
                state.addRegionsAssigned(HRegionInfo.convert(hri));
            }
        }
        state.build().writeDelimitedTo(stream);
    }

    @Override
    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        MasterProcedureProtos.ServerCrashStateData state = MasterProcedureProtos.ServerCrashStateData.parseDelimitedFrom(stream);
        this.serverName = ProtobufUtil.toServerName(state.getServerName());
        this.distributedLogReplay = state.hasDistributedLogReplay() ? state.getDistributedLogReplay() : false;
        this.carryingMeta = state.hasCarryingMeta() ? state.getCarryingMeta() : false;
        this.shouldSplitWal = state.getShouldSplitWal();
        int size = state.getRegionsOnCrashedServerCount();
        if (size > 0) {
            this.regionsOnCrashedServer = new HashSet<HRegionInfo>(size);
            for (HBaseProtos.RegionInfo ri : state.getRegionsOnCrashedServerList()) {
                this.regionsOnCrashedServer.add(HRegionInfo.convert(ri));
            }
        }
        if ((size = state.getRegionsAssignedCount()) > 0) {
            this.regionsAssigned = new ArrayList<HRegionInfo>(size);
            for (HBaseProtos.RegionInfo ri : state.getRegionsOnCrashedServerList()) {
                this.regionsAssigned.add(HRegionInfo.convert(ri));
            }
        }
    }

    private static boolean processDeadRegion(HRegionInfo hri, AssignmentManager assignmentManager) throws IOException {
        boolean tablePresent = assignmentManager.getTableStateManager().isTablePresent(hri.getTable());
        if (!tablePresent) {
            LOG.info((Object)("The table " + hri.getTable() + " was deleted.  Hence not proceeding."));
            return false;
        }
        boolean disabled = assignmentManager.getTableStateManager().isTableState(hri.getTable(), ZooKeeperProtos.Table.State.DISABLED);
        if (disabled) {
            LOG.info((Object)("The table " + hri.getTable() + " was disabled.  Hence not proceeding."));
            return false;
        }
        if (hri.isOffline() && hri.isSplit()) {
            return false;
        }
        boolean disabling = assignmentManager.getTableStateManager().isTableState(hri.getTable(), ZooKeeperProtos.Table.State.DISABLING);
        if (disabling) {
            LOG.info((Object)("The table " + hri.getTable() + " is disabled.  Hence not assigning region" + hri.getEncodedName()));
            return false;
        }
        return true;
    }

    private void verifyAndAssignMetaWithRetries(MasterProcedureEnv env) throws IOException {
        MasterServices services = env.getMasterServices();
        int iTimes = services.getConfiguration().getInt(KEY_RETRIES_ON_META, 10);
        long waitTime = services.getConfiguration().getLong(KEY_SHORT_WAIT_ON_META, 1000L);
        int iFlag = 0;
        while (true) {
            try {
                this.verifyAndAssignMeta(env);
            }
            catch (KeeperException e) {
                services.abort("In server shutdown processing, assigning meta", e);
                throw new IOException("Aborting", e);
            }
            catch (Exception e) {
                if (iFlag >= iTimes) {
                    services.abort("verifyAndAssignMeta failed after" + iTimes + " retries, aborting", e);
                    throw new IOException("Aborting", e);
                }
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {
                    LOG.warn((Object)"Interrupted when is the thread sleep", (Throwable)e1);
                    Thread.currentThread().interrupt();
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
                }
                ++iFlag;
                continue;
            }
            break;
        }
    }

    private void verifyAndAssignMeta(MasterProcedureEnv env) throws InterruptedException, IOException, KeeperException {
        MasterServices services = env.getMasterServices();
        if (!this.isMetaAssignedQuickTest(env)) {
            services.getAssignmentManager().assignMeta(HRegionInfo.FIRST_META_REGIONINFO);
        } else if (this.serverName.equals(services.getMetaTableLocator().getMetaRegionLocation(services.getZooKeeper()))) {
            services.getAssignmentManager().assignMeta(HRegionInfo.FIRST_META_REGIONINFO);
        } else {
            LOG.info((Object)("Skip assigning hbase:meta because it is online at " + services.getMetaTableLocator().getMetaRegionLocation(services.getZooKeeper())));
        }
    }

    private boolean isMetaAssignedQuickTest(MasterProcedureEnv env) throws InterruptedException, IOException {
        long timeout;
        ClusterConnection connection;
        ZooKeeperWatcher zkw = env.getMasterServices().getZooKeeper();
        MetaTableLocator mtl = env.getMasterServices().getMetaTableLocator();
        boolean metaAssigned = false;
        if (mtl.isLocationAvailable(zkw) && mtl.verifyMetaRegionLocation(connection = env.getMasterServices().getConnection(), zkw, timeout = env.getMasterConfiguration().getLong(KEY_SHORT_WAIT_ON_META, 1000L))) {
            metaAssigned = true;
        }
        return metaAssigned;
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return this.carryingMeta;
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.CRASH_HANDLER;
    }

    @Override
    protected boolean isYieldBeforeExecuteFromState(MasterProcedureEnv env, MasterProcedureProtos.ServerCrashState state) {
        return true;
    }

    @Override
    protected boolean shouldWaitClientAck(MasterProcedureEnv env) {
        return false;
    }

    static {
        META_REGION_SET.add(HRegionInfo.FIRST_META_REGIONINFO);
    }
}

