/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.ResizableBlockCache;
import org.apache.hadoop.hbase.io.util.HeapMemorySizeUtil;
import org.apache.hadoop.hbase.regionserver.DefaultHeapMemoryTuner;
import org.apache.hadoop.hbase.regionserver.FlushRequestListener;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.FlushType;
import org.apache.hadoop.hbase.regionserver.HeapMemoryTuner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public class HeapMemoryManager {
    private static final Log LOG = LogFactory.getLog(HeapMemoryManager.class);
    private static final int CONVERT_TO_PERCENTAGE = 100;
    private static final int CLUSTER_MINIMUM_MEMORY_THRESHOLD = 20;
    public static final String BLOCK_CACHE_SIZE_MAX_RANGE_KEY = "hfile.block.cache.size.max.range";
    public static final String BLOCK_CACHE_SIZE_MIN_RANGE_KEY = "hfile.block.cache.size.min.range";
    public static final String MEMSTORE_SIZE_MAX_RANGE_KEY = "hbase.regionserver.global.memstore.size.max.range";
    public static final String MEMSTORE_SIZE_MIN_RANGE_KEY = "hbase.regionserver.global.memstore.size.min.range";
    public static final String HBASE_RS_HEAP_MEMORY_TUNER_PERIOD = "hbase.regionserver.heapmemory.tuner.period";
    public static final int HBASE_RS_HEAP_MEMORY_TUNER_DEFAULT_PERIOD = 60000;
    public static final String HBASE_RS_HEAP_MEMORY_TUNER_CLASS = "hbase.regionserver.heapmemory.tuner.class";
    private float globalMemStorePercent;
    private float globalMemStorePercentMinRange;
    private float globalMemStorePercentMaxRange;
    private float blockCachePercent;
    private float blockCachePercentMinRange;
    private float blockCachePercentMaxRange;
    private float l2BlockCachePercent;
    private float heapOccupancyPercent;
    private final ResizableBlockCache blockCache;
    private final FlushRequester memStoreFlusher;
    private final Server server;
    private final RegionServerAccounting regionServerAccounting;
    private HeapMemoryTunerChore heapMemTunerChore = null;
    private final boolean tunerOn;
    private final int defaultChorePeriod;
    private final float heapOccupancyLowWatermark;
    private long maxHeapSize = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();

    public static HeapMemoryManager create(Configuration conf, FlushRequester memStoreFlusher, Server server, RegionServerAccounting regionServerAccounting) {
        BlockCache blockCache = CacheConfig.instantiateBlockCache(conf);
        if (blockCache instanceof ResizableBlockCache) {
            return new HeapMemoryManager((ResizableBlockCache)blockCache, memStoreFlusher, server, regionServerAccounting);
        }
        return null;
    }

    @VisibleForTesting
    HeapMemoryManager(ResizableBlockCache blockCache, FlushRequester memStoreFlusher, Server server, RegionServerAccounting regionServerAccounting) {
        Configuration conf = server.getConfiguration();
        this.blockCache = blockCache;
        this.memStoreFlusher = memStoreFlusher;
        this.server = server;
        this.regionServerAccounting = regionServerAccounting;
        this.tunerOn = this.doInit(conf);
        this.defaultChorePeriod = conf.getInt(HBASE_RS_HEAP_MEMORY_TUNER_PERIOD, 60000);
        this.heapOccupancyLowWatermark = conf.getFloat("hbase.heap.occupancy.low_water_mark", 0.95f);
    }

    private boolean doInit(Configuration conf) {
        boolean tuningEnabled = true;
        this.globalMemStorePercent = HeapMemorySizeUtil.getGlobalMemStorePercent(conf, false);
        this.blockCachePercent = conf.getFloat("hfile.block.cache.size", 0.4f);
        HeapMemorySizeUtil.checkForClusterFreeMemoryLimit(conf);
        this.globalMemStorePercentMinRange = conf.getFloat(MEMSTORE_SIZE_MIN_RANGE_KEY, this.globalMemStorePercent);
        this.globalMemStorePercentMaxRange = conf.getFloat(MEMSTORE_SIZE_MAX_RANGE_KEY, this.globalMemStorePercent);
        if (this.globalMemStorePercent < this.globalMemStorePercentMinRange) {
            LOG.warn((Object)("Setting hbase.regionserver.global.memstore.size.min.range to " + this.globalMemStorePercent + ", same value as " + "hbase.regionserver.global.memstore.size" + " because supplied value greater than initial memstore size value."));
            this.globalMemStorePercentMinRange = this.globalMemStorePercent;
            conf.setFloat(MEMSTORE_SIZE_MIN_RANGE_KEY, this.globalMemStorePercentMinRange);
        }
        if (this.globalMemStorePercent > this.globalMemStorePercentMaxRange) {
            LOG.warn((Object)("Setting hbase.regionserver.global.memstore.size.max.range to " + this.globalMemStorePercent + ", same value as " + "hbase.regionserver.global.memstore.size" + " because supplied value less than initial memstore size value."));
            this.globalMemStorePercentMaxRange = this.globalMemStorePercent;
            conf.setFloat(MEMSTORE_SIZE_MAX_RANGE_KEY, this.globalMemStorePercentMaxRange);
        }
        if (this.globalMemStorePercent == this.globalMemStorePercentMinRange && this.globalMemStorePercent == this.globalMemStorePercentMaxRange) {
            tuningEnabled = false;
        }
        this.blockCachePercentMinRange = conf.getFloat(BLOCK_CACHE_SIZE_MIN_RANGE_KEY, this.blockCachePercent);
        this.blockCachePercentMaxRange = conf.getFloat(BLOCK_CACHE_SIZE_MAX_RANGE_KEY, this.blockCachePercent);
        if (this.blockCachePercent < this.blockCachePercentMinRange) {
            LOG.warn((Object)("Setting hfile.block.cache.size.min.range to " + this.blockCachePercent + ", same value as " + "hfile.block.cache.size" + " because supplied value greater than initial block cache size."));
            this.blockCachePercentMinRange = this.blockCachePercent;
            conf.setFloat(BLOCK_CACHE_SIZE_MIN_RANGE_KEY, this.blockCachePercentMinRange);
        }
        if (this.blockCachePercent > this.blockCachePercentMaxRange) {
            LOG.warn((Object)("Setting hfile.block.cache.size.max.range to " + this.blockCachePercent + ", same value as " + "hfile.block.cache.size" + " because supplied value less than initial block cache size."));
            this.blockCachePercentMaxRange = this.blockCachePercent;
            conf.setFloat(BLOCK_CACHE_SIZE_MAX_RANGE_KEY, this.blockCachePercentMaxRange);
        }
        if (tuningEnabled && this.blockCachePercent == this.blockCachePercentMinRange && this.blockCachePercent == this.blockCachePercentMaxRange) {
            tuningEnabled = false;
        }
        int gml = (int)(this.globalMemStorePercentMaxRange * 100.0f);
        this.l2BlockCachePercent = HeapMemorySizeUtil.getL2BlockCacheHeapPercent(conf);
        int bcul = (int)((this.blockCachePercentMinRange + this.l2BlockCachePercent) * 100.0f);
        if (100 - (gml + bcul) < 20) {
            throw new RuntimeException("Current heap configuration for MemStore and BlockCache exceeds the threshold required for successful cluster operation. The combined value cannot exceed 0.8. Please check the settings for hbase.regionserver.global.memstore.size.max.range and hfile.block.cache.size.min.range in your configuration. hbase.regionserver.global.memstore.size.max.range is " + this.globalMemStorePercentMaxRange + " and " + BLOCK_CACHE_SIZE_MIN_RANGE_KEY + " is " + this.blockCachePercentMinRange);
        }
        gml = (int)(this.globalMemStorePercentMinRange * 100.0f);
        bcul = (int)((this.blockCachePercentMaxRange + this.l2BlockCachePercent) * 100.0f);
        if (100 - (gml + bcul) < 20) {
            throw new RuntimeException("Current heap configuration for MemStore and BlockCache exceeds the threshold required for successful cluster operation. The combined value cannot exceed 0.8. Please check the settings for hbase.regionserver.global.memstore.size.min.range and hfile.block.cache.size.max.range in your configuration. hbase.regionserver.global.memstore.size.min.range is " + this.globalMemStorePercentMinRange + " and " + BLOCK_CACHE_SIZE_MAX_RANGE_KEY + " is " + this.blockCachePercentMaxRange);
        }
        return tuningEnabled;
    }

    public void start(ChoreService service) {
        LOG.info((Object)"Starting HeapMemoryTuner chore.");
        this.heapMemTunerChore = new HeapMemoryTunerChore();
        service.scheduleChore(this.heapMemTunerChore);
        if (this.tunerOn) {
            this.memStoreFlusher.registerFlushRequestListener(this.heapMemTunerChore);
        }
    }

    public void stop() {
        LOG.info((Object)"Stoping HeapMemoryTuner chore.");
        this.heapMemTunerChore.cancel(true);
    }

    boolean isTunerOn() {
        return this.tunerOn;
    }

    public float getHeapOccupancyPercent() {
        return this.heapOccupancyPercent;
    }

    public static final class TunerResult {
        private float memstoreSize;
        private float blockCacheSize;
        private final boolean needsTuning;

        public TunerResult(boolean needsTuning) {
            this.needsTuning = needsTuning;
        }

        public float getMemstoreSize() {
            return this.memstoreSize;
        }

        public void setMemstoreSize(float memstoreSize) {
            this.memstoreSize = memstoreSize;
        }

        public float getBlockCacheSize() {
            return this.blockCacheSize;
        }

        public void setBlockCacheSize(float blockCacheSize) {
            this.blockCacheSize = blockCacheSize;
        }

        public boolean needsTuning() {
            return this.needsTuning;
        }
    }

    public static final class TunerContext {
        private long blockedFlushCount;
        private long unblockedFlushCount;
        private long evictCount;
        private long cacheMissCount;
        private float curBlockCacheUsed;
        private float curMemStoreUsed;
        private float curMemStoreSize;
        private float curBlockCacheSize;

        public long getBlockedFlushCount() {
            return this.blockedFlushCount;
        }

        public void setBlockedFlushCount(long blockedFlushCount) {
            this.blockedFlushCount = blockedFlushCount;
        }

        public long getUnblockedFlushCount() {
            return this.unblockedFlushCount;
        }

        public void setUnblockedFlushCount(long unblockedFlushCount) {
            this.unblockedFlushCount = unblockedFlushCount;
        }

        public long getEvictCount() {
            return this.evictCount;
        }

        public void setEvictCount(long evictCount) {
            this.evictCount = evictCount;
        }

        public float getCurMemStoreSize() {
            return this.curMemStoreSize;
        }

        public void setCurMemStoreSize(float curMemStoreSize) {
            this.curMemStoreSize = curMemStoreSize;
        }

        public float getCurBlockCacheSize() {
            return this.curBlockCacheSize;
        }

        public void setCurBlockCacheSize(float curBlockCacheSize) {
            this.curBlockCacheSize = curBlockCacheSize;
        }

        public long getCacheMissCount() {
            return this.cacheMissCount;
        }

        public void setCacheMissCount(long cacheMissCount) {
            this.cacheMissCount = cacheMissCount;
        }

        public float getCurBlockCacheUsed() {
            return this.curBlockCacheUsed;
        }

        public void setCurBlockCacheUsed(float curBlockCacheUsed) {
            this.curBlockCacheUsed = curBlockCacheUsed;
        }

        public float getCurMemStoreUsed() {
            return this.curMemStoreUsed;
        }

        public void setCurMemStoreUsed(float d) {
            this.curMemStoreUsed = d;
        }
    }

    private class HeapMemoryTunerChore
    extends ScheduledChore
    implements FlushRequestListener {
        private HeapMemoryTuner heapMemTuner;
        private AtomicLong blockedFlushCount;
        private AtomicLong unblockedFlushCount;
        private long evictCount;
        private long cacheMissCount;
        private TunerContext tunerContext;
        private boolean alarming;

        public HeapMemoryTunerChore() {
            super(HeapMemoryManager.this.server.getServerName() + "-HeapMemoryTunerChore", HeapMemoryManager.this.server, HeapMemoryManager.this.defaultChorePeriod);
            this.blockedFlushCount = new AtomicLong();
            this.unblockedFlushCount = new AtomicLong();
            this.evictCount = 0L;
            this.cacheMissCount = 0L;
            this.tunerContext = new TunerContext();
            this.alarming = false;
            Class<HeapMemoryTuner> tunerKlass = HeapMemoryManager.this.server.getConfiguration().getClass(HeapMemoryManager.HBASE_RS_HEAP_MEMORY_TUNER_CLASS, DefaultHeapMemoryTuner.class, HeapMemoryTuner.class);
            this.heapMemTuner = ReflectionUtils.newInstance(tunerKlass, HeapMemoryManager.this.server.getConfiguration());
        }

        @Override
        protected void chore() {
            MemoryUsage memUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            HeapMemoryManager.this.heapOccupancyPercent = (float)memUsage.getUsed() / (float)memUsage.getCommitted();
            if (HeapMemoryManager.this.heapOccupancyPercent >= HeapMemoryManager.this.heapOccupancyLowWatermark) {
                if (!this.alarming) {
                    LOG.warn((Object)("heapOccupancyPercent " + HeapMemoryManager.this.heapOccupancyPercent + " is above heap occupancy alarm watermark (" + HeapMemoryManager.this.heapOccupancyLowWatermark + ")"));
                    this.alarming = true;
                }
                this.triggerNow();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else if (this.alarming) {
                LOG.info((Object)("heapOccupancyPercent " + HeapMemoryManager.this.heapOccupancyPercent + " is now below the heap occupancy alarm watermark (" + HeapMemoryManager.this.heapOccupancyLowWatermark + ")"));
                this.alarming = false;
            }
            if (HeapMemoryManager.this.tunerOn && !this.alarming) {
                this.tune();
            }
        }

        private void tune() {
            long curEvictCount = HeapMemoryManager.this.blockCache.getStats().getEvictedCount();
            this.tunerContext.setEvictCount(curEvictCount - this.evictCount);
            this.evictCount = curEvictCount;
            long curCacheMisCount = HeapMemoryManager.this.blockCache.getStats().getMissCachingCount();
            this.tunerContext.setCacheMissCount(curCacheMisCount - this.cacheMissCount);
            this.cacheMissCount = curCacheMisCount;
            this.tunerContext.setBlockedFlushCount(this.blockedFlushCount.getAndSet(0L));
            this.tunerContext.setUnblockedFlushCount(this.unblockedFlushCount.getAndSet(0L));
            this.tunerContext.setCurBlockCacheUsed((float)HeapMemoryManager.this.blockCache.getCurrentSize() / (float)HeapMemoryManager.this.maxHeapSize);
            this.tunerContext.setCurMemStoreUsed((float)HeapMemoryManager.this.regionServerAccounting.getGlobalMemstoreSize() / (float)HeapMemoryManager.this.maxHeapSize);
            this.tunerContext.setCurBlockCacheSize(HeapMemoryManager.this.blockCachePercent);
            this.tunerContext.setCurMemStoreSize(HeapMemoryManager.this.globalMemStorePercent);
            TunerResult result = null;
            try {
                result = this.heapMemTuner.tune(this.tunerContext);
            }
            catch (Throwable t) {
                LOG.error((Object)"Exception thrown from the HeapMemoryTuner implementation", t);
            }
            if (result != null && result.needsTuning()) {
                float memstoreSize = result.getMemstoreSize();
                float blockCacheSize = result.getBlockCacheSize();
                LOG.debug((Object)("From HeapMemoryTuner new memstoreSize: " + memstoreSize + ". new blockCacheSize: " + blockCacheSize));
                if (memstoreSize < HeapMemoryManager.this.globalMemStorePercentMinRange) {
                    LOG.info((Object)("New memstoreSize from HeapMemoryTuner " + memstoreSize + " is below min level " + HeapMemoryManager.this.globalMemStorePercentMinRange + ". Resetting memstoreSize to min size"));
                    memstoreSize = HeapMemoryManager.this.globalMemStorePercentMinRange;
                } else if (memstoreSize > HeapMemoryManager.this.globalMemStorePercentMaxRange) {
                    LOG.info((Object)("New memstoreSize from HeapMemoryTuner " + memstoreSize + " is above max level " + HeapMemoryManager.this.globalMemStorePercentMaxRange + ". Resetting memstoreSize to max size"));
                    memstoreSize = HeapMemoryManager.this.globalMemStorePercentMaxRange;
                }
                if (blockCacheSize < HeapMemoryManager.this.blockCachePercentMinRange) {
                    LOG.info((Object)("New blockCacheSize from HeapMemoryTuner " + blockCacheSize + " is below min level " + HeapMemoryManager.this.blockCachePercentMinRange + ". Resetting blockCacheSize to min size"));
                    blockCacheSize = HeapMemoryManager.this.blockCachePercentMinRange;
                } else if (blockCacheSize > HeapMemoryManager.this.blockCachePercentMaxRange) {
                    LOG.info((Object)("New blockCacheSize from HeapMemoryTuner " + blockCacheSize + " is above max level " + HeapMemoryManager.this.blockCachePercentMaxRange + ". Resetting blockCacheSize to min size"));
                    blockCacheSize = HeapMemoryManager.this.blockCachePercentMaxRange;
                }
                int gml = (int)(memstoreSize * 100.0f);
                int bcul = (int)((blockCacheSize + HeapMemoryManager.this.l2BlockCachePercent) * 100.0f);
                if (100 - (gml + bcul) < 20) {
                    LOG.info((Object)("Current heap configuration from HeapMemoryTuner exceeds the threshold required for successful cluster operation. The combined value cannot exceed 0.8. hbase.regionserver.global.memstore.size is " + memstoreSize + " and " + "hfile.block.cache.size" + " is " + blockCacheSize));
                } else {
                    long newBlockCacheSize = (long)((float)HeapMemoryManager.this.maxHeapSize * blockCacheSize);
                    long newMemstoreSize = (long)((float)HeapMemoryManager.this.maxHeapSize * memstoreSize);
                    LOG.info((Object)("Setting block cache heap size to " + newBlockCacheSize + " and memstore heap size to " + newMemstoreSize));
                    HeapMemoryManager.this.blockCachePercent = blockCacheSize;
                    HeapMemoryManager.this.blockCache.setMaxSize(newBlockCacheSize);
                    HeapMemoryManager.this.globalMemStorePercent = memstoreSize;
                    HeapMemoryManager.this.memStoreFlusher.setGlobalMemstoreLimit(newMemstoreSize);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No changes made by HeapMemoryTuner.");
            }
        }

        @Override
        public void flushRequested(FlushType type, Region region) {
            switch (type) {
                case ABOVE_HIGHER_MARK: {
                    this.blockedFlushCount.incrementAndGet();
                    break;
                }
                case ABOVE_LOWER_MARK: {
                    this.unblockedFlushCount.incrementAndGet();
                    break;
                }
            }
        }
    }
}

