/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ReversedKeyValueHeap;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;

@InterfaceAudience.Private
class ReversedStoreScanner
extends StoreScanner
implements KeyValueScanner {
    ReversedStoreScanner(Store store, ScanInfo scanInfo, Scan scan, NavigableSet<byte[]> columns, long readPt) throws IOException {
        super(store, scanInfo, scan, columns, readPt);
    }

    ReversedStoreScanner(Scan scan, ScanInfo scanInfo, ScanType scanType, NavigableSet<byte[]> columns, List<KeyValueScanner> scanners) throws IOException {
        super(scan, scanInfo, scanType, columns, scanners, Long.MAX_VALUE);
    }

    @Override
    protected void resetKVHeap(List<? extends KeyValueScanner> scanners, KeyValue.KVComparator comparator) throws IOException {
        this.heap = new ReversedKeyValueHeap(scanners, comparator);
    }

    @Override
    protected void seekScanners(List<? extends KeyValueScanner> scanners, Cell seekKey, boolean isLazy, boolean isParallelSeek) throws IOException {
        if (CellUtil.matchingRow(seekKey, HConstants.EMPTY_START_ROW)) {
            for (KeyValueScanner keyValueScanner : scanners) {
                keyValueScanner.seekToLastRow();
            }
        } else {
            for (KeyValueScanner keyValueScanner : scanners) {
                keyValueScanner.backwardSeek(seekKey);
            }
        }
    }

    @Override
    protected boolean seekToNextRow(Cell kv) throws IOException {
        return this.seekToPreviousRow(kv);
    }

    @Override
    protected boolean seekAsDirection(Cell kv) throws IOException {
        return this.backwardSeek(kv);
    }

    @Override
    protected void checkScanOrder(Cell prevKV, Cell kv, KeyValue.KVComparator comparator) throws IOException {
        assert (prevKV == null || comparator == null || comparator.compareRows(kv, prevKV) < 0 || comparator.matchingRows(kv, prevKV) && comparator.compare(kv, prevKV) >= 0) : "Key " + prevKV + " followed by a " + "error order key " + kv + " in cf " + this.store + " in reversed scan";
    }

    @Override
    public boolean reseek(Cell kv) throws IOException {
        throw new IllegalStateException("reseek cannot be called on ReversedStoreScanner");
    }

    @Override
    public boolean seek(Cell key) throws IOException {
        throw new IllegalStateException("seek cannot be called on ReversedStoreScanner");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean seekToPreviousRow(Cell key) throws IOException {
        this.lock.lock();
        try {
            this.checkReseek();
            boolean bl = this.heap.seekToPreviousRow(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean backwardSeek(Cell key) throws IOException {
        this.lock.lock();
        try {
            this.checkReseek();
            boolean bl = this.heap.backwardSeek(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

