/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class MetricsReplicationGlobalSourceSource
implements MetricsReplicationSourceSource {
    private final MetricsReplicationSourceImpl rms;
    private final MutableGaugeLong ageOfLastShippedOpGauge;
    private final MutableGaugeLong sizeOfLogQueueGauge;
    private final MutableCounterLong logReadInEditsCounter;
    private final MutableCounterLong logEditsFilteredCounter;
    private final MutableCounterLong shippedBatchesCounter;
    private final MutableCounterLong shippedOpsCounter;
    private final MutableCounterLong shippedKBsCounter;
    private final MutableCounterLong logReadInBytesCounter;

    public MetricsReplicationGlobalSourceSource(MetricsReplicationSourceImpl rms) {
        this.rms = rms;
        this.ageOfLastShippedOpGauge = rms.getMetricsRegistry().getLongGauge("source.ageOfLastShippedOp", 0L);
        this.sizeOfLogQueueGauge = rms.getMetricsRegistry().getLongGauge("source.sizeOfLogQueue", 0L);
        this.shippedBatchesCounter = rms.getMetricsRegistry().getLongCounter("source.shippedBatches", 0L);
        this.shippedOpsCounter = rms.getMetricsRegistry().getLongCounter("source.shippedOps", 0L);
        this.shippedKBsCounter = rms.getMetricsRegistry().getLongCounter("source.shippedKBs", 0L);
        this.logReadInBytesCounter = rms.getMetricsRegistry().getLongCounter("source.logReadInBytes", 0L);
        this.logReadInEditsCounter = rms.getMetricsRegistry().getLongCounter("source.logEditsRead", 0L);
        this.logEditsFilteredCounter = rms.getMetricsRegistry().getLongCounter("source.logEditsFiltered", 0L);
    }

    @Override
    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpGauge.set(age);
    }

    @Override
    public void setSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.set(size);
    }

    @Override
    public void incrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.incr(size);
    }

    @Override
    public void decrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.decr(size);
    }

    @Override
    public void incrLogReadInEdits(long size) {
        this.logReadInEditsCounter.incr(size);
    }

    @Override
    public void incrLogEditsFiltered(long size) {
        this.logEditsFilteredCounter.incr(size);
    }

    @Override
    public void incrBatchesShipped(int batches) {
        this.shippedBatchesCounter.incr(batches);
    }

    @Override
    public void incrOpsShipped(long ops) {
        this.shippedOpsCounter.incr(ops);
    }

    @Override
    public void incrShippedKBs(long size) {
        this.shippedKBsCounter.incr(size);
    }

    @Override
    public void incrLogReadInBytes(long size) {
        this.logReadInBytesCounter.incr(size);
    }

    @Override
    public void clear() {
    }

    @Override
    public long getLastShippedAge() {
        return this.ageOfLastShippedOpGauge.value();
    }
}

