/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class MetricsReplicationSourceSourceImpl
implements MetricsReplicationSourceSource {
    private final MetricsReplicationSourceImpl rms;
    private final String id;
    private final String sizeOfLogQueueKey;
    private final String ageOfLastShippedOpKey;
    private final String logReadInEditsKey;
    private final String logEditsFilteredKey;
    private final String shippedBatchesKey;
    private final String shippedOpsKey;
    private final String shippedKBsKey;
    private final String logReadInBytesKey;
    private final MutableGaugeLong ageOfLastShippedOpGauge;
    private final MutableGaugeLong sizeOfLogQueueGauge;
    private final MutableCounterLong logReadInEditsCounter;
    private final MutableCounterLong logEditsFilteredCounter;
    private final MutableCounterLong shippedBatchesCounter;
    private final MutableCounterLong shippedOpsCounter;
    private final MutableCounterLong shippedKBsCounter;
    private final MutableCounterLong logReadInBytesCounter;

    public MetricsReplicationSourceSourceImpl(MetricsReplicationSourceImpl rms, String id) {
        this.rms = rms;
        this.id = id;
        this.ageOfLastShippedOpKey = "source." + id + ".ageOfLastShippedOp";
        this.ageOfLastShippedOpGauge = rms.getMetricsRegistry().getLongGauge(this.ageOfLastShippedOpKey, 0L);
        this.sizeOfLogQueueKey = "source." + id + ".sizeOfLogQueue";
        this.sizeOfLogQueueGauge = rms.getMetricsRegistry().getLongGauge(this.sizeOfLogQueueKey, 0L);
        this.shippedBatchesKey = "source." + this.id + ".shippedBatches";
        this.shippedBatchesCounter = rms.getMetricsRegistry().getLongCounter(this.shippedBatchesKey, 0L);
        this.shippedOpsKey = "source." + this.id + ".shippedOps";
        this.shippedOpsCounter = rms.getMetricsRegistry().getLongCounter(this.shippedOpsKey, 0L);
        this.shippedKBsKey = "source." + this.id + ".shippedKBs";
        this.shippedKBsCounter = rms.getMetricsRegistry().getLongCounter(this.shippedKBsKey, 0L);
        this.logReadInBytesKey = "source." + this.id + ".logReadInBytes";
        this.logReadInBytesCounter = rms.getMetricsRegistry().getLongCounter(this.logReadInBytesKey, 0L);
        this.logReadInEditsKey = "source." + id + ".logEditsRead";
        this.logReadInEditsCounter = rms.getMetricsRegistry().getLongCounter(this.logReadInEditsKey, 0L);
        this.logEditsFilteredKey = "source." + id + ".logEditsFiltered";
        this.logEditsFilteredCounter = rms.getMetricsRegistry().getLongCounter(this.logEditsFilteredKey, 0L);
    }

    @Override
    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpGauge.set(age);
    }

    @Override
    public void setSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.set(size);
    }

    @Override
    public void incrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.incr(size);
    }

    @Override
    public void decrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.decr(size);
    }

    @Override
    public void incrLogReadInEdits(long size) {
        this.logReadInEditsCounter.incr(size);
    }

    @Override
    public void incrLogEditsFiltered(long size) {
        this.logEditsFilteredCounter.incr(size);
    }

    @Override
    public void incrBatchesShipped(int batches) {
        this.shippedBatchesCounter.incr(batches);
    }

    @Override
    public void incrOpsShipped(long ops) {
        this.shippedOpsCounter.incr(ops);
    }

    @Override
    public void incrShippedKBs(long size) {
        this.shippedKBsCounter.incr(size);
    }

    @Override
    public void incrLogReadInBytes(long size) {
        this.logReadInBytesCounter.incr(size);
    }

    @Override
    public void clear() {
        this.rms.removeMetric(this.ageOfLastShippedOpKey);
        this.rms.removeMetric(this.sizeOfLogQueueKey);
        this.rms.removeMetric(this.shippedBatchesKey);
        this.rms.removeMetric(this.shippedOpsKey);
        this.rms.removeMetric(this.shippedKBsKey);
        this.rms.removeMetric(this.logReadInBytesKey);
        this.rms.removeMetric(this.logReadInEditsKey);
        this.rms.removeMetric(this.logEditsFilteredKey);
    }

    @Override
    public long getLastShippedAge() {
        return this.ageOfLastShippedOpGauge.value();
    }
}

