/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceFactory;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public class MetricsSource {
    private static final Log LOG = LogFactory.getLog(MetricsSource.class);
    private Map<String, Long> lastTimeStamps = new HashMap<String, Long>();
    private int lastQueueSize = 0;
    private String id;
    private final MetricsReplicationSourceSource singleSourceSource;
    private final MetricsReplicationSourceSource globalSourceSource;

    public MetricsSource(String id) {
        this.id = id;
        this.singleSourceSource = CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class).getSource(id);
        this.globalSourceSource = CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class).getGlobalSource();
    }

    public void setAgeOfLastShippedOp(long timestamp, String walGroup) {
        long age = EnvironmentEdgeManager.currentTime() - timestamp;
        this.singleSourceSource.setLastShippedAge(age);
        this.globalSourceSource.setLastShippedAge(age);
        this.lastTimeStamps.put(walGroup, timestamp);
    }

    public void refreshAgeOfLastShippedOp(String walGroupId) {
        Long lastTimestamp = this.lastTimeStamps.get(walGroupId);
        if (lastTimestamp == null) {
            this.lastTimeStamps.put(walGroupId, 0L);
            lastTimestamp = 0L;
        }
        if (lastTimestamp > 0L) {
            this.setAgeOfLastShippedOp(lastTimestamp, walGroupId);
        }
    }

    public void setSizeOfLogQueue(int size) {
        this.singleSourceSource.setSizeOfLogQueue(size);
        this.globalSourceSource.incrSizeOfLogQueue(size - this.lastQueueSize);
        this.lastQueueSize = size;
    }

    private void incrLogEditsRead(long delta) {
        this.singleSourceSource.incrLogReadInEdits(delta);
        this.globalSourceSource.incrLogReadInEdits(delta);
    }

    public void incrLogEditsRead() {
        this.incrLogEditsRead(1L);
    }

    public void incrLogEditsFiltered(long delta) {
        this.singleSourceSource.incrLogEditsFiltered(delta);
        this.globalSourceSource.incrLogEditsFiltered(delta);
    }

    public void incrLogEditsFiltered() {
        this.incrLogEditsFiltered(1L);
    }

    public void shipBatch(long batchSize, int sizeInKB) {
        this.singleSourceSource.incrBatchesShipped(1);
        this.globalSourceSource.incrBatchesShipped(1);
        this.singleSourceSource.incrOpsShipped(batchSize);
        this.globalSourceSource.incrOpsShipped(batchSize);
        this.singleSourceSource.incrShippedKBs(sizeInKB);
        this.globalSourceSource.incrShippedKBs(sizeInKB);
    }

    public void incrLogReadInBytes(long readInBytes) {
        this.singleSourceSource.incrLogReadInBytes(readInBytes);
        this.globalSourceSource.incrLogReadInBytes(readInBytes);
    }

    public void clear() {
        this.singleSourceSource.clear();
        this.globalSourceSource.decrSizeOfLogQueue(this.lastQueueSize);
        this.lastTimeStamps.clear();
        this.lastQueueSize = 0;
    }

    public Long getAgeOfLastShippedOp() {
        return this.singleSourceSource.getLastShippedAge();
    }

    public int getSizeOfLogQueue() {
        return this.lastQueueSize;
    }

    public long getTimeStampOfLastShippedOp() {
        long lastTimestamp = 0L;
        for (long ts : this.lastTimeStamps.values()) {
            if (ts <= lastTimestamp) continue;
            lastTimestamp = ts;
        }
        return lastTimestamp;
    }

    public String getPeerID() {
        return this.id;
    }
}

