/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.event.ConfigurationErrorEvent;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.event.ConfigurationListener;

public class EventSource {
    private Collection listeners;
    private Collection errorListeners;
    private int detailEvents;

    public EventSource() {
        this.initListeners();
    }

    public void addConfigurationListener(ConfigurationListener l) {
        EventSource.doAddListener(this.listeners, l);
    }

    public boolean removeConfigurationListener(ConfigurationListener l) {
        return EventSource.doRemoveListener(this.listeners, l);
    }

    public Collection getConfigurationListeners() {
        return EventSource.doGetListeners(this.listeners);
    }

    public void clearConfigurationListeners() {
        EventSource.doClearListeners(this.listeners);
    }

    public boolean isDetailEvents() {
        Collection collection = this.listeners;
        synchronized (collection) {
            boolean bl = this.detailEvents > 0;
            return bl;
        }
    }

    public void setDetailEvents(boolean enable) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.detailEvents = enable ? ++this.detailEvents : --this.detailEvents;
        }
    }

    public void addErrorListener(ConfigurationErrorListener l) {
        EventSource.doAddListener(this.errorListeners, l);
    }

    public boolean removeErrorListener(ConfigurationErrorListener l) {
        return EventSource.doRemoveListener(this.errorListeners, l);
    }

    public void clearErrorListeners() {
        EventSource.doClearListeners(this.errorListeners);
    }

    public Collection getErrorListeners() {
        return EventSource.doGetListeners(this.errorListeners);
    }

    protected void fireEvent(int type, String propName, Object propValue, boolean before) {
        ArrayList listenersToCall = null;
        Collection collection = this.listeners;
        synchronized (collection) {
            if (this.detailEvents >= 0 && this.listeners.size() > 0) {
                listenersToCall = new ArrayList(this.listeners);
            }
        }
        if (listenersToCall != null) {
            ConfigurationEvent event = this.createEvent(type, propName, propValue, before);
            Iterator it = listenersToCall.iterator();
            while (it.hasNext()) {
                ((ConfigurationListener)it.next()).configurationChanged(event);
            }
        }
    }

    protected ConfigurationEvent createEvent(int type, String propName, Object propValue, boolean before) {
        return new ConfigurationEvent(this, type, propName, propValue, before);
    }

    protected void fireError(int type, String propName, Object propValue, Throwable ex) {
        ArrayList listenersToCall = null;
        Collection collection = this.errorListeners;
        synchronized (collection) {
            if (this.errorListeners.size() > 0) {
                listenersToCall = new ArrayList(this.errorListeners);
            }
        }
        if (listenersToCall != null) {
            ConfigurationErrorEvent event = this.createErrorEvent(type, propName, propValue, ex);
            Iterator it = listenersToCall.iterator();
            while (it.hasNext()) {
                ((ConfigurationErrorListener)it.next()).configurationError(event);
            }
        }
    }

    protected ConfigurationErrorEvent createErrorEvent(int type, String propName, Object propValue, Throwable ex) {
        return new ConfigurationErrorEvent((Object)this, type, propName, propValue, ex);
    }

    protected Object clone() throws CloneNotSupportedException {
        EventSource copy = (EventSource)super.clone();
        copy.initListeners();
        return copy;
    }

    private static void doAddListener(Collection listeners, Object l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener must not be null!");
        }
        Collection collection = listeners;
        synchronized (collection) {
            listeners.add(l);
        }
    }

    private static boolean doRemoveListener(Collection listeners, Object l) {
        Collection collection = listeners;
        synchronized (collection) {
            boolean bl = listeners.remove(l);
            return bl;
        }
    }

    private static void doClearListeners(Collection listeners) {
        Collection collection = listeners;
        synchronized (collection) {
            listeners.clear();
        }
    }

    private static Collection doGetListeners(Collection listeners) {
        Collection collection = listeners;
        synchronized (collection) {
            Collection collection2 = Collections.unmodifiableCollection(new ArrayList(listeners));
            return collection2;
        }
    }

    private void initListeners() {
        this.listeners = new LinkedList();
        this.errorListeners = new LinkedList();
    }
}

