/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.CodedInputStream;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotManifestV1;
import org.apache.hadoop.hbase.snapshot.SnapshotManifestV2;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public class SnapshotManifest {
    private static final Log LOG = LogFactory.getLog(SnapshotManifest.class);
    public static final String SNAPSHOT_MANIFEST_SIZE_LIMIT_CONF_KEY = "snapshot.manifest.size.limit";
    public static final String DATA_MANIFEST_NAME = "data.manifest";
    private List<SnapshotProtos.SnapshotRegionManifest> regionManifests;
    private HBaseProtos.SnapshotDescription desc;
    private HTableDescriptor htd;
    private final ForeignExceptionSnare monitor;
    private final Configuration conf;
    private final Path workingDir;
    private final FileSystem fs;
    private int manifestSizeLimit;

    private SnapshotManifest(Configuration conf, FileSystem fs, Path workingDir, HBaseProtos.SnapshotDescription desc, ForeignExceptionSnare monitor) {
        this.monitor = monitor;
        this.desc = desc;
        this.workingDir = workingDir;
        this.conf = conf;
        this.fs = fs;
        this.manifestSizeLimit = conf.getInt(SNAPSHOT_MANIFEST_SIZE_LIMIT_CONF_KEY, 0x4000000);
    }

    public static SnapshotManifest create(Configuration conf, FileSystem fs, Path workingDir, HBaseProtos.SnapshotDescription desc, ForeignExceptionSnare monitor) {
        return new SnapshotManifest(conf, fs, workingDir, desc, monitor);
    }

    public static SnapshotManifest open(Configuration conf, FileSystem fs, Path workingDir, HBaseProtos.SnapshotDescription desc) throws IOException {
        SnapshotManifest manifest = new SnapshotManifest(conf, fs, workingDir, desc, null);
        manifest.load();
        return manifest;
    }

    public void addTableDescriptor(HTableDescriptor htd) throws IOException {
        this.htd = htd;
    }

    private RegionVisitor createRegionVisitor(HBaseProtos.SnapshotDescription desc) throws IOException {
        switch (SnapshotManifest.getSnapshotFormat(desc)) {
            case 0: {
                return new SnapshotManifestV1.ManifestBuilder(this.conf, this.fs, this.workingDir);
            }
            case 2: {
                return new SnapshotManifestV2.ManifestBuilder(this.conf, this.fs, this.workingDir);
            }
        }
        throw new CorruptedSnapshotException("Invalid Snapshot version: " + desc.getVersion(), desc);
    }

    public void addRegion(HRegion region) throws IOException {
        RegionVisitor visitor = this.createRegionVisitor(this.desc);
        LOG.debug((Object)("Storing '" + region + "' region-info for snapshot."));
        Object regionData = visitor.regionOpen(region.getRegionInfo());
        this.monitor.rethrowException();
        LOG.debug((Object)"Creating references for hfiles");
        for (Store store : region.getStores()) {
            Object familyData = visitor.familyOpen(regionData, store.getFamily().getName());
            this.monitor.rethrowException();
            ArrayList<StoreFile> storeFiles = new ArrayList<StoreFile>(store.getStorefiles());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding snapshot references for " + storeFiles + " hfiles"));
            }
            int sz = storeFiles.size();
            for (int i = 0; i < sz; ++i) {
                StoreFile storeFile = (StoreFile)storeFiles.get(i);
                this.monitor.rethrowException();
                LOG.debug((Object)("Adding reference for file (" + (i + 1) + "/" + sz + "): " + storeFile.getPath()));
                visitor.storeFile(regionData, familyData, storeFile.getFileInfo());
            }
            visitor.familyClose(regionData, familyData);
        }
        visitor.regionClose(regionData);
    }

    public void addRegion(Path tableDir, HRegionInfo regionInfo) throws IOException {
        RegionVisitor visitor = this.createRegionVisitor(this.desc);
        HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(this.conf, this.fs, tableDir, regionInfo, true);
        this.monitor.rethrowException();
        LOG.debug((Object)"Storing region-info for snapshot.");
        Object regionData = visitor.regionOpen(regionInfo);
        this.monitor.rethrowException();
        LOG.debug((Object)"Creating references for hfiles");
        Collection<String> familyNames = regionFs.getFamilies();
        if (familyNames != null) {
            for (String familyName : familyNames) {
                Object familyData = visitor.familyOpen(regionData, Bytes.toBytes(familyName));
                this.monitor.rethrowException();
                Collection<StoreFileInfo> storeFiles = regionFs.getStoreFiles(familyName);
                if (storeFiles == null) {
                    LOG.debug((Object)("No files under family: " + familyName));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding snapshot references for " + storeFiles + " hfiles"));
                }
                int i = 0;
                int sz = storeFiles.size();
                for (StoreFileInfo storeFile : storeFiles) {
                    this.monitor.rethrowException();
                    LOG.debug((Object)("Adding reference for file (" + ++i + "/" + sz + "): " + storeFile.getPath()));
                    visitor.storeFile(regionData, familyData, storeFile);
                }
                visitor.familyClose(regionData, familyData);
            }
        }
        visitor.regionClose(regionData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        switch (SnapshotManifest.getSnapshotFormat(this.desc)) {
            case 0: {
                this.htd = FSTableDescriptors.getTableDescriptorFromFs(this.fs, this.workingDir);
                ThreadPoolExecutor tpool = this.createExecutor("SnapshotManifestLoader");
                try {
                    this.regionManifests = SnapshotManifestV1.loadRegionManifests(this.conf, tpool, this.fs, this.workingDir, this.desc);
                    break;
                }
                finally {
                    tpool.shutdown();
                }
            }
            case 2: {
                List<SnapshotProtos.SnapshotRegionManifest> v2Regions;
                List<SnapshotProtos.SnapshotRegionManifest> v1Regions;
                SnapshotProtos.SnapshotDataManifest dataManifest = this.readDataManifest();
                if (dataManifest != null) {
                    this.htd = HTableDescriptor.convert(dataManifest.getTableSchema());
                    this.regionManifests = dataManifest.getRegionManifestsList();
                    break;
                }
                ThreadPoolExecutor tpool = this.createExecutor("SnapshotManifestLoader");
                try {
                    v1Regions = SnapshotManifestV1.loadRegionManifests(this.conf, tpool, this.fs, this.workingDir, this.desc);
                    v2Regions = SnapshotManifestV2.loadRegionManifests(this.conf, tpool, this.fs, this.workingDir, this.desc);
                }
                finally {
                    tpool.shutdown();
                }
                if (v1Regions != null && v2Regions != null) {
                    this.regionManifests = new ArrayList<SnapshotProtos.SnapshotRegionManifest>(v1Regions.size() + v2Regions.size());
                    this.regionManifests.addAll(v1Regions);
                    this.regionManifests.addAll(v2Regions);
                    break;
                }
                if (v1Regions != null) {
                    this.regionManifests = v1Regions;
                    break;
                }
                this.regionManifests = v2Regions;
                break;
            }
            default: {
                throw new CorruptedSnapshotException("Invalid Snapshot version: " + this.desc.getVersion(), this.desc);
            }
        }
    }

    public Path getSnapshotDir() {
        return this.workingDir;
    }

    public HBaseProtos.SnapshotDescription getSnapshotDescription() {
        return this.desc;
    }

    public HTableDescriptor getTableDescriptor() {
        return this.htd;
    }

    public List<SnapshotProtos.SnapshotRegionManifest> getRegionManifests() {
        return this.regionManifests;
    }

    public Map<String, SnapshotProtos.SnapshotRegionManifest> getRegionManifestsMap() {
        if (this.regionManifests == null || this.regionManifests.size() == 0) {
            return null;
        }
        HashMap<String, SnapshotProtos.SnapshotRegionManifest> regionsMap = new HashMap<String, SnapshotProtos.SnapshotRegionManifest>(this.regionManifests.size());
        for (SnapshotProtos.SnapshotRegionManifest manifest : this.regionManifests) {
            String regionName = SnapshotManifest.getRegionNameFromManifest(manifest);
            regionsMap.put(regionName, manifest);
        }
        return regionsMap;
    }

    public void consolidate() throws IOException {
        if (SnapshotManifest.getSnapshotFormat(this.desc) == 0) {
            Path rootDir = FSUtils.getRootDir(this.conf);
            LOG.info((Object)"Using old Snapshot Format");
            new FSTableDescriptors(this.conf, this.fs, rootDir).createTableDescriptorForTableDirectory(this.workingDir, this.htd, false);
        } else {
            LOG.debug((Object)"Convert to Single Snapshot Manifest");
            this.convertToV2SingleManifest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToV2SingleManifest() throws IOException {
        List<SnapshotProtos.SnapshotRegionManifest> v2Regions;
        List<SnapshotProtos.SnapshotRegionManifest> v1Regions;
        ThreadPoolExecutor tpool = this.createExecutor("SnapshotManifestLoader");
        try {
            v1Regions = SnapshotManifestV1.loadRegionManifests(this.conf, tpool, this.fs, this.workingDir, this.desc);
            v2Regions = SnapshotManifestV2.loadRegionManifests(this.conf, tpool, this.fs, this.workingDir, this.desc);
        }
        finally {
            tpool.shutdown();
        }
        SnapshotProtos.SnapshotDataManifest.Builder dataManifestBuilder = SnapshotProtos.SnapshotDataManifest.newBuilder();
        dataManifestBuilder.setTableSchema(this.htd.convert());
        if (v1Regions != null && v1Regions.size() > 0) {
            dataManifestBuilder.addAllRegionManifests(v1Regions);
        }
        if (v2Regions != null && v2Regions.size() > 0) {
            dataManifestBuilder.addAllRegionManifests(v2Regions);
        }
        SnapshotProtos.SnapshotDataManifest dataManifest = dataManifestBuilder.build();
        this.writeDataManifest(dataManifest);
        this.regionManifests = dataManifest.getRegionManifestsList();
        if (v1Regions != null && v1Regions.size() > 0) {
            for (SnapshotProtos.SnapshotRegionManifest regionManifest : v1Regions) {
                SnapshotManifestV1.deleteRegionManifest(this.fs, this.workingDir, regionManifest);
            }
        }
        if (v2Regions != null && v2Regions.size() > 0) {
            for (SnapshotProtos.SnapshotRegionManifest regionManifest : v2Regions) {
                SnapshotManifestV2.deleteRegionManifest(this.fs, this.workingDir, regionManifest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataManifest(SnapshotProtos.SnapshotDataManifest manifest) throws IOException {
        try (FSDataOutputStream stream = this.fs.create(new Path(this.workingDir, DATA_MANIFEST_NAME));){
            manifest.writeTo(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SnapshotProtos.SnapshotDataManifest readDataManifest() throws IOException {
        try (FilterInputStream in = null;){
            in = this.fs.open(new Path(this.workingDir, DATA_MANIFEST_NAME));
            CodedInputStream cin = CodedInputStream.newInstance(in);
            cin.setSizeLimit(this.manifestSizeLimit);
            SnapshotProtos.SnapshotDataManifest snapshotDataManifest = SnapshotProtos.SnapshotDataManifest.parseFrom(cin);
            return snapshotDataManifest;
        }
    }

    private ThreadPoolExecutor createExecutor(String name) {
        return SnapshotManifest.createExecutor(this.conf, name);
    }

    public static ThreadPoolExecutor createExecutor(Configuration conf, String name) {
        int maxThreads = conf.getInt("hbase.snapshot.thread.pool.max", 8);
        return Threads.getBoundedCachedThreadPool(maxThreads, 30L, TimeUnit.SECONDS, Threads.getNamedThreadFactory(name));
    }

    static String getRegionNameFromManifest(SnapshotProtos.SnapshotRegionManifest manifest) {
        byte[] regionName = HRegionInfo.createRegionName(ProtobufUtil.toTableName(manifest.getRegionInfo().getTableName()), manifest.getRegionInfo().getStartKey().toByteArray(), manifest.getRegionInfo().getRegionId(), true);
        return HRegionInfo.encodeRegionName(regionName);
    }

    private static int getSnapshotFormat(HBaseProtos.SnapshotDescription desc) {
        return desc.hasVersion() ? desc.getVersion() : 0;
    }

    static interface RegionVisitor<TRegion, TFamily> {
        public TRegion regionOpen(HRegionInfo var1) throws IOException;

        public void regionClose(TRegion var1) throws IOException;

        public TFamily familyOpen(TRegion var1, byte[] var2) throws IOException;

        public void familyClose(TRegion var1, TFamily var2) throws IOException;

        public void storeFile(TRegion var1, TFamily var2, StoreFileInfo var3) throws IOException;
    }
}

