/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hdfs.protocol.AclException;

@InterfaceAudience.Private
final class NNConf {
    private final boolean aclsEnabled;
    private final boolean xattrsEnabled;
    final int xattrMaxSize;

    public NNConf(Configuration conf) {
        this.aclsEnabled = conf.getBoolean("dfs.namenode.acls.enabled", false);
        LogFactory.getLog(NNConf.class).info((Object)("ACLs enabled? " + this.aclsEnabled));
        this.xattrsEnabled = conf.getBoolean("dfs.namenode.xattrs.enabled", true);
        LogFactory.getLog(NNConf.class).info((Object)("XAttrs enabled? " + this.xattrsEnabled));
        this.xattrMaxSize = conf.getInt("dfs.namenode.fs-limits.max-xattr-size", 16384);
        Preconditions.checkArgument(this.xattrMaxSize >= 0, "Cannot set a negative value for the maximum size of an xattr (%s).", "dfs.namenode.fs-limits.max-xattr-size");
        String unlimited = this.xattrMaxSize == 0 ? " (unlimited)" : "";
        LogFactory.getLog(NNConf.class).info((Object)("Maximum size of an xattr: " + this.xattrMaxSize + unlimited));
    }

    public void checkAclsConfigFlag() throws AclException {
        if (!this.aclsEnabled) {
            throw new AclException(String.format("The ACL operation has been rejected.  Support for ACLs has been disabled by setting %s to false.", "dfs.namenode.acls.enabled"));
        }
    }

    public void checkXAttrsConfigFlag() throws IOException {
        if (!this.xattrsEnabled) {
            throw new IOException(String.format("The XAttr operation has been rejected.  Support for XAttrs has been disabled by setting %s to false.", "dfs.namenode.xattrs.enabled"));
        }
    }
}

