/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.OptionBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.ParseException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.PosixParser;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionCalculator;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Private
public class OfflineImageViewerPB {
    public static final Log LOG = LogFactory.getLog(OfflineImageViewerPB.class);
    private static final String usage = "Usage: bin/hdfs oiv [OPTIONS] -i INPUTFILE -o OUTPUTFILE\nOffline Image Viewer\nView a Hadoop fsimage INPUTFILE using the specified PROCESSOR,\nsaving the results in OUTPUTFILE.\n\nThe oiv utility will attempt to parse correctly formed image files\nand will abort fail with mal-formed image files.\n\nThe tool works offline and does not require a running cluster in\norder to process an image file.\n\nThe following image processors are available:\n  * XML: This processor creates an XML document with all elements of\n    the fsimage enumerated, suitable for further analysis by XML\n    tools.\n  * FileDistribution: This processor analyzes the file size\n    distribution in the image.\n    -maxSize specifies the range [0, maxSize] of file sizes to be\n     analyzed (128GB by default).\n    -step defines the granularity of the distribution. (2MB by default)\n  * Web: Run a viewer to expose read-only WebHDFS API.\n    -addr specifies the address to listen. (localhost:5978 by default)\n\nRequired command line arguments:\n-i,--inputFile <arg>   FSImage file to process.\n\nOptional command line arguments:\n-o,--outputFile <arg>  Name of output file. If the specified\n                       file exists, it will be overwritten.\n                       (output to stdout by default)\n-p,--processor <arg>   Select which type of processor to apply\n                       against image file. (XML|FileDistribution|Web)\n                       (Web by default)\n-h,--help              Display usage information and exit\n";

    private static Options buildOptions() {
        Options options = new Options();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt("inputFile");
        options.addOption(OptionBuilder.create("i"));
        options.addOption("o", "outputFile", true, "");
        options.addOption("p", "processor", true, "");
        options.addOption("h", "help", false, "");
        options.addOption("maxSize", true, "");
        options.addOption("step", true, "");
        options.addOption("addr", true, "");
        return options;
    }

    public static void main(String[] args) throws IOException {
        int status = OfflineImageViewerPB.run(args);
        System.exit(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static int run(String[] args) throws IOException {
        int addr2222222222;
        CommandLine cmd;
        Options options = OfflineImageViewerPB.buildOptions();
        if (args.length == 0) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("Error parsing command-line options: ");
            OfflineImageViewerPB.printUsage();
            return -1;
        }
        if (cmd.hasOption("h")) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        String inputFile = cmd.getOptionValue("i");
        String processor = cmd.getOptionValue("p", "Web");
        String outputFile = cmd.getOptionValue("o", "-");
        PrintWriter out = outputFile.equals("-") ? new PrintWriter(System.out) : new PrintWriter(new File(outputFile));
        Configuration conf = new Configuration();
        try {
            if (processor.equals("FileDistribution")) {
                long maxSize = Long.parseLong(cmd.getOptionValue("maxSize", "0"));
                int step = Integer.parseInt(cmd.getOptionValue("step", "0"));
                new FileDistributionCalculator(conf, maxSize, step, out).visit(new RandomAccessFile(inputFile, "r"));
            } else if (processor.equals("XML")) {
                new PBImageXmlWriter(conf, out).visit(new RandomAccessFile(inputFile, "r"));
            } else if (processor.equals("Web")) {
                String addr2222222222 = cmd.getOptionValue("addr", "localhost:5978");
                new WebImageViewer(NetUtils.createSocketAddr(addr2222222222)).initServerAndWait(inputFile);
            }
            addr2222222222 = 0;
        }
        catch (EOFException e) {
            System.err.println("Input file ended unexpectedly. Exiting");
            IOUtils.cleanup(null, out);
        }
        catch (IOException e2) {
            System.err.println("Encountered exception.  Exiting: " + e2.getMessage());
            {
                catch (Throwable throwable) {
                    IOUtils.cleanup(null, out);
                    throw throwable;
                }
            }
            IOUtils.cleanup(null, out);
        }
        IOUtils.cleanup(null, out);
        return addr2222222222;
        return -1;
    }

    private static void printUsage() {
        System.out.println(usage);
    }
}

