/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsExecutorImpl;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.util.MetricQuantile;
import org.apache.hadoop.metrics2.util.MetricSampleQuantiles;

@InterfaceAudience.Private
public class MetricMutableQuantiles
extends MutableMetric
implements MetricHistogram {
    static final MetricQuantile[] quantiles = new MetricQuantile[]{new MetricQuantile(0.5, 0.05), new MetricQuantile(0.75, 0.025), new MetricQuantile(0.9, 0.01), new MetricQuantile(0.95, 0.005), new MetricQuantile(0.99, 0.001)};
    private final MetricsInfo numInfo;
    private final MetricsInfo[] quantileInfos;
    private final int interval;
    private MetricSampleQuantiles estimator;
    private long previousCount = 0L;
    private MetricsExecutor executor;
    @VisibleForTesting
    protected Map<MetricQuantile, Long> previousSnapshot = null;

    public MetricMutableQuantiles(String name, String description, String sampleName, String valueName, int interval) {
        String ucName = StringUtils.capitalize(name);
        String usName = StringUtils.capitalize(sampleName);
        String uvName = StringUtils.capitalize(valueName);
        String desc = StringUtils.uncapitalize(description);
        String lsName = StringUtils.uncapitalize(sampleName);
        String lvName = StringUtils.uncapitalize(valueName);
        this.numInfo = Interns.info(ucName + "Num" + usName, String.format("Number of %s for %s with %ds interval", lsName, desc, interval));
        this.quantileInfos = new MetricsInfo[quantiles.length];
        String nameTemplate = "%s%dthPercentile%dsInterval%s";
        String descTemplate = "%d percentile %s with %d second interval for %s";
        for (int i = 0; i < quantiles.length; ++i) {
            int percentile = (int)(100.0 * MetricMutableQuantiles.quantiles[i].quantile);
            this.quantileInfos[i] = Interns.info(String.format(nameTemplate, ucName, percentile, interval, uvName), String.format(descTemplate, percentile, lvName, interval, desc));
        }
        this.estimator = new MetricSampleQuantiles(quantiles);
        this.executor = new MetricsExecutorImpl();
        this.interval = interval;
        this.executor.getExecutor().scheduleAtFixedRate(new RolloverSample(this), interval, interval, TimeUnit.SECONDS);
    }

    @Override
    public synchronized void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addGauge(this.numInfo, this.previousCount);
            for (int i = 0; i < quantiles.length; ++i) {
                long newValue = 0L;
                if (this.previousSnapshot != null) {
                    newValue = this.previousSnapshot.get(quantiles[i]);
                }
                builder.addGauge(this.quantileInfos[i], newValue);
            }
            if (this.changed()) {
                this.clearChanged();
            }
        }
    }

    @Override
    public synchronized void add(long value) {
        this.estimator.insert(value);
    }

    public int getInterval() {
        return this.interval;
    }

    private static class RolloverSample
    implements Runnable {
        MetricMutableQuantiles parent;

        public RolloverSample(MetricMutableQuantiles parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MetricMutableQuantiles metricMutableQuantiles = this.parent;
            synchronized (metricMutableQuantiles) {
                try {
                    this.parent.previousCount = this.parent.estimator.getCount();
                    this.parent.previousSnapshot = this.parent.estimator.snapshot();
                }
                catch (IOException e) {
                    this.parent.previousCount = 0L;
                    this.parent.previousSnapshot = null;
                }
                this.parent.estimator.clear();
            }
            this.parent.setChanged();
        }
    }
}

