/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.security;

import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.security.MasterKeyData;

public class BaseNMTokenSecretManager
extends SecretManager<NMTokenIdentifier> {
    private static Log LOG = LogFactory.getLog(BaseNMTokenSecretManager.class);
    private int serialNo = new SecureRandom().nextInt();
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    protected MasterKeyData currentMasterKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MasterKeyData createNewMasterKey() {
        this.writeLock.lock();
        try {
            MasterKeyData masterKeyData = new MasterKeyData(this.serialNo++, this.generateSecret());
            return masterKeyData;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public MasterKey getCurrentKey() {
        this.readLock.lock();
        try {
            MasterKey masterKey = this.currentMasterKey.getMasterKey();
            return masterKey;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] createPassword(NMTokenIdentifier identifier) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating password for " + identifier.getApplicationAttemptId() + " for user " + identifier.getApplicationSubmitter() + " to run on NM " + identifier.getNodeId()));
        }
        this.readLock.lock();
        try {
            byte[] byArray = BaseNMTokenSecretManager.createPassword(identifier.getBytes(), this.currentMasterKey.getSecretKey());
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] retrievePassword(NMTokenIdentifier identifier) throws SecretManager.InvalidToken {
        this.readLock.lock();
        try {
            byte[] byArray = this.retrivePasswordInternal(identifier, this.currentMasterKey);
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected byte[] retrivePasswordInternal(NMTokenIdentifier identifier, MasterKeyData masterKey) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating password for " + identifier.getApplicationAttemptId() + " for user " + identifier.getApplicationSubmitter() + " to run on NM " + identifier.getNodeId()));
        }
        return BaseNMTokenSecretManager.createPassword(identifier.getBytes(), masterKey.getSecretKey());
    }

    @Override
    public NMTokenIdentifier createIdentifier() {
        return new NMTokenIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token createNMToken(ApplicationAttemptId applicationAttemptId, NodeId nodeId, String applicationSubmitter) {
        byte[] password;
        NMTokenIdentifier identifier;
        this.readLock.lock();
        try {
            identifier = new NMTokenIdentifier(applicationAttemptId, nodeId, applicationSubmitter, this.currentMasterKey.getMasterKey().getKeyId());
            password = this.createPassword(identifier);
        }
        finally {
            this.readLock.unlock();
        }
        return BaseNMTokenSecretManager.newInstance(password, identifier);
    }

    public static Token newInstance(byte[] password, NMTokenIdentifier identifier) {
        NodeId nodeId = identifier.getNodeId();
        InetSocketAddress addr = NetUtils.createSocketAddrForHost(nodeId.getHost(), nodeId.getPort());
        Token nmToken = Token.newInstance(identifier.getBytes(), NMTokenIdentifier.KIND.toString(), password, SecurityUtil.buildTokenService(addr).toString());
        return nmToken;
    }
}

