/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.accesscontrol.policyloader;

import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.XMLConfiguration;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.reference.accesscontrol.DynaBeanACRParameter;
import org.owasp.esapi.reference.accesscontrol.policyloader.ACRParameterLoader;
import org.owasp.esapi.reference.accesscontrol.policyloader.ACRParameterLoaderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynaBeanACRParameterLoader
implements ACRParameterLoader<DynaBeanACRParameter> {
    Logger logger = ESAPI.getLogger(this.getClass());

    @Override
    public DynaBeanACRParameter getParameters(XMLConfiguration config, int currentRule) throws Exception {
        DynaBeanACRParameter policyParameter = new DynaBeanACRParameter();
        int numberOfParameters = config.getList("AccessControlRules.AccessControlRule(" + currentRule + ").Parameters.Parameter[@name]").size();
        for (int currentParameter = 0; currentParameter < numberOfParameters; ++currentParameter) {
            String parameterName = config.getString("AccessControlRules.AccessControlRule(" + currentRule + ").Parameters.Parameter(" + currentParameter + ")[@name]");
            String parameterType = config.getString("AccessControlRules.AccessControlRule(" + currentRule + ").Parameters.Parameter(" + currentParameter + ")[@type]");
            Object parameterValue = ACRParameterLoaderHelper.getParameterValue(config, currentRule, currentParameter, parameterType);
            policyParameter.set(parameterName, parameterValue);
        }
        policyParameter.lock();
        this.logger.info(Logger.SECURITY_SUCCESS, "Loaded " + numberOfParameters + " parameters: " + policyParameter.toString());
        return policyParameter;
    }
}

