/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.log4j.xml.DOMConfigurator;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.waf.ConfigurationException;
import org.owasp.esapi.waf.actions.Action;
import org.owasp.esapi.waf.actions.BlockAction;
import org.owasp.esapi.waf.actions.DefaultAction;
import org.owasp.esapi.waf.actions.RedirectAction;
import org.owasp.esapi.waf.configuration.AppGuardianConfiguration;
import org.owasp.esapi.waf.configuration.ConfigurationParser;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletRequest;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import org.owasp.esapi.waf.rules.Rule;

public class ESAPIWebApplicationFirewallFilter
implements Filter {
    private AppGuardianConfiguration appGuardConfig;
    private static final String CONFIGURATION_FILE_PARAM = "configuration";
    private static final String LOGGING_FILE_PARAM = "log_settings";
    private static final String POLLING_TIME_PARAM = "polling_time";
    private static final int DEFAULT_POLLING_TIME = 30000;
    private String configurationFilename = null;
    private long pollingTime;
    private long lastConfigReadTime;
    private FilterConfig fc;
    private final Logger logger = ESAPI.getLogger(ESAPIWebApplicationFirewallFilter.class);

    public void setConfiguration(String policyFilePath, String webRootDir) throws FileNotFoundException {
        try {
            this.appGuardConfig = ConfigurationParser.readConfigurationFile(new FileInputStream(new File(policyFilePath)), webRootDir);
            this.lastConfigReadTime = System.currentTimeMillis();
            this.configurationFilename = policyFilePath;
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public AppGuardianConfiguration getConfiguration() {
        return this.appGuardConfig;
    }

    public void init(FilterConfig fc) throws ServletException {
        this.fc = fc;
        this.logger.debug(Logger.EVENT_SUCCESS, ">> Initializing WAF");
        String logSettingsFilename = fc.getInitParameter(LOGGING_FILE_PARAM);
        String realLogSettingsFilename = fc.getServletContext().getRealPath(logSettingsFilename);
        if (realLogSettingsFilename == null || !new File(realLogSettingsFilename).exists()) {
            throw new ServletException("[ESAPI WAF] Could not find log file at resolved path: " + realLogSettingsFilename);
        }
        this.configurationFilename = fc.getInitParameter(CONFIGURATION_FILE_PARAM);
        this.configurationFilename = fc.getServletContext().getRealPath(this.configurationFilename);
        if (this.configurationFilename == null || !new File(this.configurationFilename).exists()) {
            throw new ServletException("[ESAPI WAF] Could not find configuration file at resolved path: " + this.configurationFilename);
        }
        String sPollingTime = fc.getInitParameter(POLLING_TIME_PARAM);
        this.pollingTime = sPollingTime != null ? Long.parseLong(sPollingTime) : 30000L;
        try {
            String webRootDir = fc.getServletContext().getRealPath("/");
            this.appGuardConfig = ConfigurationParser.readConfigurationFile(new FileInputStream(this.configurationFilename), webRootDir);
            DOMConfigurator.configure((String)realLogSettingsFilename);
            this.lastConfigReadTime = System.currentTimeMillis();
        }
        catch (FileNotFoundException e) {
            throw new ServletException(e);
        }
        catch (ConfigurationException e) {
            throw new ServletException(e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        int i;
        Action action;
        Rule rule;
        File f;
        long lastModified;
        if (System.currentTimeMillis() - this.lastConfigReadTime > this.pollingTime && (lastModified = (f = new File(this.configurationFilename)).lastModified()) > this.lastConfigReadTime) {
            this.logger.debug(Logger.EVENT_SUCCESS, ">> Re-reading WAF policy");
            this.init(this.fc);
        }
        this.logger.debug(Logger.EVENT_SUCCESS, ">>In WAF doFilter");
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        InterceptingHTTPServletRequest request = null;
        InterceptingHTTPServletResponse response = null;
        if (this.appGuardConfig.getCookieRules().size() + this.appGuardConfig.getBeforeResponseRules().size() > 0) {
            response = new InterceptingHTTPServletResponse(httpResponse, true, this.appGuardConfig.getCookieRules());
        }
        this.logger.debug(Logger.EVENT_SUCCESS, ">> Starting stage 1");
        List<Rule> rules = this.appGuardConfig.getBeforeBodyRules();
        for (int i2 = 0; i2 < rules.size(); ++i2) {
            rule = rules.get(i2);
            this.logger.debug(Logger.EVENT_SUCCESS, "  Applying BEFORE rule:  " + rule.getClass().getName());
            action = rule.check(httpRequest, response, httpResponse);
            if (!action.isActionNecessary()) continue;
            if (action instanceof BlockAction) {
                if (response != null) {
                    response.setStatus(this.appGuardConfig.getDefaultResponseCode());
                } else {
                    httpResponse.setStatus(this.appGuardConfig.getDefaultResponseCode());
                }
                return;
            }
            if (action instanceof RedirectAction) {
                this.sendRedirect(response, httpResponse, ((RedirectAction)action).getRedirectURL());
                return;
            }
            if (!(action instanceof DefaultAction)) continue;
            switch (AppGuardianConfiguration.DEFAULT_FAIL_ACTION) {
                case 2: {
                    if (response != null) {
                        response.setStatus(this.appGuardConfig.getDefaultResponseCode());
                    } else {
                        httpResponse.setStatus(this.appGuardConfig.getDefaultResponseCode());
                    }
                    return;
                }
                case 1: {
                    this.sendRedirect(response, httpResponse);
                    return;
                }
            }
        }
        try {
            request = new InterceptingHTTPServletRequest((HttpServletRequest)servletRequest);
        }
        catch (FileUploadException fue) {
            this.logger.error(Logger.EVENT_SUCCESS, "Error Wrapping Request", fue);
        }
        this.logger.debug(Logger.EVENT_SUCCESS, ">> Starting Stage 2");
        rules = this.appGuardConfig.getAfterBodyRules();
        for (i = 0; i < rules.size(); ++i) {
            rule = rules.get(i);
            this.logger.debug(Logger.EVENT_SUCCESS, "  Applying BEFORE CHAIN rule:  " + rule.getClass().getName());
            action = rule.check(request, response, httpResponse);
            if (!action.isActionNecessary()) continue;
            if (action instanceof BlockAction) {
                if (response != null) {
                    response.setStatus(this.appGuardConfig.getDefaultResponseCode());
                } else {
                    httpResponse.setStatus(this.appGuardConfig.getDefaultResponseCode());
                }
                return;
            }
            if (action instanceof RedirectAction) {
                this.sendRedirect(response, httpResponse, ((RedirectAction)action).getRedirectURL());
                return;
            }
            if (!(action instanceof DefaultAction)) continue;
            switch (AppGuardianConfiguration.DEFAULT_FAIL_ACTION) {
                case 2: {
                    if (response != null) {
                        response.setStatus(this.appGuardConfig.getDefaultResponseCode());
                    } else {
                        httpResponse.setStatus(this.appGuardConfig.getDefaultResponseCode());
                    }
                    return;
                }
                case 1: {
                    this.sendRedirect(response, httpResponse);
                    return;
                }
            }
        }
        this.logger.debug(Logger.EVENT_SUCCESS, ">> Calling the FilterChain: " + chain);
        chain.doFilter(request, response != null ? response : httpResponse);
        this.logger.debug(Logger.EVENT_SUCCESS, ">> Starting Stage 3");
        rules = this.appGuardConfig.getBeforeResponseRules();
        for (i = 0; i < rules.size(); ++i) {
            rule = rules.get(i);
            this.logger.debug(Logger.EVENT_SUCCESS, "  Applying AFTER CHAIN rule:  " + rule.getClass().getName());
            action = rule.check(request, response, httpResponse);
            if (!action.isActionNecessary()) continue;
            if (action instanceof BlockAction) {
                if (response != null) {
                    response.setStatus(this.appGuardConfig.getDefaultResponseCode());
                } else {
                    httpResponse.setStatus(this.appGuardConfig.getDefaultResponseCode());
                }
                return;
            }
            if (action instanceof RedirectAction) {
                this.sendRedirect(response, httpResponse, ((RedirectAction)action).getRedirectURL());
                return;
            }
            if (!(action instanceof DefaultAction)) continue;
            switch (AppGuardianConfiguration.DEFAULT_FAIL_ACTION) {
                case 2: {
                    if (response != null) {
                        response.setStatus(this.appGuardConfig.getDefaultResponseCode());
                    } else {
                        httpResponse.setStatus(this.appGuardConfig.getDefaultResponseCode());
                    }
                    return;
                }
                case 1: {
                    this.sendRedirect(response, httpResponse);
                    return;
                }
            }
        }
        if (response != null) {
            this.logger.debug(Logger.EVENT_SUCCESS, ">>> committing reponse");
            response.commit();
        }
    }

    private void sendRedirect(InterceptingHTTPServletResponse response, HttpServletResponse httpResponse, String redirectURL) throws IOException {
        if (response != null) {
            response.reset();
            response.resetBuffer();
            response.sendRedirect(redirectURL);
            response.commit();
        } else {
            httpResponse.sendRedirect(redirectURL);
        }
    }

    public void destroy() {
    }

    private void sendRedirect(InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) throws IOException {
        if (response != null) {
            response.reset();
            response.resetBuffer();
            response.sendRedirect(this.appGuardConfig.getDefaultErrorPage());
        } else if (!httpResponse.isCommitted()) {
            httpResponse.sendRedirect(this.appGuardConfig.getDefaultErrorPage());
        }
    }
}

