/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf.rules;

import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.waf.actions.Action;
import org.owasp.esapi.waf.actions.DefaultAction;
import org.owasp.esapi.waf.actions.DoNothingAction;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletRequest;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import org.owasp.esapi.waf.rules.Rule;

public class GeneralAttackSignatureRule
extends Rule {
    private Pattern signature;

    public GeneralAttackSignatureRule(String id, Pattern signature) {
        this.signature = signature;
        this.setId(id);
    }

    public Action check(HttpServletRequest req, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        InterceptingHTTPServletRequest request = (InterceptingHTTPServletRequest)req;
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String param = (String)e.nextElement();
            if (!this.signature.matcher(request.getDictionaryParameter(param)).matches()) continue;
            this.log(request, "General attack signature detected in parameter '" + param + "' value '" + request.getDictionaryParameter(param) + "'");
            return new DefaultAction();
        }
        return new DoNothingAction();
    }
}

