/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf.rules;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.waf.actions.Action;
import org.owasp.esapi.waf.actions.DefaultAction;
import org.owasp.esapi.waf.actions.DoNothingAction;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletRequest;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import org.owasp.esapi.waf.rules.Rule;
import org.owasp.esapi.waf.rules.RuleUtil;

public class MustMatchRule
extends Rule {
    private static final String REQUEST_PARAMETERS = "request.parameters.";
    private static final String REQUEST_HEADERS = "request.headers.";
    private static final String REQUEST_URI = "request.uri";
    private static final String REQUEST_URL = "request.url";
    private static final String SESSION_ATTRIBUTES = "session.";
    private Pattern path;
    private String variable;
    private int operator;
    private String value;

    public MustMatchRule(String id, Pattern path, String variable, int operator, String value) {
        this.path = path;
        this.variable = variable;
        this.operator = operator;
        this.value = value;
        this.setId(id);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Action check(HttpServletRequest req, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        InterceptingHTTPServletRequest request;
        block37: {
            block41: {
                String target;
                block40: {
                    block38: {
                        block39: {
                            request = (InterceptingHTTPServletRequest)req;
                            String uri = request.getRequestURI();
                            if (!this.path.matcher(uri).matches()) {
                                return new DoNothingAction();
                            }
                            target = null;
                            if (!this.variable.startsWith(REQUEST_PARAMETERS)) break block38;
                            if (this.operator != 3) break block39;
                            target = this.variable.substring(REQUEST_PARAMETERS.length());
                            if (request.getParameter(target) != null) {
                                return new DoNothingAction();
                            }
                            break block37;
                        }
                        if (this.operator != 2 && (this.operator == 0 || this.operator == 1)) {
                            target = this.variable.substring(REQUEST_PARAMETERS.length());
                            if (target.contains("*") || target.contains("?")) {
                                target = target.replaceAll("*", ".*");
                                Pattern p = Pattern.compile(target);
                                Enumeration e = request.getParameterNames();
                                while (e.hasMoreElements()) {
                                    String s;
                                    String param = (String)e.nextElement();
                                    if (!p.matcher(param).matches() || RuleUtil.testValue(s = request.getParameter(param), this.value, this.operator)) continue;
                                    this.log(request, "MustMatch rule failed (operator=" + this.operator + "), value='" + this.value + "', input='" + s + "' parameter='" + param + "'");
                                    return new DefaultAction();
                                }
                                break block37;
                            } else {
                                String s = request.getParameter(target);
                                if (!RuleUtil.testValue(s, this.value, this.operator)) {
                                    this.log(request, "MustMatch rule failed (operator=" + this.operator + "), value='" + this.value + "', input='" + s + "', parameter='" + target + "'");
                                    return new DefaultAction();
                                }
                            }
                        }
                        break block37;
                    }
                    if (!this.variable.startsWith(REQUEST_HEADERS)) break block40;
                    if (this.operator == 3) {
                        target = this.variable.substring(REQUEST_HEADERS.length());
                        if (request.getHeader(target) != null) {
                            return new DoNothingAction();
                        }
                        break block37;
                    } else if (this.operator != 2 && (this.operator == 0 || this.operator == 1)) {
                        target = this.variable.substring(REQUEST_HEADERS.length());
                        if (target.contains("*") || target.contains("?")) {
                            String s;
                            String header;
                            target = target.replaceAll("*", ".*");
                            Pattern p = Pattern.compile(target);
                            Enumeration e = request.getHeaderNames();
                            do {
                                if (e.hasMoreElements()) continue;
                                return new DoNothingAction();
                            } while (!p.matcher(header = (String)e.nextElement()).matches() || RuleUtil.testValue(s = request.getHeader(header), this.value, this.operator));
                            this.log(request, "MustMatch rule failed (operator=" + this.operator + "), value='" + this.value + "', input='" + s + "', header='" + header + "'");
                            return new DefaultAction();
                        }
                        String s = request.getHeader(target);
                        if (s != null && RuleUtil.testValue(s, this.value, this.operator)) {
                            return new DoNothingAction();
                        }
                        this.log(request, "MustMatch rule failed (operator=" + this.operator + "), value='" + this.value + "', input='" + s + "', header='" + target + "'");
                        return new DefaultAction();
                    }
                    break block37;
                }
                if (!this.variable.startsWith(SESSION_ATTRIBUTES)) break block41;
                if (request.getSession(false) == null) {
                    return new DefaultAction();
                }
                target = this.variable.substring(SESSION_ATTRIBUTES.length() + 1);
                if (this.operator == 2) {
                    Object o = request.getSession(false).getAttribute(target);
                    if (o instanceof Collection) {
                        if (RuleUtil.isInList((Collection)o, this.value)) {
                            return new DoNothingAction();
                        }
                        this.log(request, "MustMatch rule failed - looking for value='" + this.value + "', in session Collection attribute '" + target + "']");
                        return new DefaultAction();
                    }
                    if (o instanceof Map) {
                        if (RuleUtil.isInList((Map)o, this.value)) {
                            return new DoNothingAction();
                        }
                        this.log(request, "MustMatch rule failed - looking for value='" + this.value + "', in session Map attribute '" + target + "']");
                        return new DefaultAction();
                    }
                    if (o instanceof Enumeration) {
                        if (RuleUtil.isInList((Enumeration)o, this.value)) {
                            return new DoNothingAction();
                        }
                        this.log(request, "MustMatch rule failed - looking for value='" + this.value + "', in session Enumeration attribute '" + target + "']");
                        return new DefaultAction();
                    }
                    break block37;
                } else {
                    if (this.operator == 3) {
                        Object o = request.getSession(false).getAttribute(target);
                        if (o != null) {
                            return new DoNothingAction();
                        }
                        this.log(request, "MustMatch rule failed - couldn't find required session attribute='" + target + "'");
                        return new DefaultAction();
                    }
                    if (this.operator == 0 || this.operator == 1) {
                        if (target.contains("*") || target.contains("?")) {
                            target = target.replaceAll("\\*", ".*");
                            Pattern p = Pattern.compile(target);
                            Enumeration e = request.getSession(false).getAttributeNames();
                            while (e.hasMoreElements()) {
                                String attr = (String)e.nextElement();
                                if (!p.matcher(attr).matches()) continue;
                                Object o = request.getSession(false).getAttribute(attr);
                                if (!RuleUtil.testValue((String)o, this.value, this.operator)) {
                                    this.log(request, "MustMatch rule failed (operator=" + this.operator + "), value='" + this.value + "', session attribute='" + attr + "', attribute value='" + (String)o + "'");
                                    return new DefaultAction();
                                }
                                return new DoNothingAction();
                            }
                            break block37;
                        } else {
                            Object o = request.getSession(false).getAttribute(target);
                            if (!RuleUtil.testValue((String)o, this.value, this.operator)) {
                                this.log(request, "MustMatch rule failed (operator=" + this.operator + "), value='" + this.value + "', session attribute='" + target + "', attribute value='" + (String)o + "'");
                                return new DefaultAction();
                            }
                            return new DoNothingAction();
                        }
                    }
                }
                break block37;
            }
            if (this.variable.equals(REQUEST_URI)) {
                if (this.operator == 0 || this.operator == 1) {
                    if (RuleUtil.testValue(request.getRequestURI(), this.value, this.operator)) {
                        return new DoNothingAction();
                    }
                    this.log(request, "MustMatch rule on request URI failed (operator=" + this.operator + "), requestURI='" + request.getRequestURI() + "', value='" + this.value + "'");
                    return new DefaultAction();
                }
            } else if (this.variable.equals(REQUEST_URL) && (this.operator == 0 || this.operator == 1)) {
                if (RuleUtil.testValue(request.getRequestURL().toString(), this.value, this.operator)) {
                    return new DoNothingAction();
                }
                this.log(request, "MustMatch rule on request URL failed (operator=" + this.operator + "), requestURL='" + request.getRequestURL() + "', value='" + this.value + "'");
                return new DefaultAction();
            }
        }
        this.log(request, "MustMatch rule failed close on URL '" + request.getRequestURL() + "'");
        return new DefaultAction();
    }
}

