/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf.rules;

import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.waf.actions.Action;
import org.owasp.esapi.waf.actions.DefaultAction;
import org.owasp.esapi.waf.actions.DoNothingAction;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletRequest;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import org.owasp.esapi.waf.rules.Rule;

public class SimpleVirtualPatchRule
extends Rule {
    private static final String REQUEST_PARAMETERS = "request.parameters.";
    private static final String REQUEST_HEADERS = "request.headers.";
    private Pattern path;
    private String variable;
    private Pattern valid;
    private String message;

    public SimpleVirtualPatchRule(String id, Pattern path, String variable, Pattern valid, String message) {
        this.setId(id);
        this.path = path;
        this.variable = variable;
        this.valid = valid;
        this.message = message;
    }

    public Action check(HttpServletRequest req, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        InterceptingHTTPServletRequest request = (InterceptingHTTPServletRequest)req;
        String uri = request.getRequestURI();
        if (!this.path.matcher(uri).matches()) {
            return new DoNothingAction();
        }
        String target = null;
        Enumeration en = null;
        boolean parameter = true;
        if (this.variable.startsWith(REQUEST_PARAMETERS)) {
            target = this.variable.substring(REQUEST_PARAMETERS.length());
            en = request.getParameterNames();
        } else if (this.variable.startsWith(REQUEST_HEADERS)) {
            parameter = false;
            target = this.variable.substring(REQUEST_HEADERS.length());
            en = request.getHeaderNames();
        } else {
            this.log(request, "Patch failed (improperly configured variable '" + this.variable + "')");
            return new DefaultAction();
        }
        if (target.contains("*") || target.contains("?")) {
            target = target.replaceAll("\\*", ".*");
            Pattern p = Pattern.compile(target);
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                String value = null;
                if (!p.matcher(s).matches() || (value = parameter ? request.getDictionaryParameter(s) : request.getHeader(s)) == null || this.valid.matcher(value).matches()) continue;
                this.log(request, "Virtual patch tripped on variable '" + this.variable + "' (specifically '" + s + "'). User input was '" + value + "' and legal pattern was '" + this.valid.pattern() + "': " + this.message);
                return new DefaultAction();
            }
            return new DoNothingAction();
        }
        if (parameter) {
            String value = request.getDictionaryParameter(target);
            if (value == null || this.valid.matcher(value).matches()) {
                return new DoNothingAction();
            }
            this.log(request, "Virtual patch tripped on parameter '" + target + "'. User input was '" + value + "' and legal pattern was '" + this.valid.pattern() + "': " + this.message);
            return new DefaultAction();
        }
        String value = request.getHeader(target);
        if (value == null || this.valid.matcher(value).matches()) {
            return new DoNothingAction();
        }
        this.log(request, "Virtual patch tripped on header '" + target + "'. User input was '" + value + "' and legal pattern was '" + this.valid.pattern() + "': " + this.message);
        return new DefaultAction();
    }
}

