/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.css;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.batik.css.parser.ParseException;
import org.apache.batik.css.parser.Parser;
import org.apache.hadoop.hbase.shaded.org.apache.commons.httpclient.HttpClient;
import org.apache.hadoop.hbase.shaded.org.apache.commons.httpclient.HttpContentTooLargeException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.httpclient.methods.GetMethod;
import org.apache.hadoop.hbase.shaded.org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.owasp.validator.css.CssHandler;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.util.ErrorMessageUtil;
import org.owasp.validator.html.util.HTMLEntityEncoder;
import org.w3c.css.sac.InputSource;

public class CssScanner {
    private static final int DEFAULT_TIMEOUT = 1000;
    private static final String CDATA = "^\\s*<!\\[CDATA\\[(.*)\\]\\]>\\s*$";
    private final Parser parser = new Parser();
    private final Policy policy;
    private final ResourceBundle messages;

    public CssScanner(Policy policy, ResourceBundle messages) {
        this.policy = policy;
        this.messages = messages;
    }

    public CleanResults scanStyleSheet(String taintedCss, int sizeLimit) throws ScanException {
        Date startOfScan = new Date();
        ArrayList errorMessages = new ArrayList();
        Pattern p = Pattern.compile(CDATA, 32);
        Matcher m = p.matcher(taintedCss);
        boolean isCdata = m.matches();
        if (isCdata) {
            taintedCss = m.group(1);
        }
        LinkedList stylesheets = new LinkedList();
        CssHandler handler = new CssHandler(this.policy, stylesheets, errorMessages, this.messages);
        this.parser.setDocumentHandler(handler);
        try {
            this.parser.parseStyleSheet(new InputSource(new StringReader(taintedCss)));
        }
        catch (IOException ioe) {
            throw new ScanException(ioe);
        }
        catch (ParseException pe) {
            throw new ScanException(pe);
        }
        this.parseImportedStylesheets(stylesheets, handler, errorMessages, sizeLimit);
        String cleaned = handler.getCleanStylesheet();
        if (isCdata && !"true".equals(this.policy.getDirective("useXHTML"))) {
            cleaned = "<![CDATA[[" + cleaned + "]]>";
        }
        return new CleanResults(startOfScan, new Date(), cleaned, null, errorMessages);
    }

    public CleanResults scanInlineStyle(String taintedCss, String tagName, int sizeLimit) throws ScanException {
        Date startOfScan = new Date();
        ArrayList errorMessages = new ArrayList();
        LinkedList stylesheets = new LinkedList();
        CssHandler handler = new CssHandler(this.policy, stylesheets, errorMessages, tagName, this.messages);
        this.parser.setDocumentHandler(handler);
        try {
            this.parser.parseStyleDeclaration(taintedCss);
        }
        catch (IOException ioe) {
            throw new ScanException(ioe);
        }
        this.parseImportedStylesheets(stylesheets, handler, errorMessages, sizeLimit);
        return new CleanResults(startOfScan, new Date(), handler.getCleanStylesheet(), null, errorMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseImportedStylesheets(LinkedList stylesheets, CssHandler handler, ArrayList errorMessages, int sizeLimit) throws ScanException {
        int importedStylesheets = 0;
        if (!stylesheets.isEmpty()) {
            HttpClient httpClient = new HttpClient();
            HttpConnectionManagerParams params = httpClient.getHttpConnectionManager().getParams();
            int timeout = 1000;
            try {
                timeout = Integer.parseInt(this.policy.getDirective("connectionTimeout"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            params.setConnectionTimeout(timeout);
            params.setSoTimeout(timeout);
            httpClient.getHttpConnectionManager().setParams(params);
            int allowedImports = 1;
            try {
                allowedImports = Integer.parseInt(this.policy.getDirective("maxStyleSheetImports"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            while (!stylesheets.isEmpty()) {
                URI stylesheetUri = (URI)stylesheets.removeFirst();
                if (++importedStylesheets > allowedImports) {
                    errorMessages.add(ErrorMessageUtil.getMessage(this.messages, "error.css.import.exceeded", new Object[]{HTMLEntityEncoder.htmlEntityEncode(stylesheetUri.toString()), String.valueOf(allowedImports)}));
                    continue;
                }
                GetMethod stylesheetRequest = new GetMethod(stylesheetUri.toString());
                byte[] stylesheet = null;
                try {
                    httpClient.executeMethod(stylesheetRequest);
                    stylesheet = stylesheetRequest.getResponseBody(sizeLimit);
                }
                catch (HttpContentTooLargeException hctle) {
                    errorMessages.add(ErrorMessageUtil.getMessage(this.messages, "error.css.import.toolarge", new Object[]{HTMLEntityEncoder.htmlEntityEncode(stylesheetUri.toString()), String.valueOf(this.policy.getMaxInputSize())}));
                }
                catch (IOException ioe) {
                    errorMessages.add(ErrorMessageUtil.getMessage(this.messages, "error.css.import.failure", new Object[]{HTMLEntityEncoder.htmlEntityEncode(stylesheetUri.toString())}));
                }
                finally {
                    stylesheetRequest.releaseConnection();
                }
                if (stylesheet == null) continue;
                sizeLimit -= stylesheet.length;
                try {
                    InputSource nextStyleSheet = new InputSource(new InputStreamReader(new ByteArrayInputStream(stylesheet)));
                    this.parser.parseStyleSheet(nextStyleSheet);
                }
                catch (IOException ioe) {
                    throw new ScanException(ioe);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Policy policy = Policy.getInstance("resources/antisamy-1.2.xml");
        CssScanner scanner = new CssScanner(policy, ResourceBundle.getBundle("AntiSamy", Locale.getDefault()));
        CleanResults results = null;
        results = scanner.scanStyleSheet("@import url(http://www.owasp.org/skins/monobook/main.css);@import url(http://www.w3schools.com/stdtheme.css);@import url(http://www.google.com/ig/f/t1wcX5O39cc/ig.css); ", Integer.MAX_VALUE);
        System.out.println("Cleaned result:");
        System.out.println(results.getCleanHTML());
        System.out.println("--");
        System.out.println("Error messages");
        System.out.println(results.getErrorMessages());
    }
}

