/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.guice.spi.container;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCInstantiatedComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCManagedComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCProxiedComponentProvider;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.hadoop.hbase.shaded.com.google.inject.ConfigurationException;
import org.apache.hadoop.hbase.shaded.com.google.inject.Injector;
import org.apache.hadoop.hbase.shaded.com.google.inject.Key;
import org.apache.hadoop.hbase.shaded.com.google.inject.Scope;
import org.apache.hadoop.hbase.shaded.com.google.inject.Scopes;
import org.apache.hadoop.hbase.shaded.com.google.inject.spi.BindingScopingVisitor;

public class GuiceComponentProviderFactory
implements IoCComponentProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(GuiceComponentProviderFactory.class.getName());
    private final Map<Scope, ComponentScope> scopeMap = this.createScopeMap();
    private final Injector injector;

    public GuiceComponentProviderFactory(ResourceConfig config, Injector injector) {
        this.injector = injector;
        this.register(config, injector);
    }

    private void register(ResourceConfig config, Injector injector) {
        while (injector != null) {
            for (Key<?> key : injector.getBindings().keySet()) {
                Type type = key.getTypeLiteral().getType();
                if (!(type instanceof Class)) continue;
                Class c = (Class)type;
                if (ResourceConfig.isProviderClass(c)) {
                    LOGGER.log(Level.INFO, "Registering {0} as a provider class", c.getName());
                    config.getClasses().add(c);
                    continue;
                }
                if (!ResourceConfig.isRootResourceClass(c)) continue;
                LOGGER.log(Level.INFO, "Registering {0} as a root resource class", c.getName());
                config.getClasses().add(c);
            }
            injector = injector.getParent();
        }
    }

    @Override
    public IoCComponentProvider getComponentProvider(Class<?> c) {
        return this.getComponentProvider(null, c);
    }

    @Override
    public IoCComponentProvider getComponentProvider(ComponentContext cc, Class<?> clazz) {
        Key<?> key;
        Injector i;
        block7: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "getComponentProvider({0})", clazz.getName());
            }
            if ((i = this.findInjector(key = Key.get(clazz))) == null) {
                if (this.isGuiceConstructorInjected(clazz)) {
                    try {
                        if (this.injector.getBinding(key) != null) {
                            LOGGER.log(Level.INFO, "Binding {0} to GuiceInstantiatedComponentProvider", clazz.getName());
                            return new GuiceInstantiatedComponentProvider(this.injector, clazz);
                        }
                        break block7;
                    }
                    catch (ConfigurationException e) {
                        LOGGER.log(Level.SEVERE, "Cannot bind " + clazz.getName(), e);
                        throw e;
                    }
                }
                if (this.isGuiceFieldOrMethodInjected(clazz)) {
                    LOGGER.log(Level.INFO, "Binding {0} to GuiceInjectedComponentProvider", clazz.getName());
                    return new GuiceInjectedComponentProvider(this.injector);
                }
                return null;
            }
        }
        ComponentScope componentScope = this.getComponentScope(key, i);
        LOGGER.log(Level.INFO, "Binding {0} to GuiceManagedComponentProvider with the scope \"{1}\"", new Object[]{clazz.getName(), componentScope});
        return new GuiceManagedComponentProvider(i, componentScope, clazz);
    }

    private ComponentScope getComponentScope(Key<?> key, Injector i) {
        return i.getBinding(key).acceptScopingVisitor(new BindingScopingVisitor<ComponentScope>(){

            @Override
            public ComponentScope visitEagerSingleton() {
                return ComponentScope.Singleton;
            }

            @Override
            public ComponentScope visitScope(Scope theScope) {
                ComponentScope cs = (ComponentScope)((Object)GuiceComponentProviderFactory.this.scopeMap.get(theScope));
                return cs != null ? cs : ComponentScope.Undefined;
            }

            @Override
            public ComponentScope visitScopeAnnotation(Class scopeAnnotation) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ComponentScope visitNoScoping() {
                return ComponentScope.PerRequest;
            }
        });
    }

    private Injector findInjector(Key<?> key) {
        for (Injector i = this.injector; i != null; i = i.getParent()) {
            if (!i.getBindings().containsKey(key)) continue;
            return i;
        }
        return null;
    }

    @Deprecated
    public boolean isImplicitGuiceComponent(Class<?> c) {
        return this.isGuiceConstructorInjected(c);
    }

    public boolean isGuiceConstructorInjected(Class<?> c) {
        for (Constructor<?> con : c.getConstructors()) {
            if (!GuiceComponentProviderFactory.isInjectable(con)) continue;
            return true;
        }
        return false;
    }

    public boolean isGuiceFieldOrMethodInjected(Class<?> c) {
        for (Method method : c.getDeclaredMethods()) {
            if (!GuiceComponentProviderFactory.isInjectable(method)) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : c.getDeclaredFields()) {
            if (!GuiceComponentProviderFactory.isInjectable(accessibleObject)) continue;
            return true;
        }
        if (!c.equals(Object.class)) {
            return this.isGuiceFieldOrMethodInjected(c.getSuperclass());
        }
        return false;
    }

    private static boolean isInjectable(AnnotatedElement element) {
        return element.isAnnotationPresent(org.apache.hadoop.hbase.shaded.com.google.inject.Inject.class) || element.isAnnotationPresent(Inject.class);
    }

    public Map<Scope, ComponentScope> createScopeMap() {
        HashMap<Scope, ComponentScope> result = new HashMap<Scope, ComponentScope>();
        result.put(Scopes.SINGLETON, ComponentScope.Singleton);
        result.put(Scopes.NO_SCOPE, ComponentScope.PerRequest);
        return result;
    }

    private static class GuiceManagedComponentProvider
    extends GuiceInstantiatedComponentProvider
    implements IoCManagedComponentProvider {
        private final ComponentScope scope;

        public GuiceManagedComponentProvider(Injector injector, ComponentScope scope, Class<?> clazz) {
            super(injector, clazz);
            this.scope = scope;
        }

        @Override
        public ComponentScope getScope() {
            return this.scope;
        }
    }

    private static class GuiceInstantiatedComponentProvider
    implements IoCInstantiatedComponentProvider {
        private final Injector injector;
        private final Class<?> clazz;

        public GuiceInstantiatedComponentProvider(Injector injector, Class<?> clazz) {
            this.injector = injector;
            this.clazz = clazz;
        }

        public Class<?> getInjectableClass(Class<?> c) {
            return c.getSuperclass();
        }

        @Override
        public Object getInjectableInstance(Object o) {
            return o;
        }

        @Override
        public Object getInstance() {
            return this.injector.getInstance(this.clazz);
        }
    }

    private static class GuiceInjectedComponentProvider
    implements IoCProxiedComponentProvider {
        private final Injector injector;

        public GuiceInjectedComponentProvider(Injector injector) {
            this.injector = injector;
        }

        @Override
        public Object getInstance() {
            throw new IllegalStateException();
        }

        @Override
        public Object proxy(Object o) {
            this.injector.injectMembers(o);
            return o;
        }
    }
}

