/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.guice.spi.container.servlet;

import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.guice.spi.container.GuiceComponentProviderFactory;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.container.servlet.WebConfig;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import org.apache.hadoop.hbase.shaded.com.google.inject.Injector;
import org.apache.hadoop.hbase.shaded.com.google.inject.Scope;
import org.apache.hadoop.hbase.shaded.com.google.inject.servlet.ServletScopes;

@Singleton
public class GuiceContainer
extends ServletContainer {
    private static final long serialVersionUID = 1931878850157940335L;
    private final Injector injector;
    private WebApplication webapp;

    @Inject
    public GuiceContainer(Injector injector) {
        this.injector = injector;
    }

    @Override
    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig webConfig) throws ServletException {
        return new DefaultResourceConfig();
    }

    @Override
    protected void initiate(ResourceConfig config, WebApplication webapp) {
        this.webapp = webapp;
        webapp.initiate(config, new ServletGuiceComponentProviderFactory(config, this.injector));
    }

    public WebApplication getWebApplication() {
        return this.webapp;
    }

    public class ServletGuiceComponentProviderFactory
    extends GuiceComponentProviderFactory {
        public ServletGuiceComponentProviderFactory(ResourceConfig config, Injector injector) {
            super(config, injector);
        }

        @Override
        public Map<Scope, ComponentScope> createScopeMap() {
            Map<Scope, ComponentScope> m = super.createScopeMap();
            m.put(ServletScopes.REQUEST, ComponentScope.PerRequest);
            return m;
        }
    }
}

