/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.security.Key;
import java.security.KeyException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV2;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class HFileReaderV3
extends HFileReaderV2 {
    private static final Log LOG = LogFactory.getLog(HFileReaderV3.class);
    public static final int MAX_MINOR_VERSION = 0;

    public HFileReaderV3(Path path, FixedFileTrailer trailer, FSDataInputStreamWrapper fsdis, long size, CacheConfig cacheConf, HFileSystem hfs, Configuration conf) throws IOException {
        super(path, trailer, fsdis, size, cacheConf, hfs, conf);
        byte[] tmp = this.fileInfo.get(HFile.FileInfo.MAX_TAGS_LEN);
        if (tmp != null) {
            this.hfileContext.setIncludesTags(true);
            tmp = this.fileInfo.get(HFile.FileInfo.TAGS_COMPRESSED);
            if (tmp != null && Bytes.toBoolean(tmp)) {
                this.hfileContext.setCompressTags(true);
            }
        }
    }

    @Override
    protected HFileContext createHFileContext(FSDataInputStreamWrapper fsdis, long fileSize, HFileSystem hfs, Path path, FixedFileTrailer trailer) throws IOException {
        trailer.expectMajorVersion(3);
        HFileContextBuilder builder = new HFileContextBuilder().withIncludesMvcc(this.shouldIncludeMemstoreTS()).withHBaseCheckSum(true).withCompression(this.compressAlgo);
        byte[] keyBytes = trailer.getEncryptionKey();
        if (keyBytes != null) {
            Key key;
            Encryption.Context cryptoContext = Encryption.newContext(this.conf);
            String masterKeyName = this.conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName());
            try {
                key = EncryptionUtil.unwrapKey(this.conf, masterKeyName, keyBytes);
            }
            catch (KeyException e) {
                String alternateKeyName;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Unable to unwrap key with current master key '" + masterKeyName + "'"));
                }
                if ((alternateKeyName = this.conf.get("hbase.crypto.master.alternate.key.name")) != null) {
                    try {
                        key = EncryptionUtil.unwrapKey(this.conf, alternateKeyName, keyBytes);
                    }
                    catch (KeyException ex) {
                        throw new IOException(ex);
                    }
                }
                throw new IOException(e);
            }
            Cipher cipher = Encryption.getCipher(this.conf, key.getAlgorithm());
            if (cipher == null) {
                throw new IOException("Cipher '" + key.getAlgorithm() + "' is not available");
            }
            cryptoContext.setCipher(cipher);
            cryptoContext.setKey(key);
            builder.withEncryptionContext(cryptoContext);
        }
        HFileContext context = builder.build();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Reader" + (path != null ? " for " + path : "") + " initialized with cacheConf: " + this.cacheConf + " comparator: " + this.comparator.getClass().getSimpleName() + " fileContext: " + context));
        }
        return context;
    }

    @Override
    public HFileScanner getScanner(boolean cacheBlocks, boolean pread, boolean isCompaction) {
        if (this.dataBlockEncoder.useEncodedScanner()) {
            return new EncodedScannerV3(this, cacheBlocks, pread, isCompaction, this.hfileContext);
        }
        return new ScannerV3(this, cacheBlocks, pread, isCompaction);
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    protected static class EncodedScannerV3
    extends HFileReaderV2.EncodedScannerV2 {
        public EncodedScannerV3(HFileReaderV3 reader, boolean cacheBlocks, boolean pread, boolean isCompaction, HFileContext context) {
            super(reader, cacheBlocks, pread, isCompaction, context);
        }
    }

    protected static class ScannerV3
    extends HFileReaderV2.ScannerV2 {
        private HFileReaderV3 reader;
        private int currTagsLen;

        public ScannerV3(HFileReaderV3 r, boolean cacheBlocks, boolean pread, boolean isCompaction) {
            super(r, cacheBlocks, pread, isCompaction);
            this.reader = r;
        }

        @Override
        protected int getCellBufSize() {
            int kvBufSize = super.getCellBufSize();
            if (this.reader.hfileContext.isIncludesTags()) {
                kvBufSize += 2 + this.currTagsLen;
            }
            return kvBufSize;
        }

        @Override
        public Cell getKeyValue() {
            if (!this.isSeeked()) {
                return null;
            }
            if (this.currTagsLen > 0) {
                KeyValue ret = new KeyValue(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position(), this.getCellBufSize());
                if (this.reader.shouldIncludeMemstoreTS()) {
                    ret.setSequenceId(this.currMemstoreTS);
                }
                return ret;
            }
            return this.formNoTagsKeyValue();
        }

        @Override
        protected void setNonSeekedState() {
            super.setNonSeekedState();
            this.currTagsLen = 0;
        }

        @Override
        protected int getNextCellStartPosition() {
            int nextKvPos = super.getNextCellStartPosition();
            if (this.reader.hfileContext.isIncludesTags()) {
                nextKvPos += 2 + this.currTagsLen;
            }
            return nextKvPos;
        }

        private final void checkTagsLen() {
            if (this.checkLen(this.currTagsLen)) {
                throw new IllegalStateException("Invalid currTagsLen " + this.currTagsLen + ". Block offset: " + this.block.getOffset() + ", block length: " + this.blockBuffer.limit() + ", position: " + this.blockBuffer.position() + " (without header).");
            }
        }

        @Override
        protected final void readKeyValueLen() {
            int p = this.blockBuffer.position() + this.blockBuffer.arrayOffset();
            long ll = Bytes.toLong(this.blockBuffer.array(), p);
            this.currKeyLen = (int)(ll >> 32);
            this.currValueLen = (int)(0xFFFFFFFF00000000L ^ ll);
            this.checkKeyValueLen();
            p += 8 + this.currKeyLen + this.currValueLen;
            if (this.reader.hfileContext.isIncludesTags()) {
                this.currTagsLen = Bytes.toShort(this.blockBuffer.array(), p);
                this.checkTagsLen();
                p += 2 + this.currTagsLen;
            }
            this.readMvccVersion(p);
        }

        @Override
        protected int blockSeek(Cell key, boolean seekBefore) {
            int tlen = 0;
            long memstoreTS = 0L;
            int memstoreTSLen = 0;
            int lastKeyValueSize = -1;
            KeyValue.KeyOnlyKeyValue keyOnlyKv = new KeyValue.KeyOnlyKeyValue();
            do {
                this.blockBuffer.mark();
                int klen = this.blockBuffer.getInt();
                int vlen = this.blockBuffer.getInt();
                if (klen < 0 || vlen < 0 || klen > this.blockBuffer.limit() || vlen > this.blockBuffer.limit()) {
                    throw new IllegalStateException("Invalid klen " + klen + " or vlen " + vlen + ". Block offset: " + this.block.getOffset() + ", block length: " + this.blockBuffer.limit() + ", position: " + this.blockBuffer.position() + " (without header).");
                }
                ByteBufferUtils.skip(this.blockBuffer, klen + vlen);
                if (this.reader.hfileContext.isIncludesTags()) {
                    tlen = (this.blockBuffer.get() & 0xFF) << 8 ^ this.blockBuffer.get() & 0xFF;
                    if (tlen < 0 || tlen > this.blockBuffer.limit()) {
                        throw new IllegalStateException("Invalid tlen " + tlen + ". Block offset: " + this.block.getOffset() + ", block length: " + this.blockBuffer.limit() + ", position: " + this.blockBuffer.position() + " (without header).");
                    }
                    ByteBufferUtils.skip(this.blockBuffer, tlen);
                }
                if (this.reader.shouldIncludeMemstoreTS()) {
                    if (this.reader.decodeMemstoreTS) {
                        memstoreTS = Bytes.readAsVLong(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position());
                        memstoreTSLen = WritableUtils.getVIntSize(memstoreTS);
                    } else {
                        memstoreTS = 0L;
                        memstoreTSLen = 1;
                    }
                }
                this.blockBuffer.reset();
                int keyOffset = this.blockBuffer.arrayOffset() + this.blockBuffer.position() + 8;
                keyOnlyKv.setKey(this.blockBuffer.array(), keyOffset, klen);
                int comp = this.reader.getComparator().compareOnlyKeyPortion(key, keyOnlyKv);
                if (comp == 0) {
                    if (seekBefore) {
                        if (lastKeyValueSize < 0) {
                            throw new IllegalStateException("blockSeek with seekBefore at the first key of the block: key=" + CellUtil.getCellKeyAsString(key) + ", blockOffset=" + this.block.getOffset() + ", onDiskSize=" + this.block.getOnDiskSizeWithHeader());
                        }
                        this.blockBuffer.position(this.blockBuffer.position() - lastKeyValueSize);
                        this.readKeyValueLen();
                        return 1;
                    }
                    this.currKeyLen = klen;
                    this.currValueLen = vlen;
                    this.currTagsLen = tlen;
                    if (this.reader.shouldIncludeMemstoreTS()) {
                        this.currMemstoreTS = memstoreTS;
                        this.currMemstoreTSLen = memstoreTSLen;
                    }
                    return 0;
                }
                if (comp < 0) {
                    if (lastKeyValueSize > 0) {
                        this.blockBuffer.position(this.blockBuffer.position() - lastKeyValueSize);
                    }
                    this.readKeyValueLen();
                    if (lastKeyValueSize == -1 && this.blockBuffer.position() == 0) {
                        return -2;
                    }
                    return 1;
                }
                lastKeyValueSize = klen + vlen + memstoreTSLen + 8;
                if (this.reader.hfileContext.isIncludesTags()) {
                    lastKeyValueSize += tlen + 2;
                }
                this.blockBuffer.position(this.blockBuffer.position() + lastKeyValueSize);
            } while (this.blockBuffer.remaining() > 0);
            this.blockBuffer.position(this.blockBuffer.position() - lastKeyValueSize);
            this.readKeyValueLen();
            return 1;
        }
    }
}

