/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CellCounter {
    private static final Log LOG = LogFactory.getLog((String)CellCounter.class.getName());
    static final String NAME = "CellCounter";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        Path outputDir = new Path(args[1]);
        String reportSeparatorString = args.length > 2 ? args[2] : ":";
        conf.set("ReportSeparator", reportSeparatorString);
        Job job = new Job(conf, "CellCounter_" + tableName);
        job.setJarByClass(CellCounter.class);
        Scan scan = CellCounter.getConfiguredScanForJob(conf, args);
        TableMapReduceUtil.initTableMapperJob(tableName, scan, CellCounterMapper.class, ImmutableBytesWritable.class, Result.class, job);
        job.setNumReduceTasks(1);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        FileOutputFormat.setOutputPath(job, outputDir);
        job.setReducerClass(IntSumReducer.class);
        return job;
    }

    private static Scan getConfiguredScanForJob(Configuration conf, String[] args) throws IOException {
        long[] timeRange;
        Filter rowFilter;
        Scan s = new Scan();
        s.setMaxVersions(Integer.MAX_VALUE);
        s.setCacheBlocks(false);
        if (conf.get("hbase.mapreduce.scan.column.family") != null) {
            s.addFamily(Bytes.toBytes(conf.get("hbase.mapreduce.scan.column.family")));
        }
        if ((rowFilter = CellCounter.getRowFilter(args)) != null) {
            LOG.info((Object)"Setting Row Filter for counter.");
            s.setFilter(rowFilter);
        }
        if ((timeRange = CellCounter.getTimeRange(args)) != null) {
            LOG.info((Object)"Setting TimeRange for counter.");
            s.setTimeRange(timeRange[0], timeRange[1]);
        }
        return s;
    }

    private static Filter getRowFilter(String[] args) {
        String filterCriteria;
        FilterBase rowFilter = null;
        String string = filterCriteria = args.length > 3 ? args[3] : null;
        if (filterCriteria == null) {
            return null;
        }
        if (filterCriteria.startsWith("^")) {
            String regexPattern = filterCriteria.substring(1, filterCriteria.length());
            rowFilter = new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(regexPattern));
        } else {
            rowFilter = new PrefixFilter(Bytes.toBytes(filterCriteria));
        }
        return rowFilter;
    }

    private static long[] getTimeRange(String[] args) throws IOException {
        String startTimeArgKey = "--starttime=";
        String endTimeArgKey = "--endtime=";
        long startTime = 0L;
        long endTime = 0L;
        for (int i = 1; i < args.length; ++i) {
            System.out.println("i:" + i + "arg[i]" + args[i]);
            if (args[i].startsWith("--starttime=")) {
                startTime = Long.parseLong(args[i].substring("--starttime=".length()));
            }
            if (!args[i].startsWith("--endtime=")) continue;
            endTime = Long.parseLong(args[i].substring("--endtime=".length()));
        }
        if (startTime == 0L && endTime == 0L) {
            return null;
        }
        endTime = endTime == 0L ? Long.MAX_VALUE : endTime;
        return new long[]{startTime, endTime};
    }

    public static void main(String[] args) throws Exception {
        Job job;
        Configuration conf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 2) {
            System.err.println("ERROR: Wrong number of parameters: " + args.length);
            System.err.println("Usage: CellCounter ");
            System.err.println("       <tablename> <outputDir> <reportSeparator> [^[regex pattern] or [Prefix] for row filter]] --starttime=[starttime] --endtime=[endtime]");
            System.err.println("  Note: -D properties will be applied to the conf used. ");
            System.err.println("  Additionally, the following SCAN properties can be specified");
            System.err.println("  to get fine grained control on what is counted..");
            System.err.println("   -D hbase.mapreduce.scan.column.family=<familyName>");
            System.err.println(" <reportSeparator> parameter can be used to override the default report separator string : used to separate the rowId/column family name and qualifier name.");
            System.err.println(" [^[regex pattern] or [Prefix] parameter can be used to limit the cell counter count operation to a limited subset of rows from the table based on regex or prefix pattern.");
            System.exit(-1);
        }
        System.exit((job = CellCounter.createSubmittableJob(conf, otherArgs)).waitForCompletion(true) ? 0 : 1);
    }

    static class IntSumReducer<Key>
    extends Reducer<Key, IntWritable, Key, IntWritable> {
        private IntWritable result = new IntWritable();

        IntSumReducer() {
        }

        @Override
        public void reduce(Key key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write(key, this.result);
        }
    }

    static class CellCounterMapper
    extends TableMapper<Text, IntWritable> {
        CellCounterMapper() {
        }

        @Override
        public void map(ImmutableBytesWritable row, Result values, Mapper.Context context) throws IOException {
            Preconditions.checkState(values != null, "values passed to the map is null");
            String currentFamilyName = null;
            String currentQualifierName = null;
            String currentRowKey = null;
            Configuration config = context.getConfiguration();
            String separator = config.get("ReportSeparator", ":");
            try {
                context.getCounter(Counters.ROWS).increment(1L);
                context.write(new Text("Total ROWS"), new IntWritable(1));
                for (Cell value : values.listCells()) {
                    String thisRowQualifierName;
                    currentRowKey = Bytes.toStringBinary(CellUtil.cloneRow(value));
                    String thisRowFamilyName = Bytes.toStringBinary(CellUtil.cloneFamily(value));
                    if (!thisRowFamilyName.equals(currentFamilyName)) {
                        currentFamilyName = thisRowFamilyName;
                        context.getCounter("CF", thisRowFamilyName).increment(1L);
                        if (1L == context.getCounter("CF", thisRowFamilyName).getValue()) {
                            context.write(new Text("Total Families Across all Rows"), new IntWritable(1));
                            context.write(new Text(thisRowFamilyName), new IntWritable(1));
                        }
                    }
                    if (!(thisRowQualifierName = thisRowFamilyName + separator + Bytes.toStringBinary(CellUtil.cloneQualifier(value))).equals(currentQualifierName)) {
                        currentQualifierName = thisRowQualifierName;
                        context.getCounter("CFQL", thisRowQualifierName).increment(1L);
                        context.write(new Text("Total Qualifiers across all Rows"), new IntWritable(1));
                        context.write(new Text(thisRowQualifierName), new IntWritable(1));
                        context.getCounter("QL_VERSIONS", currentRowKey + separator + thisRowQualifierName).increment(1L);
                        context.write(new Text(currentRowKey + separator + thisRowQualifierName + "_Versions"), new IntWritable(1));
                        continue;
                    }
                    currentQualifierName = thisRowQualifierName;
                    context.getCounter("QL_VERSIONS", currentRowKey + separator + thisRowQualifierName).increment(1L);
                    context.write(new Text(currentRowKey + separator + thisRowQualifierName + "_Versions"), new IntWritable(1));
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public static enum Counters {
            ROWS;

        }
    }
}

