/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.google.inject.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.hadoop.hbase.shaded.com.google.inject.servlet.FilterDefinition;
import org.apache.hadoop.hbase.shaded.com.google.inject.servlet.ManagedServletPipeline;

class FilterChainInvocation
implements FilterChain {
    private final FilterDefinition[] filterDefinitions;
    private final FilterChain proceedingChain;
    private final ManagedServletPipeline servletPipeline;
    private int index = -1;

    public FilterChainInvocation(FilterDefinition[] filterDefinitions, ManagedServletPipeline servletPipeline, FilterChain proceedingChain) {
        this.filterDefinitions = filterDefinitions;
        this.servletPipeline = servletPipeline;
        this.proceedingChain = proceedingChain;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        ++this.index;
        if (this.index < this.filterDefinitions.length) {
            this.filterDefinitions[this.index].doFilter(servletRequest, servletResponse, this);
        } else {
            boolean serviced = this.servletPipeline.service(servletRequest, servletResponse);
            if (!serviced) {
                this.proceedingChain.doFilter(servletRequest, servletResponse);
            }
        }
    }
}

