/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.standard.lang.jstl;

import org.apache.hadoop.hbase.shaded.org.apache.commons.standard.lang.jstl.BinaryOperator;
import org.apache.hadoop.hbase.shaded.org.apache.commons.standard.lang.jstl.Coercions;
import org.apache.hadoop.hbase.shaded.org.apache.commons.standard.lang.jstl.ELException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.standard.lang.jstl.Logger;
import org.apache.hadoop.hbase.shaded.org.apache.commons.standard.lang.jstl.PrimitiveObjects;

public class OrOperator
extends BinaryOperator {
    public static final OrOperator SINGLETON = new OrOperator();

    public String getOperatorSymbol() {
        return "or";
    }

    public Object apply(Object pLeft, Object pRight, Object pContext, Logger pLogger) throws ELException {
        boolean left = Coercions.coerceToBoolean(pLeft, pLogger);
        boolean right = Coercions.coerceToBoolean(pRight, pLogger);
        return PrimitiveObjects.getBoolean(left || right);
    }

    public boolean shouldEvaluate(Object pLeft) {
        return pLeft instanceof Boolean && (Boolean)pLeft == false;
    }

    public boolean shouldCoerceToBoolean() {
        return true;
    }
}

