/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.JasperException;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.Options;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.JspProperty;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.JspPropertyGroup;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.Localizer;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.xmlparser.ParserUtils;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.xmlparser.TreeNode;
import org.xml.sax.InputSource;

public class JspConfig {
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static Log log = LogFactory.getLog(JspConfig.class);
    private Options options;
    private Vector jspProperties = null;
    private ServletContext ctxt;
    private String defaultIsXml = null;
    private String defaultIsELIgnored = null;
    private String defaultIsScriptingInvalid = "false";
    private String defaultTrimSpaces = "false";
    private String defaultPoundAllowed = "false";
    private JspProperty defaultJspProperty;

    public JspConfig(ServletContext ctxt, Options options) throws JasperException {
        this.ctxt = ctxt;
        this.options = options;
        this.init();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processWebDotXml(ServletContext ctxt) throws JasperException {
        block27: {
            block26: {
                block25: {
                    block24: {
                        is = null;
                        try {
                            try {
                                uri = ctxt.getResource("/WEB-INF/web.xml");
                                if (uri == null) {
                                    var22_5 = null;
                                    if (is == null) return;
                                    break block24;
                                }
                                is = uri.openStream();
                                ip = new InputSource(is);
                                ip.setSystemId(uri.toExternalForm());
                                pu = new ParserUtils();
                                webApp = pu.parseXMLDocument("/WEB-INF/web.xml", ip, this.options.isValidationEnabled());
                                if (webApp == null || webApp.findAttribute("version") == null || Double.valueOf(webApp.findAttribute("version")) < 2.4) {
                                    this.defaultIsELIgnored = "true";
                                    break block25;
                                }
                                jspConfig = webApp.findChild("jsp-config");
                                if (jspConfig == null) {
                                    break block26;
                                }
                                this.jspProperties = new Vector<E>();
                                jspPropertyList = jspConfig.findChildren("jsp-property-group");
                                while (jspPropertyList.hasNext()) {
                                    element = (TreeNode)jspPropertyList.next();
                                    list = element.findChildren();
                                    urlPatterns = new Vector<String>();
                                    pageEncoding = null;
                                    scriptingInvalid = null;
                                    elIgnored = null;
                                    isXml = null;
                                    includePrelude = new Vector<String>();
                                    includeCoda = new Vector<String>();
                                    trimSpaces = null;
                                    poundAllowed = null;
                                    while (list.hasNext()) {
                                        element = (TreeNode)list.next();
                                        tname = element.getName();
                                        if ("url-pattern".equals(tname)) {
                                            urlPatterns.addElement(element.getBody());
                                            continue;
                                        }
                                        if ("page-encoding".equals(tname)) {
                                            pageEncoding = element.getBody();
                                            continue;
                                        }
                                        if ("is-xml".equals(tname)) {
                                            isXml = element.getBody();
                                            continue;
                                        }
                                        if ("el-ignored".equals(tname)) {
                                            elIgnored = element.getBody();
                                            continue;
                                        }
                                        if ("scripting-invalid".equals(tname)) {
                                            scriptingInvalid = element.getBody();
                                            continue;
                                        }
                                        if ("include-prelude".equals(tname)) {
                                            includePrelude.addElement(element.getBody());
                                            continue;
                                        }
                                        if ("include-coda".equals(tname)) {
                                            includeCoda.addElement(element.getBody());
                                            continue;
                                        }
                                        if ("trim-directive-whitespaces".equals(tname)) {
                                            trimSpaces = element.getBody();
                                            continue;
                                        }
                                        if (!"deferred-syntax-allowed-as-literal".equals(tname)) continue;
                                        poundAllowed = element.getBody();
                                    }
                                    if (urlPatterns.size() == 0) continue;
                                    JspConfig.makeJspPropertyGroups(this.jspProperties, urlPatterns, isXml, elIgnored, scriptingInvalid, trimSpaces, poundAllowed, pageEncoding, includePrelude, includeCoda);
                                }
                                break block27;
                            }
                            catch (Exception ex) {
                                throw new JasperException(ex);
                            }
                        }
                        catch (Throwable var21_32) {
                            var22_9 = null;
                            if (is == null) throw var21_32;
                            try {
                                is.close();
                                throw var21_32;
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            throw var21_32;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [9 : 516->523)] { 
lbl85:
                    // 1 sources

                    is.close();
                    return;
lbl87:
                    // 1 sources

                    catch (Throwable t) {
                        // empty catch block
                    }
                    return;
                }
                var22_6 = null;
                if (is == null) return;
                ** try [egrp 2[TRYBLOCK] [9 : 516->523)] { 
lbl94:
                // 1 sources

                is.close();
                return;
lbl96:
                // 1 sources

                catch (Throwable t) {
                    // empty catch block
                }
                return;
            }
            var22_7 = null;
            if (is == null) return;
            ** try [egrp 2[TRYBLOCK] [9 : 516->523)] { 
lbl103:
            // 1 sources

            is.close();
            return;
lbl105:
            // 1 sources

            catch (Throwable t) {
                // empty catch block
            }
            return;
        }
        var22_8 = null;
        if (is == null) return;
        try {}
        catch (Throwable t) {}
        is.close();
        return;
    }

    public static void makeJspPropertyGroups(Vector jspProperties, Vector urlPatterns, String isXml, String elIgnored, String scriptingInvalid, String trimSpaces, String poundAllowed, String pageEncoding, Vector includePrelude, Vector includeCoda) {
        if (urlPatterns == null || urlPatterns.size() == 0) {
            return;
        }
        for (int p = 0; p < urlPatterns.size(); ++p) {
            String urlPattern = (String)urlPatterns.elementAt(p);
            String path = null;
            String extension = null;
            if (urlPattern.indexOf(42) < 0) {
                path = urlPattern;
            } else {
                String file;
                int i = urlPattern.lastIndexOf(47);
                if (i >= 0) {
                    path = urlPattern.substring(0, i + 1);
                    file = urlPattern.substring(i + 1);
                } else {
                    file = urlPattern;
                }
                if (file.equals("*")) {
                    extension = "*";
                } else if (file.startsWith("*.")) {
                    extension = file.substring(file.indexOf(46) + 1);
                }
                boolean isStar = "*".equals(extension);
                if (path == null && (extension == null || isStar) || path != null && !isStar) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn(Localizer.getMessage("jsp.warning.bad.urlpattern.propertygroup", urlPattern));
                    continue;
                }
            }
            JspProperty property = new JspProperty(isXml, elIgnored, scriptingInvalid, trimSpaces, poundAllowed, pageEncoding, includePrelude, includeCoda);
            JspPropertyGroup propertyGroup = new JspPropertyGroup(path, extension, property);
            jspProperties.addElement(propertyGroup);
        }
    }

    private void init() throws JasperException {
        String version;
        this.jspProperties = (Vector)this.ctxt.getAttribute("com.sun.jsp.propertyGroups");
        if (this.jspProperties == null) {
            this.processWebDotXml(this.ctxt);
        }
        if ((version = (String)this.ctxt.getAttribute("com.sun.servlet.webxml.version")) != null && Double.valueOf(version) < 2.4) {
            this.defaultIsELIgnored = "true";
        }
        this.defaultJspProperty = new JspProperty(this.defaultIsXml, this.defaultIsELIgnored, this.defaultIsScriptingInvalid, this.defaultTrimSpaces, this.defaultPoundAllowed, null, null, null);
    }

    private JspPropertyGroup selectProperty(JspPropertyGroup prev, JspPropertyGroup curr) {
        if (prev == null) {
            return curr;
        }
        if (prev.getExtension() == null) {
            return prev;
        }
        if (curr.getExtension() == null) {
            return curr;
        }
        String prevPath = prev.getPath();
        String currPath = curr.getPath();
        if (prevPath == null && currPath == null) {
            return prev;
        }
        if (prevPath == null && currPath != null) {
            return curr;
        }
        if (prevPath != null && currPath == null) {
            return prev;
        }
        if (prevPath.length() >= currPath.length()) {
            return prev;
        }
        return curr;
    }

    public JspProperty findJspProperty(String uri) throws JasperException {
        if (this.jspProperties == null || uri.endsWith(".tag") || uri.endsWith(".tagx")) {
            return this.defaultJspProperty;
        }
        String uriPath = null;
        int index = uri.lastIndexOf(47);
        if (index >= 0) {
            uriPath = uri.substring(0, index + 1);
        }
        String uriExtension = null;
        index = uri.lastIndexOf(46);
        if (index >= 0) {
            uriExtension = uri.substring(index + 1);
        }
        Vector includePreludes = new Vector();
        Vector includeCodas = new Vector();
        JspPropertyGroup isXmlMatch = null;
        JspPropertyGroup elIgnoredMatch = null;
        JspPropertyGroup scriptingInvalidMatch = null;
        JspPropertyGroup trimSpacesMatch = null;
        JspPropertyGroup poundAllowedMatch = null;
        JspPropertyGroup pageEncodingMatch = null;
        for (JspPropertyGroup jpg : this.jspProperties) {
            JspProperty jp = jpg.getJspProperty();
            String extension = jpg.getExtension();
            String path = jpg.getPath();
            if (extension != null ? path != null && uriPath != null && !uriPath.startsWith(path) || !extension.equals("*") && !extension.equals(uriExtension) : !uri.equals(path)) continue;
            if (jp.getIncludePrelude() != null) {
                includePreludes.addAll(jp.getIncludePrelude());
            }
            if (jp.getIncludeCoda() != null) {
                includeCodas.addAll(jp.getIncludeCoda());
            }
            if (jp.isXml() != null) {
                isXmlMatch = this.selectProperty(isXmlMatch, jpg);
            }
            if (jp.isELIgnored() != null) {
                elIgnoredMatch = this.selectProperty(elIgnoredMatch, jpg);
            }
            if (jp.isScriptingInvalid() != null) {
                scriptingInvalidMatch = this.selectProperty(scriptingInvalidMatch, jpg);
            }
            if (jp.getPageEncoding() != null) {
                pageEncodingMatch = this.selectProperty(pageEncodingMatch, jpg);
            }
            if (jp.getTrimSpaces() != null) {
                trimSpacesMatch = this.selectProperty(trimSpacesMatch, jpg);
            }
            if (jp.getPoundAllowed() == null) continue;
            poundAllowedMatch = this.selectProperty(poundAllowedMatch, jpg);
        }
        String isXml = this.defaultIsXml;
        String isELIgnored = this.defaultIsELIgnored;
        String isScriptingInvalid = this.defaultIsScriptingInvalid;
        String trimSpaces = this.defaultTrimSpaces;
        String poundAllowed = this.defaultPoundAllowed;
        String pageEncoding = null;
        if (isXmlMatch != null) {
            isXml = isXmlMatch.getJspProperty().isXml();
        }
        if (elIgnoredMatch != null) {
            isELIgnored = elIgnoredMatch.getJspProperty().isELIgnored();
        }
        if (scriptingInvalidMatch != null) {
            isScriptingInvalid = scriptingInvalidMatch.getJspProperty().isScriptingInvalid();
        }
        if (trimSpacesMatch != null) {
            trimSpaces = trimSpacesMatch.getJspProperty().getTrimSpaces();
        }
        if (poundAllowedMatch != null) {
            poundAllowed = poundAllowedMatch.getJspProperty().getPoundAllowed();
        }
        if (pageEncodingMatch != null) {
            pageEncoding = pageEncodingMatch.getJspProperty().getPageEncoding();
        }
        return new JspProperty(isXml, isELIgnored, isScriptingInvalid, trimSpaces, poundAllowed, pageEncoding, includePreludes, includeCodas);
    }

    public boolean isJspPage(String uri) throws JasperException {
        if (this.jspProperties == null) {
            return false;
        }
        String uriPath = null;
        int index = uri.lastIndexOf(47);
        if (index >= 0) {
            uriPath = uri.substring(0, index + 1);
        }
        String uriExtension = null;
        index = uri.lastIndexOf(46);
        if (index >= 0) {
            uriExtension = uri.substring(index + 1);
        }
        for (JspPropertyGroup jpg : this.jspProperties) {
            JspProperty jp = jpg.getJspProperty();
            String extension = jpg.getExtension();
            String path = jpg.getPath();
            if (!(extension == null ? uri.equals(path) : !(path != null && !path.equals(uriPath) || !extension.equals("*") && !extension.equals(uriExtension)))) continue;
            return true;
        }
        return false;
    }
}

