/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.el.FunctionMapper;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.JasperException;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.JspCompilationContext;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.BeanRepository;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.Compiler;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.ELNode;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.ELParser;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.JspUtil;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.Localizer;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.Node;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.PageDataImpl;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.PageInfo;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.runtime.JspRuntimeLibrary;
import org.xml.sax.Attributes;

class Validator {
    Validator() {
    }

    public static void validate(Compiler compiler, Node.Nodes page) throws JasperException {
        page.visit(new DirectiveVisitor(compiler));
        PageInfo pageInfo = compiler.getPageInfo();
        String contentType = pageInfo.getContentType();
        if (contentType == null || contentType.indexOf("charset=") < 0) {
            boolean isXml = page.getRoot().isXmlSyntax();
            String defaultType = contentType == null ? (isXml ? "text/xml" : "text/html") : contentType;
            String charset = null;
            if (isXml) {
                charset = "UTF-8";
            } else if (!page.getRoot().isDefaultPageEncoding()) {
                charset = page.getRoot().getPageEncoding();
            }
            if (charset != null) {
                pageInfo.setContentType(defaultType + ";charset=" + charset);
            } else {
                pageInfo.setContentType(defaultType);
            }
        }
        page.visit(new ValidateVisitor(compiler));
        Validator.validateXmlView(new PageDataImpl(page, compiler), compiler);
        page.visit(new TagExtraInfoVisitor(compiler));
    }

    private static void validateXmlView(PageData xmlView, Compiler compiler) throws JasperException {
        StringBuffer errMsg = null;
        ErrorDispatcher errDisp = compiler.getErrorDispatcher();
        for (Object o : compiler.getPageInfo().getTaglibs()) {
            TagLibraryInfoImpl tli;
            ValidationMessage[] errors;
            if (!(o instanceof TagLibraryInfoImpl) || (errors = (tli = (TagLibraryInfoImpl)o).validate(xmlView)) == null || errors.length == 0) continue;
            if (errMsg == null) {
                errMsg = new StringBuffer();
            }
            errMsg.append("<h3>");
            errMsg.append(Localizer.getMessage("jsp.error.tlv.invalid.page", tli.getShortName()));
            errMsg.append("</h3>");
            for (int i = 0; i < errors.length; ++i) {
                if (errors[i] == null) continue;
                errMsg.append("<p>");
                errMsg.append(errors[i].getId());
                errMsg.append(": ");
                errMsg.append(errors[i].getMessage());
                errMsg.append("</p>");
            }
        }
        if (errMsg != null) {
            errDisp.jspError(errMsg.toString());
        }
    }

    static class TagExtraInfoVisitor
    extends Node.Visitor {
        private ErrorDispatcher err;

        TagExtraInfoVisitor(Compiler compiler) {
            this.err = compiler.getErrorDispatcher();
        }

        public void visit(Node.CustomTag n) throws JasperException {
            ValidationMessage[] errors;
            TagInfo tagInfo = n.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError((Node)n, "jsp.error.missing.tagInfo", n.getQName());
            }
            if ((errors = tagInfo.validate(n.getTagData())) != null && errors.length != 0) {
                StringBuffer errMsg = new StringBuffer();
                errMsg.append("<h3>");
                errMsg.append(Localizer.getMessage("jsp.error.tei.invalid.attributes", n.getQName()));
                errMsg.append("</h3>");
                for (int i = 0; i < errors.length; ++i) {
                    errMsg.append("<p>");
                    if (errors[i].getId() != null) {
                        errMsg.append(errors[i].getId());
                        errMsg.append(": ");
                    }
                    errMsg.append(errors[i].getMessage());
                    errMsg.append("</p>");
                }
                this.err.jspError(n, errMsg.toString());
            }
            this.visitBody(n);
        }
    }

    static class ValidateVisitor
    extends Node.Visitor {
        private PageInfo pageInfo;
        private ErrorDispatcher err;
        private ClassLoader loader;
        private JspCompilationContext ctxt;
        private static final JspUtil.ValidAttribute[] jspRootAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("xsi:schemaLocation"), new JspUtil.ValidAttribute("version", true)};
        private static final JspUtil.ValidAttribute[] includeDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("file", true)};
        private static final JspUtil.ValidAttribute[] taglibDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("uri"), new JspUtil.ValidAttribute("tagdir"), new JspUtil.ValidAttribute("prefix", true)};
        private static final JspUtil.ValidAttribute[] includeActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true), new JspUtil.ValidAttribute("flush")};
        private static final JspUtil.ValidAttribute[] paramActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("value", true)};
        private static final JspUtil.ValidAttribute[] forwardActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true)};
        private static final JspUtil.ValidAttribute[] getPropertyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true)};
        private static final JspUtil.ValidAttribute[] setPropertyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true), new JspUtil.ValidAttribute("value", false), new JspUtil.ValidAttribute("param")};
        private static final JspUtil.ValidAttribute[] useBeanAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("id", true), new JspUtil.ValidAttribute("scope"), new JspUtil.ValidAttribute("class"), new JspUtil.ValidAttribute("type"), new JspUtil.ValidAttribute("beanName", false)};
        private static final JspUtil.ValidAttribute[] plugInAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("type", true), new JspUtil.ValidAttribute("code", true), new JspUtil.ValidAttribute("codebase"), new JspUtil.ValidAttribute("align"), new JspUtil.ValidAttribute("archive"), new JspUtil.ValidAttribute("height", false), new JspUtil.ValidAttribute("hspace"), new JspUtil.ValidAttribute("jreversion"), new JspUtil.ValidAttribute("name"), new JspUtil.ValidAttribute("vspace"), new JspUtil.ValidAttribute("width", false), new JspUtil.ValidAttribute("nspluginurl"), new JspUtil.ValidAttribute("iepluginurl")};
        private static final JspUtil.ValidAttribute[] attributeAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("trim")};
        private static final JspUtil.ValidAttribute[] invokeAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("fragment", true), new JspUtil.ValidAttribute("var"), new JspUtil.ValidAttribute("varReader"), new JspUtil.ValidAttribute("scope")};
        private static final JspUtil.ValidAttribute[] doBodyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("var"), new JspUtil.ValidAttribute("varReader"), new JspUtil.ValidAttribute("scope")};
        private static final JspUtil.ValidAttribute[] jspOutputAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("omit-xml-declaration"), new JspUtil.ValidAttribute("doctype-root-element"), new JspUtil.ValidAttribute("doctype-public"), new JspUtil.ValidAttribute("doctype-system")};

        ValidateVisitor(Compiler compiler) {
            this.pageInfo = compiler.getPageInfo();
            this.err = compiler.getErrorDispatcher();
            this.ctxt = compiler.getCompilationContext();
            this.loader = this.ctxt.getClassLoader();
        }

        public void visit(Node.JspRoot n) throws JasperException {
            JspUtil.checkAttributes("Jsp:root", n, jspRootAttrs, this.err);
            String version = n.getTextAttribute("version");
            if (!(version.equals("1.2") || version.equals("2.0") || version.equals("2.1"))) {
                this.err.jspError((Node)n, "jsp.error.jsproot.version.invalid", version);
            }
            this.visitBody(n);
        }

        public void visit(Node.IncludeDirective n) throws JasperException {
            JspUtil.checkAttributes("Include directive", n, includeDirectiveAttrs, this.err);
            this.visitBody(n);
        }

        public void visit(Node.TaglibDirective n) throws JasperException {
            JspUtil.checkAttributes("Taglib directive", n, taglibDirectiveAttrs, this.err);
            String uri = n.getAttributeValue("uri");
            String tagdir = n.getAttributeValue("tagdir");
            if (uri == null && tagdir == null) {
                this.err.jspError(n, "jsp.error.taglibDirective.missing.location");
            }
            if (uri != null && tagdir != null) {
                this.err.jspError(n, "jsp.error.taglibDirective.both_uri_and_tagdir");
            }
        }

        public void visit(Node.ParamAction n) throws JasperException {
            JspUtil.checkAttributes("Param action", n, paramActionAttrs, this.err);
            this.throwErrorIfExpression(n, "name", "jsp:param");
            n.setValue(this.getJspAttribute("value", null, null, n.getAttributeValue("value"), n, false, null));
            this.visitBody(n);
        }

        public void visit(Node.ParamsAction n) throws JasperException {
            Node.Nodes subElems = n.getBody();
            if (subElems == null) {
                this.err.jspError(n, "jsp.error.params.emptyBody");
            }
            this.visitBody(n);
        }

        public void visit(Node.IncludeAction n) throws JasperException {
            JspUtil.checkAttributes("Include action", n, includeActionAttrs, this.err);
            n.setPage(this.getJspAttribute("page", null, null, n.getAttributeValue("page"), n, false, null));
            this.visitBody(n);
        }

        public void visit(Node.ForwardAction n) throws JasperException {
            JspUtil.checkAttributes("Forward", n, forwardActionAttrs, this.err);
            n.setPage(this.getJspAttribute("page", null, null, n.getAttributeValue("page"), n, false, null));
            this.visitBody(n);
        }

        public void visit(Node.GetProperty n) throws JasperException {
            JspUtil.checkAttributes("GetProperty", n, getPropertyAttrs, this.err);
        }

        public void visit(Node.SetProperty n) throws JasperException {
            boolean valueSpecified;
            JspUtil.checkAttributes("SetProperty", n, setPropertyAttrs, this.err);
            String property = n.getTextAttribute("property");
            String param = n.getTextAttribute("param");
            String value = n.getAttributeValue("value");
            n.setValue(this.getJspAttribute("value", null, null, value, n, false, null));
            boolean bl = valueSpecified = n.getValue() != null;
            if ("*".equals(property)) {
                if (param != null || valueSpecified) {
                    this.err.jspError(n, "jsp.error.setProperty.invalid");
                }
            } else if (param != null && valueSpecified) {
                this.err.jspError(n, "jsp.error.setProperty.invalid");
            }
            this.visitBody(n);
        }

        public void visit(Node.UseBean n) throws JasperException {
            JspUtil.checkAttributes("UseBean", n, useBeanAttrs, this.err);
            String name = n.getTextAttribute("id");
            String scope = n.getTextAttribute("scope");
            JspUtil.checkScope(scope, n, this.err);
            String className = n.getTextAttribute("class");
            String type = n.getTextAttribute("type");
            BeanRepository beanInfo = this.pageInfo.getBeanRepository();
            if (className == null && type == null) {
                this.err.jspError(n, "jsp.error.usebean.missingType");
            }
            if (beanInfo.checkVariable(name)) {
                this.err.jspError((Node)n, "jsp.error.usebean.duplicate", name);
            }
            if ("session".equals(scope) && !this.pageInfo.isSession()) {
                this.err.jspError(n, "jsp.error.usebean.noSession");
            }
            Node.JspAttribute jattr = this.getJspAttribute("beanName", null, null, n.getAttributeValue("beanName"), n, false, null);
            n.setBeanName(jattr);
            if (className != null && jattr != null) {
                this.err.jspError(n, "jsp.error.usebean.notBoth");
            }
            if (className == null) {
                className = type;
            }
            beanInfo.addBean(n, name, className, scope);
            this.visitBody(n);
        }

        public void visit(Node.PlugIn n) throws JasperException {
            JspUtil.checkAttributes("Plugin", n, plugInAttrs, this.err);
            this.throwErrorIfExpression(n, "type", "jsp:plugin");
            this.throwErrorIfExpression(n, "code", "jsp:plugin");
            this.throwErrorIfExpression(n, "codebase", "jsp:plugin");
            this.throwErrorIfExpression(n, "align", "jsp:plugin");
            this.throwErrorIfExpression(n, "archive", "jsp:plugin");
            this.throwErrorIfExpression(n, "hspace", "jsp:plugin");
            this.throwErrorIfExpression(n, "jreversion", "jsp:plugin");
            this.throwErrorIfExpression(n, "name", "jsp:plugin");
            this.throwErrorIfExpression(n, "vspace", "jsp:plugin");
            this.throwErrorIfExpression(n, "nspluginurl", "jsp:plugin");
            this.throwErrorIfExpression(n, "iepluginurl", "jsp:plugin");
            String type = n.getTextAttribute("type");
            if (type == null) {
                this.err.jspError(n, "jsp.error.plugin.notype");
            }
            if (!type.equals("bean") && !type.equals("applet")) {
                this.err.jspError(n, "jsp.error.plugin.badtype");
            }
            if (n.getTextAttribute("code") == null) {
                this.err.jspError(n, "jsp.error.plugin.nocode");
            }
            Node.JspAttribute width = this.getJspAttribute("width", null, null, n.getAttributeValue("width"), n, false, null);
            n.setWidth(width);
            Node.JspAttribute height = this.getJspAttribute("height", null, null, n.getAttributeValue("height"), n, false, null);
            n.setHeight(height);
            this.visitBody(n);
        }

        public void visit(Node.NamedAttribute n) throws JasperException {
            JspUtil.checkAttributes("Attribute", n, attributeAttrs, this.err);
            this.visitBody(n);
        }

        public void visit(Node.JspBody n) throws JasperException {
            this.visitBody(n);
        }

        public void visit(Node.Declaration n) throws JasperException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(n.getStart(), "jsp.error.no.scriptlets");
            }
        }

        public void visit(Node.Expression n) throws JasperException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(n.getStart(), "jsp.error.no.scriptlets");
            }
        }

        public void visit(Node.Scriptlet n) throws JasperException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(n.getStart(), "jsp.error.no.scriptlets");
            }
        }

        public void visit(Node.ELExpression n) throws JasperException {
            if (this.pageInfo.isELIgnored()) {
                return;
            }
            String expressions = n.getText();
            if (expressions.charAt(0) == '#') {
                String versionString;
                Double version;
                if (this.pageInfo.isDeferredSyntaxAllowedAsLiteral()) {
                    return;
                }
                if (this.ctxt.isTagFile() && (version = Double.valueOf(Double.valueOf(versionString = this.ctxt.getTagInfo().getTagLibrary().getRequiredVersion()))) < 2.1) {
                    return;
                }
                this.err.jspError(n.getStart(), "jsp.error.not.in.template", "#{...}");
            }
            ELNode.Nodes el = ELParser.parse(expressions);
            this.validateFunctions(el, n);
            JspUtil.validateExpressions(n.getStart(), expressions, this.getFunctionMapper(el), this.err);
            n.setEL(el);
        }

        public void visit(Node.UninterpretedTag n) throws JasperException {
            Attributes attrs;
            if (n.getNamedAttributeNodes().size() != 0) {
                this.err.jspError(n, "jsp.error.namedAttribute.invalidUse");
            }
            if ((attrs = n.getAttributes()) != null) {
                int attrSize = attrs.getLength();
                Node.JspAttribute[] jspAttrs = new Node.JspAttribute[attrSize];
                for (int i = 0; i < attrSize; ++i) {
                    jspAttrs[i] = this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), n, false, null);
                }
                n.setJspAttributes(jspAttrs);
            }
            this.visitBody(n);
        }

        public void visit(Node.CustomTag n) throws JasperException {
            TagInfo tagInfo = n.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError((Node)n, "jsp.error.missing.tagInfo", n.getQName());
            }
            if (n.implementsSimpleTag() && tagInfo.getBodyContent().equals("JSP")) {
                this.err.jspError((Node)n, "jsp.error.simpletag.badbodycontent", tagInfo.getTagClassName());
            }
            if (tagInfo.hasDynamicAttributes() && !n.implementsDynamicAttributes()) {
                this.err.jspError((Node)n, "jsp.error.dynamic.attributes.not.implemented", n.getQName());
            }
            TagAttributeInfo[] tldAttrs = tagInfo.getAttributes();
            String customActionUri = n.getURI();
            Attributes attrs = n.getAttributes();
            int attrsSize = attrs == null ? 0 : attrs.getLength();
            for (int i = 0; i < tldAttrs.length; ++i) {
                String attr = null;
                if (attrs != null && (attr = attrs.getValue(tldAttrs[i].getName())) == null) {
                    attr = attrs.getValue(customActionUri, tldAttrs[i].getName());
                }
                Node.NamedAttribute na = n.getNamedAttributeNode(tldAttrs[i].getName());
                if (tldAttrs[i].isRequired() && attr == null && na == null) {
                    this.err.jspError((Node)n, "jsp.error.missing_attribute", tldAttrs[i].getName(), n.getLocalName());
                }
                if (attr == null || na == null) continue;
                this.err.jspError((Node)n, "jsp.error.duplicate.name.jspattribute", tldAttrs[i].getName());
            }
            Node.Nodes naNodes = n.getNamedAttributeNodes();
            int jspAttrsSize = naNodes.size() + attrsSize;
            Node.JspAttribute[] jspAttrs = null;
            if (jspAttrsSize > 0) {
                jspAttrs = new Node.JspAttribute[jspAttrsSize];
            }
            Hashtable<String, Object> tagDataAttrs = new Hashtable<String, Object>(attrsSize);
            this.checkXmlAttributes(n, jspAttrs, tagDataAttrs);
            this.checkNamedAttributes(n, jspAttrs, attrsSize, tagDataAttrs);
            TagData tagData = new TagData(tagDataAttrs);
            TagExtraInfo tei = tagInfo.getTagExtraInfo();
            if (tei != null && tei.getVariableInfo(tagData) != null && tei.getVariableInfo(tagData).length > 0 && tagInfo.getTagVariableInfos().length > 0) {
                this.err.jspError("jsp.error.non_null_tei_and_var_subelems", n.getQName());
            }
            n.setTagData(tagData);
            n.setJspAttributes(jspAttrs);
            this.visitBody(n);
        }

        public void visit(Node.JspElement n) throws JasperException {
            int i;
            Attributes attrs = n.getAttributes();
            if (attrs == null) {
                this.err.jspError(n, "jsp.error.jspelement.missing.name");
            }
            int xmlAttrLen = attrs.getLength();
            Node.Nodes namedAttrs = n.getNamedAttributeNodes();
            int jspAttrSize = xmlAttrLen - 1 + namedAttrs.size();
            Node.JspAttribute[] jspAttrs = new Node.JspAttribute[jspAttrSize];
            int jspAttrIndex = 0;
            for (i = 0; i < xmlAttrLen; ++i) {
                if ("name".equals(attrs.getLocalName(i))) {
                    n.setNameAttribute(this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), n, false, null));
                    continue;
                }
                if (jspAttrIndex >= jspAttrSize) continue;
                jspAttrs[jspAttrIndex++] = this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), n, false, null);
            }
            if (n.getNameAttribute() == null) {
                this.err.jspError(n, "jsp.error.jspelement.missing.name");
            }
            for (i = 0; i < namedAttrs.size(); ++i) {
                Node.NamedAttribute na = (Node.NamedAttribute)namedAttrs.getNode(i);
                jspAttrs[jspAttrIndex++] = new Node.JspAttribute(na, false);
            }
            n.setJspAttributes(jspAttrs);
            this.visitBody(n);
        }

        public void visit(Node.JspOutput n) throws JasperException {
            JspUtil.checkAttributes("jsp:output", n, jspOutputAttrs, this.err);
            if (n.getBody() != null) {
                this.err.jspError(n, "jsp.error.jspoutput.nonemptybody");
            }
            String omitXmlDecl = n.getAttributeValue("omit-xml-declaration");
            String doctypeName = n.getAttributeValue("doctype-root-element");
            String doctypePublic = n.getAttributeValue("doctype-public");
            String doctypeSystem = n.getAttributeValue("doctype-system");
            String omitXmlDeclOld = this.pageInfo.getOmitXmlDecl();
            String doctypeNameOld = this.pageInfo.getDoctypeName();
            String doctypePublicOld = this.pageInfo.getDoctypePublic();
            String doctypeSystemOld = this.pageInfo.getDoctypeSystem();
            if (omitXmlDecl != null && omitXmlDeclOld != null && !omitXmlDecl.equals(omitXmlDeclOld)) {
                this.err.jspError((Node)n, "jsp.error.jspoutput.conflict", "omit-xml-declaration", omitXmlDeclOld, omitXmlDecl);
            }
            if (doctypeName != null && doctypeNameOld != null && !doctypeName.equals(doctypeNameOld)) {
                this.err.jspError((Node)n, "jsp.error.jspoutput.conflict", "doctype-root-element", doctypeNameOld, doctypeName);
            }
            if (doctypePublic != null && doctypePublicOld != null && !doctypePublic.equals(doctypePublicOld)) {
                this.err.jspError((Node)n, "jsp.error.jspoutput.conflict", "doctype-public", doctypePublicOld, doctypePublic);
            }
            if (doctypeSystem != null && doctypeSystemOld != null && !doctypeSystem.equals(doctypeSystemOld)) {
                this.err.jspError((Node)n, "jsp.error.jspoutput.conflict", "doctype-system", doctypeSystemOld, doctypeSystem);
            }
            if (doctypeName == null && doctypeSystem != null || doctypeName != null && doctypeSystem == null) {
                this.err.jspError(n, "jsp.error.jspoutput.doctypenamesystem");
            }
            if (doctypePublic != null && doctypeSystem == null) {
                this.err.jspError(n, "jsp.error.jspoutput.doctypepulicsystem");
            }
            if (omitXmlDecl != null) {
                this.pageInfo.setOmitXmlDecl(omitXmlDecl);
            }
            if (doctypeName != null) {
                this.pageInfo.setDoctypeName(doctypeName);
            }
            if (doctypeSystem != null) {
                this.pageInfo.setDoctypeSystem(doctypeSystem);
            }
            if (doctypePublic != null) {
                this.pageInfo.setDoctypePublic(doctypePublic);
            }
        }

        public void visit(Node.InvokeAction n) throws JasperException {
            JspUtil.checkAttributes("Invoke", n, invokeAttrs, this.err);
            String scope = n.getTextAttribute("scope");
            JspUtil.checkScope(scope, n, this.err);
            String var = n.getTextAttribute("var");
            String varReader = n.getTextAttribute("varReader");
            if (scope != null && var == null && varReader == null) {
                this.err.jspError(n, "jsp.error.missing_var_or_varReader");
            }
            if (var != null && varReader != null) {
                this.err.jspError(n, "jsp.error.var_and_varReader");
            }
        }

        public void visit(Node.DoBodyAction n) throws JasperException {
            JspUtil.checkAttributes("DoBody", n, doBodyAttrs, this.err);
            String scope = n.getTextAttribute("scope");
            JspUtil.checkScope(scope, n, this.err);
            String var = n.getTextAttribute("var");
            String varReader = n.getTextAttribute("varReader");
            if (scope != null && var == null && varReader == null) {
                this.err.jspError(n, "jsp.error.missing_var_or_varReader");
            }
            if (var != null && varReader != null) {
                this.err.jspError(n, "jsp.error.var_and_varReader");
            }
        }

        private void checkSetter(Node.CustomTag n, TagAttributeInfo tldattr) throws JasperException {
            Class handler = n.getTagHandlerClass();
            if (handler == null) {
                return;
            }
            String handlerName = handler.getName();
            String property = tldattr.getName();
            Method setter = null;
            try {
                setter = JspRuntimeLibrary.getWriteMethod(handler, property);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (setter == null) {
                this.err.jspError((Node)n, "jsp.error.setter.none", handlerName, property);
            }
            Class<?> setterType = setter.getParameterTypes()[0];
            String typeName = setterType.getName();
            if (tldattr.isDeferredValue()) {
                if (tldattr.canBeRequestTime()) {
                    if (!"java.lang.Object".equals(typeName)) {
                        this.err.jspError((Node)n, "jsp.error.setter.notobject", handlerName, property);
                    }
                    return;
                }
                if (!"javax.el.ValueExpression".equals(typeName)) {
                    this.err.jspError((Node)n, "jsp.error.setter.notvalueexpression", handlerName, property);
                }
                return;
            }
            if (tldattr.isDeferredMethod()) {
                if (!"javax.el.MethodExpression".equals(typeName)) {
                    this.err.jspError((Node)n, "jsp.error.setter.notmethodexpression", handlerName, property);
                }
                return;
            }
        }

        private void checkXmlAttributes(Node.CustomTag n, Node.JspAttribute[] jspAttrs, Hashtable tagDataAttrs) throws JasperException {
            TagInfo tagInfo = n.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError((Node)n, "jsp.error.missing.tagInfo", n.getQName());
            }
            TagAttributeInfo[] tldAttrs = tagInfo.getAttributes();
            Attributes attrs = n.getAttributes();
            for (int i = 0; attrs != null && i < attrs.getLength(); ++i) {
                boolean found = false;
                for (int j = 0; tldAttrs != null && j < tldAttrs.length; ++j) {
                    if (!attrs.getLocalName(i).equals(tldAttrs[j].getName()) || attrs.getURI(i) != null && attrs.getURI(i).length() != 0 && !attrs.getURI(i).equals(n.getURI())) continue;
                    this.checkSetter(n, tldAttrs[j]);
                    if (tldAttrs[j].canBeRequestTime() || tldAttrs[j].isDeferredValue() || tldAttrs[j].isDeferredMethod()) {
                        jspAttrs[i] = this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), n, false, tldAttrs[j]);
                        ELNode.Nodes el = jspAttrs[i].getEL();
                        if (el != null) {
                            if (el.hasDollarExpression()) {
                                if (!tldAttrs[j].canBeRequestTime()) {
                                    this.err.jspError((Node)n, "jsp.error.el.deferred.dollar", tldAttrs[j].getName());
                                }
                            } else if (el.hasPoundExpression()) {
                                boolean isLiteral = this.pageInfo.isDeferredSyntaxAllowedAsLiteral();
                                if (!tldAttrs[j].isDeferredValue() && !tldAttrs[j].isDeferredMethod()) {
                                    if (n.getJspVersion() >= 2.1 && !isLiteral) {
                                        this.err.jspError((Node)n, "jsp.error.el.nondeferred.pound", tldAttrs[j].getName());
                                    } else {
                                        isLiteral = true;
                                    }
                                }
                                if (isLiteral) {
                                    jspAttrs[i].setValue(this.escapePound(jspAttrs[i].getValue()));
                                }
                            } else if (this.pageInfo.isDeferredSyntaxAllowedAsLiteral()) {
                                jspAttrs[i].setValue(this.escapePound(jspAttrs[i].getValue()));
                            }
                        }
                    } else {
                        String litAttr = this.getLiteral(n, attrs.getValue(i));
                        if (litAttr == null) {
                            this.err.jspError((Node)n, "jsp.error.attribute.custom.non_rt_with_expr", tldAttrs[j].getName());
                        }
                        jspAttrs[i] = new Node.JspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), litAttr, false, null, false);
                    }
                    if (jspAttrs[i].isExpression()) {
                        tagDataAttrs.put(attrs.getQName(i), TagData.REQUEST_TIME_VALUE);
                    } else {
                        tagDataAttrs.put(attrs.getQName(i), attrs.getValue(i));
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                if (tagInfo.hasDynamicAttributes()) {
                    jspAttrs[i] = this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), n, true, null);
                    continue;
                }
                this.err.jspError((Node)n, "jsp.error.bad_attribute", attrs.getQName(i), n.getLocalName());
            }
        }

        private void checkNamedAttributes(Node.CustomTag n, Node.JspAttribute[] jspAttrs, int start, Hashtable tagDataAttrs) throws JasperException {
            TagInfo tagInfo = n.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError((Node)n, "jsp.error.missing.tagInfo", n.getQName());
            }
            TagAttributeInfo[] tldAttrs = tagInfo.getAttributes();
            Node.Nodes naNodes = n.getNamedAttributeNodes();
            for (int i = 0; i < naNodes.size(); ++i) {
                Node.NamedAttribute na = (Node.NamedAttribute)naNodes.getNode(i);
                boolean found = false;
                for (int j = 0; j < tldAttrs.length; ++j) {
                    String attrPrefix = na.getPrefix();
                    if (!na.getLocalName().equals(tldAttrs[j].getName()) || attrPrefix != null && attrPrefix.length() != 0 && !attrPrefix.equals(n.getPrefix())) continue;
                    jspAttrs[start + i] = new Node.JspAttribute(na, false);
                    NamedAttributeVisitor nav = null;
                    if (na.getBody() != null) {
                        nav = new NamedAttributeVisitor();
                        na.getBody().visit(nav);
                    }
                    if (nav != null && nav.hasDynamicContent()) {
                        tagDataAttrs.put(na.getName(), TagData.REQUEST_TIME_VALUE);
                    } else {
                        tagDataAttrs.put(na.getName(), na.getText());
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                if (tagInfo.hasDynamicAttributes()) {
                    jspAttrs[start + i] = new Node.JspAttribute(na, true);
                    continue;
                }
                this.err.jspError((Node)n, "jsp.error.bad_attribute", na.getName(), n.getLocalName());
            }
        }

        private Node.JspAttribute getJspAttribute(String qName, String uri, String localName, String value, Node n, boolean dynamic, TagAttributeInfo tagAttr) throws JasperException {
            Node.JspAttribute result = null;
            if (value != null) {
                if (n.getRoot().isXmlSyntax() && value.startsWith("%=")) {
                    result = new Node.JspAttribute(qName, uri, localName, value.substring(2, value.length() - 1), true, null, dynamic);
                } else if (!n.getRoot().isXmlSyntax() && value.startsWith("<%=")) {
                    result = new Node.JspAttribute(qName, uri, localName, value.substring(3, value.length() - 2), true, null, dynamic);
                } else {
                    ELNode.Nodes el = ELParser.parse(value);
                    if (el.hasPoundExpression() && tagAttr == null && !dynamic) {
                        if (this.pageInfo.isELIgnored() || this.pageInfo.isDeferredSyntaxAllowedAsLiteral()) {
                            result = new Node.JspAttribute(qName, uri, localName, this.getLiteral(n, value), false, null, false);
                        } else {
                            this.err.jspError(n, "jsp.error.el.action.pound");
                        }
                    } else if (el.containsEL() && !this.pageInfo.isELIgnored() || tagAttr != null && (tagAttr.isDeferredValue() && !tagAttr.canBeRequestTime() || tagAttr.isDeferredMethod())) {
                        this.validateFunctions(el, n);
                        JspUtil.validateExpressions(n.getStart(), value, this.getFunctionMapper(el), this.err);
                        if (tagAttr != null && tagAttr.isDeferredValue()) {
                            String expectedType = tagAttr.getExpectedTypeName();
                            result = new Node.JspAttribute(qName, uri, localName, value, el, expectedType, null, null);
                        } else if (tagAttr != null && tagAttr.isDeferredMethod()) {
                            String methodSignature = tagAttr.getMethodSignature();
                            String returnType = this.getReturnType(methodSignature);
                            if (!el.containsEL()) {
                                try {
                                    Class typeClass = JspUtil.toClass(returnType, this.loader);
                                    JspUtil.coerce(typeClass, value);
                                }
                                catch (ClassNotFoundException ex) {
                                    this.err.jspError(n, "jsp.error.el.method.type", qName, returnType);
                                }
                                catch (Exception ex) {
                                    this.err.jspError(n, "jsp.error.el.method.literal", qName);
                                }
                            }
                            result = new Node.JspAttribute(qName, uri, localName, value, el, null, this.getReturnType(methodSignature), this.getParameters(methodSignature));
                        } else {
                            result = new Node.JspAttribute(qName, uri, localName, value, false, el, dynamic);
                        }
                    } else {
                        result = new Node.JspAttribute(qName, uri, localName, this.getLiteral(n, value), false, null, dynamic);
                    }
                }
            } else {
                Node.NamedAttribute namedAttributeNode = n.getNamedAttributeNode(qName);
                if (namedAttributeNode != null) {
                    result = new Node.JspAttribute(namedAttributeNode, dynamic);
                }
            }
            return result;
        }

        private String getLiteral(Node n, String value) {
            if (n.getRoot().isXmlSyntax() && value.startsWith("%=")) {
                return null;
            }
            if (!n.getRoot().isXmlSyntax() && value.startsWith("<%=")) {
                return null;
            }
            if (this.pageInfo.isELIgnored()) {
                return value;
            }
            boolean poundExpressionIgnored = n instanceof Node.CustomTag && (((Node.CustomTag)n).getJspVersion() < 2.1 || this.pageInfo.isDeferredSyntaxAllowedAsLiteral());
            int size = value.length();
            StringBuffer buf = new StringBuffer(size);
            char p = ' ';
            for (int i = 0; i < size; ++i) {
                char c = value.charAt(i);
                if (p == '$' && c == '{') {
                    return null;
                }
                if (p == '#' && c == '{' && !poundExpressionIgnored) {
                    return null;
                }
                if (p == '\\') {
                    if (c == '\\' || c == '$' || c == '#' && !poundExpressionIgnored) {
                        buf.append(c);
                        p = ' ';
                        continue;
                    }
                    buf.append(p).append(c);
                    p = c;
                    continue;
                }
                p = c;
                if (p == 92) continue;
                buf.append(c);
            }
            return buf.toString();
        }

        private void throwErrorIfExpression(Node n, String attrName, String actionName) throws JasperException {
            if (n.getAttributes() != null && n.getAttributes().getValue(attrName) != null && this.getLiteral(n, n.getAttributes().getValue(attrName)) == null) {
                this.err.jspError(n, "jsp.error.attribute.standard.non_rt_with_expr", attrName, actionName);
            }
        }

        private String escapePound(String value) {
            if (value.indexOf("#{") < 0) {
                return value;
            }
            StringBuffer buf = new StringBuffer(value.length() + 2);
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) == '#' && i + 1 < value.length() && value.charAt(i + 1) == '{') {
                    if (i - 1 >= 0 && value.charAt(i - 1) == '\\') {
                        buf.append('\\');
                    }
                    buf.append('\\');
                }
                buf.append(value.charAt(i));
            }
            return buf.toString();
        }

        private String findUri(String prefix, Node n) {
            for (Node p = n; p != null; p = p.getParent()) {
                Attributes attrs = p.getTaglibAttributes();
                if (attrs == null) continue;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String name = attrs.getQName(i);
                    int k = name.indexOf(58);
                    if (prefix == null && k < 0) {
                        return attrs.getValue(i);
                    }
                    if (prefix == null || k < 0 || !prefix.equals(name.substring(k + 1))) continue;
                    return attrs.getValue(i);
                }
            }
            return null;
        }

        private void validateFunctions(ELNode.Nodes el, Node n) throws JasperException {
            class FVVisitor
            extends ELNode.Visitor {
                Node n;

                FVVisitor(Node n) {
                    this.n = n;
                }

                public void visit(ELNode.Function func) throws JasperException {
                    String prefix = func.getPrefix();
                    String function = func.getName();
                    String uri = null;
                    if (this.n.getRoot().isXmlSyntax()) {
                        uri = ValidateVisitor.this.findUri(prefix, this.n);
                    } else if (prefix != null) {
                        uri = ValidateVisitor.this.pageInfo.getURI(prefix);
                    }
                    if (uri == null) {
                        if (prefix == null) {
                            ValidateVisitor.this.err.jspError(this.n, "jsp.error.noFunctionPrefix", function);
                        } else {
                            ValidateVisitor.this.err.jspError(this.n, "jsp.error.attribute.invalidPrefix", prefix);
                        }
                    }
                    TagLibraryInfo taglib = ValidateVisitor.this.pageInfo.getTaglib(uri);
                    FunctionInfo funcInfo = null;
                    if (taglib != null) {
                        funcInfo = taglib.getFunction(function);
                    }
                    if (funcInfo == null) {
                        ValidateVisitor.this.err.jspError(this.n, "jsp.error.noFunction", function);
                    }
                    func.setUri(uri);
                    func.setFunctionInfo(funcInfo);
                    ValidateVisitor.this.processSignature(func);
                }
            }
            el.visit(new FVVisitor(n));
        }

        private void processSignature(ELNode.Function func) throws JasperException {
            FunctionInfo funcInfo = func.getFunctionInfo();
            String signature = funcInfo.getFunctionSignature();
            func.setMethodName(this.getMethod(signature));
            func.setParameters(this.getParameters(signature));
        }

        private String getReturnType(String signature) throws JasperException {
            int start = signature.indexOf(32);
            if (start < 0) {
                this.err.jspError("jsp.error.tld.invalid.signature", signature);
            }
            return signature.substring(0, start);
        }

        private String getMethod(String signature) throws JasperException {
            int end;
            int start = signature.indexOf(32);
            if (start < 0) {
                this.err.jspError("jsp.error.tld.invalid.signature", signature);
            }
            if ((end = signature.indexOf(40)) < 0) {
                this.err.jspError("jsp.error.tld.invalid.signature", signature);
            }
            return signature.substring(start + 1, end).trim();
        }

        private String[] getParameters(String signature) throws JasperException {
            ArrayList<String> params = new ArrayList<String>();
            int start = signature.indexOf(40) + 1;
            boolean lastArg = false;
            while (true) {
                String arg;
                int p;
                if ((p = signature.indexOf(44, start)) < 0) {
                    p = signature.indexOf(41, start);
                    if (p < 0) {
                        this.err.jspError("jsp.error.tld.invalid.signature", signature);
                    }
                    lastArg = true;
                }
                if (!"".equals(arg = signature.substring(start, p).trim())) {
                    params.add(arg);
                }
                if (lastArg) break;
                start = p + 1;
            }
            return params.toArray(new String[params.size()]);
        }

        private FunctionMapper getFunctionMapper(ELNode.Nodes el) throws JasperException {
            class ValidateFunctionMapper
            extends FunctionMapper {
                private HashMap fnmap = new HashMap();

                ValidateFunctionMapper() {
                }

                public void mapFunction(String fnQName, Method method) {
                    this.fnmap.put(fnQName, method);
                }

                public Method resolveFunction(String prefix, String localName) {
                    return (Method)this.fnmap.get(prefix + ":" + localName);
                }
            }
            ValidateFunctionMapper fmapper = new ValidateFunctionMapper();
            class MapperELVisitor
            extends ELNode.Visitor {
                ValidateFunctionMapper fmapper;

                MapperELVisitor(ValidateFunctionMapper fmapper) {
                    this.fmapper = fmapper;
                }

                public void visit(ELNode.Function n) throws JasperException {
                    Class<?> c = null;
                    Method method = null;
                    try {
                        c = ValidateVisitor.this.loader.loadClass(n.getFunctionInfo().getFunctionClass());
                    }
                    catch (ClassNotFoundException e) {
                        ValidateVisitor.this.err.jspError("jsp.error.function.classnotfound", n.getFunctionInfo().getFunctionClass(), n.getPrefix() + ':' + n.getName(), e.getMessage());
                    }
                    String[] paramTypes = n.getParameters();
                    int size = paramTypes.length;
                    Class[] params = new Class[size];
                    int i = 0;
                    try {
                        for (i = 0; i < size; ++i) {
                            params[i] = JspUtil.toClass(paramTypes[i], ValidateVisitor.this.loader);
                        }
                        method = c.getDeclaredMethod(n.getMethodName(), params);
                    }
                    catch (ClassNotFoundException e) {
                        ValidateVisitor.this.err.jspError("jsp.error.signature.classnotfound", paramTypes[i], n.getPrefix() + ':' + n.getName(), e.getMessage());
                    }
                    catch (NoSuchMethodException e) {
                        ValidateVisitor.this.err.jspError("jsp.error.noFunctionMethod", n.getMethodName(), n.getName(), c.getName());
                    }
                    if (!Modifier.isPublic(method.getModifiers())) {
                        ValidateVisitor.this.err.jspError("jsp.error.nonPublicFunction", c.getName() + '.' + method.getName());
                    }
                    if (!Modifier.isStatic(method.getModifiers())) {
                        ValidateVisitor.this.err.jspError("jsp.error.nonStaticFunction", c.getName() + '.' + method.getName());
                    }
                    this.fmapper.mapFunction(n.getPrefix() + ':' + n.getName(), method);
                }
            }
            el.visit(new MapperELVisitor(fmapper));
            return fmapper;
        }

        private static class NamedAttributeVisitor
        extends Node.Visitor {
            private boolean hasDynamicContent;

            private NamedAttributeVisitor() {
            }

            public void doVisit(Node n) throws JasperException {
                if (!(n instanceof Node.JspText) && !(n instanceof Node.TemplateText)) {
                    this.hasDynamicContent = true;
                }
                this.visitBody(n);
            }

            public boolean hasDynamicContent() {
                return this.hasDynamicContent;
            }
        }
    }

    static class DirectiveVisitor
    extends Node.Visitor {
        private PageInfo pageInfo;
        private ErrorDispatcher err;
        private static final JspUtil.ValidAttribute[] pageDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("language"), new JspUtil.ValidAttribute("extends"), new JspUtil.ValidAttribute("import"), new JspUtil.ValidAttribute("session"), new JspUtil.ValidAttribute("buffer"), new JspUtil.ValidAttribute("autoFlush"), new JspUtil.ValidAttribute("isThreadSafe"), new JspUtil.ValidAttribute("info"), new JspUtil.ValidAttribute("errorPage"), new JspUtil.ValidAttribute("isErrorPage"), new JspUtil.ValidAttribute("contentType"), new JspUtil.ValidAttribute("pageEncoding"), new JspUtil.ValidAttribute("isELIgnored"), new JspUtil.ValidAttribute("deferredSyntaxAllowedAsLiteral"), new JspUtil.ValidAttribute("trimDirectiveWhitespaces")};
        private boolean pageEncodingSeen = false;

        DirectiveVisitor(Compiler compiler) throws JasperException {
            this.pageInfo = compiler.getPageInfo();
            this.err = compiler.getErrorDispatcher();
        }

        public void visit(Node.IncludeDirective n) throws JasperException {
            boolean pageEncodingSeenSave = this.pageEncodingSeen;
            this.pageEncodingSeen = false;
            this.visitBody(n);
            this.pageEncodingSeen = pageEncodingSeenSave;
        }

        public void visit(Node.PageDirective n) throws JasperException {
            JspUtil.checkAttributes("Page directive", n, pageDirectiveAttrs, this.err);
            Attributes attrs = n.getAttributes();
            for (int i = 0; attrs != null && i < attrs.getLength(); ++i) {
                String attr = attrs.getQName(i);
                String value = attrs.getValue(i);
                if ("language".equals(attr)) {
                    if (this.pageInfo.getLanguage(false) == null) {
                        this.pageInfo.setLanguage(value, n, this.err, true);
                        continue;
                    }
                    if (this.pageInfo.getLanguage(false).equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.language", this.pageInfo.getLanguage(false), value);
                    continue;
                }
                if ("extends".equals(attr)) {
                    if (this.pageInfo.getExtends(false) == null) {
                        this.pageInfo.setExtends(value, n);
                        continue;
                    }
                    if (this.pageInfo.getExtends(false).equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.extends", this.pageInfo.getExtends(false), value);
                    continue;
                }
                if ("contentType".equals(attr)) {
                    if (this.pageInfo.getContentType() == null) {
                        this.pageInfo.setContentType(value);
                        continue;
                    }
                    if (this.pageInfo.getContentType().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.contenttype", this.pageInfo.getContentType(), value);
                    continue;
                }
                if ("session".equals(attr)) {
                    if (this.pageInfo.getSession() == null) {
                        this.pageInfo.setSession(value, n, this.err);
                        continue;
                    }
                    if (this.pageInfo.getSession().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.session", this.pageInfo.getSession(), value);
                    continue;
                }
                if ("buffer".equals(attr)) {
                    if (this.pageInfo.getBufferValue() == null) {
                        this.pageInfo.setBufferValue(value, n, this.err);
                        continue;
                    }
                    if (this.pageInfo.getBufferValue().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.buffer", this.pageInfo.getBufferValue(), value);
                    continue;
                }
                if ("autoFlush".equals(attr)) {
                    if (this.pageInfo.getAutoFlush() == null) {
                        this.pageInfo.setAutoFlush(value, n, this.err);
                        continue;
                    }
                    if (this.pageInfo.getAutoFlush().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.autoflush", this.pageInfo.getAutoFlush(), value);
                    continue;
                }
                if ("isThreadSafe".equals(attr)) {
                    if (this.pageInfo.getIsThreadSafe() == null) {
                        this.pageInfo.setIsThreadSafe(value, n, this.err);
                        continue;
                    }
                    if (this.pageInfo.getIsThreadSafe().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.isthreadsafe", this.pageInfo.getIsThreadSafe(), value);
                    continue;
                }
                if ("isELIgnored".equals(attr)) {
                    if (this.pageInfo.getIsELIgnored() == null) {
                        this.pageInfo.setIsELIgnored(value, n, this.err, true);
                        continue;
                    }
                    if (this.pageInfo.getIsELIgnored().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.iselignored", this.pageInfo.getIsELIgnored(), value);
                    continue;
                }
                if ("isErrorPage".equals(attr)) {
                    if (this.pageInfo.getIsErrorPage() == null) {
                        this.pageInfo.setIsErrorPage(value, n, this.err);
                        continue;
                    }
                    if (this.pageInfo.getIsErrorPage().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.iserrorpage", this.pageInfo.getIsErrorPage(), value);
                    continue;
                }
                if ("errorPage".equals(attr)) {
                    if (this.pageInfo.getErrorPage() == null) {
                        this.pageInfo.setErrorPage(value);
                        continue;
                    }
                    if (this.pageInfo.getErrorPage().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.errorpage", this.pageInfo.getErrorPage(), value);
                    continue;
                }
                if ("info".equals(attr)) {
                    if (this.pageInfo.getInfo() == null) {
                        this.pageInfo.setInfo(value);
                        continue;
                    }
                    if (this.pageInfo.getInfo().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.info", this.pageInfo.getInfo(), value);
                    continue;
                }
                if ("pageEncoding".equals(attr)) {
                    if (this.pageEncodingSeen) {
                        this.err.jspError(n, "jsp.error.page.multi.pageencoding");
                    }
                    this.pageEncodingSeen = true;
                    this.comparePageEncodings(value, n);
                    continue;
                }
                if ("deferredSyntaxAllowedAsLiteral".equals(attr)) {
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral() == null) {
                        this.pageInfo.setDeferredSyntaxAllowedAsLiteral(value, n, this.err, true);
                        continue;
                    }
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.deferred", this.pageInfo.getDeferredSyntaxAllowedAsLiteral(), value);
                    continue;
                }
                if (!"trimDirectiveWhitespaces".equals(attr)) continue;
                if (this.pageInfo.getTrimDirectiveWhitespaces() == null) {
                    this.pageInfo.setTrimDirectiveWhitespaces(value, n, this.err, true);
                    continue;
                }
                if (this.pageInfo.getTrimDirectiveWhitespaces().equals(value)) continue;
                this.err.jspError((Node)n, "jsp.error.page.conflict.trim", this.pageInfo.getTrimDirectiveWhitespaces(), value);
            }
            if (this.pageInfo.getBuffer() == 0 && !this.pageInfo.isAutoFlush()) {
                this.err.jspError(n, "jsp.error.page.badCombo");
            }
            if (this.pageInfo.isErrorPage() && this.pageInfo.getErrorPage() != null) {
                String rootPath = this.pageInfo.getRootPath();
                String errorPath = this.pageInfo.getErrorPage();
                if (!errorPath.startsWith("/")) {
                    String baseRootPath = rootPath.substring(0, rootPath.lastIndexOf(47));
                    errorPath = baseRootPath + '/' + errorPath;
                }
                if (rootPath.equals(errorPath)) {
                    this.err.jspError((Node)n, "jsp.error.page.selfreferencing", rootPath);
                }
            }
            this.pageInfo.addImports(n.getImports());
        }

        public void visit(Node.TagDirective n) throws JasperException {
            Attributes attrs = n.getAttributes();
            for (int i = 0; attrs != null && i < attrs.getLength(); ++i) {
                String attr = attrs.getQName(i);
                String value = attrs.getValue(i);
                if ("language".equals(attr)) {
                    if (this.pageInfo.getLanguage(false) == null) {
                        this.pageInfo.setLanguage(value, n, this.err, false);
                        continue;
                    }
                    if (this.pageInfo.getLanguage(false).equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.tag.conflict.language", this.pageInfo.getLanguage(false), value);
                    continue;
                }
                if ("isELIgnored".equals(attr)) {
                    if (this.pageInfo.getIsELIgnored() == null) {
                        this.pageInfo.setIsELIgnored(value, n, this.err, false);
                        continue;
                    }
                    if (this.pageInfo.getIsELIgnored().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.tag.conflict.iselignored", this.pageInfo.getIsELIgnored(), value);
                    continue;
                }
                if ("pageEncoding".equals(attr)) {
                    if (this.pageEncodingSeen) {
                        this.err.jspError(n, "jsp.error.tag.multi.pageencoding");
                    }
                    this.pageEncodingSeen = true;
                    if (n.getRoot().hasBom()) {
                        String bom = n.getRoot().getPageEncoding();
                        if (!(value == null || value.equalsIgnoreCase(bom) || value.toLowerCase().startsWith("utf-16") && bom.toLowerCase().startsWith("utf-16"))) {
                            this.err.jspError((Node)n, "jsp.error.bom_tagdir_encoding_mismatch", bom, value);
                        }
                    }
                    n.getRoot().setPageEncoding(value);
                    continue;
                }
                if ("deferredSyntaxAllowedAsLiteral".equals(attr)) {
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral() == null) {
                        this.pageInfo.setDeferredSyntaxAllowedAsLiteral(value, n, this.err, false);
                        continue;
                    }
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.tag.conflict.deferred", this.pageInfo.getDeferredSyntaxAllowedAsLiteral(), value);
                    continue;
                }
                if (!"trimDirectiveWhitespaces".equals(attr)) continue;
                if (this.pageInfo.getTrimDirectiveWhitespaces() == null) {
                    this.pageInfo.setTrimDirectiveWhitespaces(value, n, this.err, false);
                    continue;
                }
                if (this.pageInfo.getTrimDirectiveWhitespaces().equals(value)) continue;
                this.err.jspError((Node)n, "jsp.error.tag.conflict.trim", this.pageInfo.getTrimDirectiveWhitespaces(), value);
            }
            this.pageInfo.addImports(n.getImports());
        }

        public void visit(Node.AttributeDirective n) throws JasperException {
        }

        public void visit(Node.VariableDirective n) throws JasperException {
        }

        private void comparePageEncodings(String pageDirEnc, Node.PageDirective pageDir) throws JasperException {
            String pageEnc;
            Node.Root root = pageDir.getRoot();
            String configEnc = root.getJspConfigPageEncoding();
            if (!(configEnc == null || pageDirEnc.equalsIgnoreCase(configEnc) || pageDirEnc.toLowerCase().startsWith("utf-16") && configEnc.toLowerCase().startsWith("utf-16"))) {
                this.err.jspError((Node)pageDir, "jsp.error.config_pagedir_encoding_mismatch", configEnc, pageDirEnc);
            }
            if (!(!root.isXmlSyntax() || !root.isEncodingSpecifiedInProlog() || pageDirEnc.equalsIgnoreCase(pageEnc = root.getPageEncoding()) || pageDirEnc.toLowerCase().startsWith("utf-16") && pageEnc.toLowerCase().startsWith("utf-16"))) {
                this.err.jspError((Node)pageDir, "jsp.error.prolog_pagedir_encoding_mismatch", pageEnc, pageDirEnc);
            }
            if (!(!root.hasBom() || pageDirEnc.equalsIgnoreCase(pageEnc = root.getPageEncoding()) || pageDirEnc.toLowerCase().startsWith("utf-16") && pageEnc.toLowerCase().startsWith("utf-16"))) {
                this.err.jspError((Node)pageDir, "jsp.error.bom_pagedir_encoding_mismatch", pageEnc, pageDirEnc);
            }
        }
    }
}

