/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.jets3t.service.model;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

public class MultipartPart {
    private final Integer partNumber;
    private final Date lastModified;
    private final String etag;
    private final Long size;

    public MultipartPart(Integer partNumber, Date lastModified, String etag, Long size) {
        if (partNumber == null) {
            throw new IllegalArgumentException("Null part number not allowed.");
        }
        if (lastModified == null) {
            throw new IllegalArgumentException("Null last modified not allowed.");
        }
        if (etag == null) {
            throw new IllegalArgumentException("Null etag not allowed.");
        }
        if (size == null) {
            throw new IllegalArgumentException("Null size not allowed.");
        }
        this.partNumber = partNumber;
        this.lastModified = lastModified;
        this.size = size;
        this.etag = etag.replaceAll("\"", "");
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MultipartPart) {
            MultipartPart p = (MultipartPart)other;
            return Arrays.equals(new Object[]{this.partNumber, this.lastModified, this.size}, new Object[]{p.partNumber, p.lastModified, p.size}) && this.sameEtag(p.etag);
        }
        return false;
    }

    private boolean sameEtag(String pEtag) {
        if (this.etag == pEtag) {
            return true;
        }
        if (this.etag == null) {
            return false;
        }
        return this.etag.equals(pEtag) || ("\"" + this.etag + "\"").equals(pEtag);
    }

    public String toString() {
        return this.getClass().getName() + " [" + "partNumber=" + this.getPartNumber() + ", lastModified=" + this.getLastModified() + ", etag=" + this.getEtag() + ", size=" + this.getSize() + "]";
    }

    public String getEtag() {
        return this.etag;
    }

    public Long getSize() {
        return this.size;
    }

    public Integer getPartNumber() {
        return this.partNumber;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PartNumberComparator
    implements Comparator<MultipartPart> {
        @Override
        public int compare(MultipartPart o1, MultipartPart o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getPartNumber().compareTo(o2.getPartNumber());
        }
    }
}

