/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.mortbay.jetty.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.Request;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.handler.HandlerWrapper;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.servlet.PathMap;
import org.apache.hadoop.hbase.shaded.org.mortbay.util.URIUtil;

public class RewriteHandler
extends HandlerWrapper {
    private boolean _rewriteRequestURI = true;
    private boolean _rewritePathInfo = true;
    private String _originalPathAttribute;
    private PathMap _rewrite = new PathMap(true);

    public boolean isRewriteRequestURI() {
        return this._rewriteRequestURI;
    }

    public void setRewriteRequestURI(boolean rewriteRequestURI) {
        this._rewriteRequestURI = rewriteRequestURI;
    }

    public boolean isRewritePathInfo() {
        return this._rewritePathInfo;
    }

    public void setRewritePathInfo(boolean rewritePathInfo) {
        this._rewritePathInfo = rewritePathInfo;
    }

    public String getOriginalPathAttribute() {
        return this._originalPathAttribute;
    }

    public void setOriginalPathAttribute(String originalPathAttribte) {
        this._originalPathAttribute = originalPathAttribte;
    }

    public PathMap getRewrite() {
        return this._rewrite;
    }

    public void setRewrite(PathMap rewrite) {
        this._rewrite = rewrite;
    }

    public void addRewriteRule(String pattern, String prefix) {
        if (pattern == null || pattern.length() == 0 || !pattern.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        if (this._rewrite == null) {
            this._rewrite = new PathMap(true);
        }
        this._rewrite.put(pattern, prefix);
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        PathMap.Entry rewrite;
        if (this.isStarted() && this._rewrite != null && (rewrite = this._rewrite.getMatch(target)) != null && rewrite.getValue() != null) {
            if (this._originalPathAttribute != null) {
                request.setAttribute(this._originalPathAttribute, target);
            }
            target = URIUtil.addPaths(rewrite.getValue().toString(), PathMap.pathInfo(rewrite.getKey().toString(), target));
            if (this._rewriteRequestURI) {
                ((Request)request).setRequestURI(target);
            }
            if (this._rewritePathInfo) {
                ((Request)request).setPathInfo(target);
            }
        }
        super.handle(target, request, response, dispatch);
    }
}

