/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWAL;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogReader;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.LeaseNotRecoveredException;
import org.apache.hadoop.hbase.wal.BoundedRegionGroupingProvider;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.DisabledWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;

@InterfaceAudience.Private
public class WALFactory {
    private static final Log LOG = LogFactory.getLog(WALFactory.class);
    public static final String WAL_PROVIDER = "hbase.wal.provider";
    static final String DEFAULT_WAL_PROVIDER = Providers.defaultProvider.name();
    static final String META_WAL_PROVIDER = "hbase.wal.meta_provider";
    static final String DEFAULT_META_WAL_PROVIDER = Providers.defaultProvider.name();
    final String factoryId;
    final WALProvider provider;
    final AtomicReference<WALProvider> metaProvider = new AtomicReference();
    private final Class<? extends DefaultWALProvider.Reader> logReaderClass;
    private final int timeoutMillis;
    private final Configuration conf;
    private static final AtomicReference<WALFactory> singleton = new AtomicReference();
    private static final String SINGLETON_ID = WALFactory.class.getName();

    private WALFactory(Configuration conf) {
        this.timeoutMillis = conf.getInt("hbase.hlog.open.timeout", 300000);
        this.logReaderClass = conf.getClass("hbase.regionserver.hlog.reader.impl", ProtobufLogReader.class, DefaultWALProvider.Reader.class);
        this.conf = conf;
        this.provider = null;
        this.factoryId = SINGLETON_ID;
    }

    WALProvider getProvider(String key, String defaultValue, List<WALActionsListener> listeners, String providerId) throws IOException {
        Class<? extends WALProvider> clazz;
        try {
            clazz = Providers.valueOf((String)this.conf.get((String)key, (String)defaultValue)).clazz;
        }
        catch (IllegalArgumentException exception) {
            clazz = this.conf.getClass(key, DefaultWALProvider.class, WALProvider.class);
        }
        LOG.info((Object)("Instantiating WALProvider of type " + clazz));
        try {
            WALProvider result = clazz.newInstance();
            result.init(this, this.conf, listeners, providerId);
            return result;
        }
        catch (InstantiationException exception) {
            LOG.error((Object)("couldn't set up WALProvider, check config key " + key));
            LOG.debug((Object)"Exception details for failure to load WALProvider.", (Throwable)exception);
            throw new IOException("couldn't set up WALProvider", exception);
        }
        catch (IllegalAccessException exception) {
            LOG.error((Object)("couldn't set up WALProvider, check config key " + key));
            LOG.debug((Object)"Exception details for failure to load WALProvider.", (Throwable)exception);
            throw new IOException("couldn't set up WALProvider", exception);
        }
    }

    public WALFactory(Configuration conf, List<WALActionsListener> listeners, String factoryId) throws IOException {
        this.timeoutMillis = conf.getInt("hbase.hlog.open.timeout", 300000);
        this.logReaderClass = conf.getClass("hbase.regionserver.hlog.reader.impl", ProtobufLogReader.class, DefaultWALProvider.Reader.class);
        this.conf = conf;
        this.factoryId = factoryId;
        if (conf.getBoolean("hbase.regionserver.hlog.enabled", true)) {
            this.provider = this.getProvider(WAL_PROVIDER, DEFAULT_WAL_PROVIDER, listeners, null);
        } else {
            LOG.warn((Object)"Running with WAL disabled.");
            this.provider = new DisabledWALProvider();
            this.provider.init(this, conf, null, factoryId);
        }
    }

    public void close() throws IOException {
        WALProvider metaProvider = this.metaProvider.get();
        if (null != metaProvider) {
            metaProvider.close();
        }
        if (null != this.provider) {
            this.provider.close();
        }
    }

    public void shutdown() throws IOException {
        IOException exception = null;
        WALProvider metaProvider = this.metaProvider.get();
        if (null != metaProvider) {
            try {
                metaProvider.shutdown();
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        this.provider.shutdown();
        if (null != exception) {
            throw exception;
        }
    }

    public WAL getWAL(byte[] identifier) throws IOException {
        return this.provider.getWAL(identifier);
    }

    public WAL getMetaWAL(byte[] identifier) throws IOException {
        WALProvider metaProvider = this.metaProvider.get();
        if (null == metaProvider) {
            WALProvider temp = this.getProvider(META_WAL_PROVIDER, DEFAULT_META_WAL_PROVIDER, Collections.singletonList(new MetricsWAL()), ".meta");
            if (this.metaProvider.compareAndSet(null, temp)) {
                metaProvider = temp;
            } else {
                temp.close();
                metaProvider = this.metaProvider.get();
            }
        }
        return metaProvider.getWAL(identifier);
    }

    public WAL.Reader createReader(FileSystem fs, Path path) throws IOException {
        return this.createReader(fs, path, null);
    }

    public WAL.Reader createReader(FileSystem fs, Path path, CancelableProgressable reporter) throws IOException {
        return this.createReader(fs, path, reporter, true);
    }

    public WAL.Reader createReader(FileSystem fs, Path path, CancelableProgressable reporter, boolean allowCustom) throws IOException {
        Class lrClass = allowCustom ? this.logReaderClass : ProtobufLogReader.class;
        try {
            long startWaiting = EnvironmentEdgeManager.currentTime();
            long openTimeout = (long)this.timeoutMillis + startWaiting;
            int nbAttempt = 0;
            FSDataInputStream stream = null;
            DefaultWALProvider.Reader reader = null;
            while (true) {
                try {
                    byte[] magic;
                    if (lrClass != ProtobufLogReader.class) {
                        reader = (DefaultWALProvider.Reader)lrClass.newInstance();
                        reader.init(fs, path, this.conf, null);
                        return reader;
                    }
                    stream = fs.open(path);
                    boolean isPbWal = stream.read(magic = new byte[ProtobufLogReader.PB_WAL_MAGIC.length]) == magic.length && Arrays.equals(magic, ProtobufLogReader.PB_WAL_MAGIC);
                    reader = isPbWal ? new ProtobufLogReader() : new SequenceFileLogReader();
                    reader.init(fs, path, this.conf, stream);
                    return reader;
                }
                catch (IOException e) {
                    String msg;
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException exception) {
                            LOG.warn((Object)("Could not close DefaultWALProvider.Reader" + exception.getMessage()));
                            LOG.debug((Object)"exception details", (Throwable)exception);
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException exception) {
                            LOG.warn((Object)("Could not close FSDataInputStream" + exception.getMessage()));
                            LOG.debug((Object)"exception details", (Throwable)exception);
                        }
                    }
                    if ((msg = e.getMessage()) != null && (msg.contains("Cannot obtain block length") || msg.contains("Could not obtain the last block") || msg.matches("Blocklist for [^ ]* has changed.*"))) {
                        if (++nbAttempt == 1) {
                            LOG.warn((Object)"Lease should have recovered. This is not expected. Will retry", (Throwable)e);
                        }
                        if (reporter != null && !reporter.progress()) {
                            throw new InterruptedIOException("Operation is cancelled");
                        }
                        if (nbAttempt <= 2 || openTimeout >= EnvironmentEdgeManager.currentTime()) {
                            try {
                                Thread.sleep(nbAttempt < 3 ? 500L : 1000L);
                            }
                            catch (InterruptedException ie) {
                                InterruptedIOException iioe = new InterruptedIOException();
                                iioe.initCause(ie);
                                throw iioe;
                            }
                            continue;
                        }
                        LOG.error((Object)("Can't open after " + nbAttempt + " attempts and " + (EnvironmentEdgeManager.currentTime() - startWaiting) + "ms " + " for " + path));
                        throw new LeaseNotRecoveredException(e);
                    }
                    throw e;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new IOException("Cannot get log reader", e);
        }
    }

    public WALProvider.Writer createWALWriter(FileSystem fs, Path path) throws IOException {
        return DefaultWALProvider.createWriter(this.conf, fs, path, false);
    }

    @VisibleForTesting
    public WALProvider.Writer createRecoveredEditsWriter(FileSystem fs, Path path) throws IOException {
        return DefaultWALProvider.createWriter(this.conf, fs, path, true);
    }

    public static WALFactory getInstance(Configuration configuration) {
        WALFactory factory = singleton.get();
        if (null == factory) {
            WALFactory temp = new WALFactory(configuration);
            if (singleton.compareAndSet(null, temp)) {
                factory = temp;
            } else {
                try {
                    temp.close();
                }
                catch (IOException exception) {
                    LOG.debug((Object)"failed to close temporary singleton. ignoring.", (Throwable)exception);
                }
                factory = singleton.get();
            }
        }
        return factory;
    }

    public static WAL.Reader createReader(FileSystem fs, Path path, Configuration configuration) throws IOException {
        return WALFactory.getInstance(configuration).createReader(fs, path);
    }

    static WAL.Reader createReader(FileSystem fs, Path path, Configuration configuration, CancelableProgressable reporter) throws IOException {
        return WALFactory.getInstance(configuration).createReader(fs, path, reporter);
    }

    public static WAL.Reader createReaderIgnoreCustomClass(FileSystem fs, Path path, Configuration configuration) throws IOException {
        return WALFactory.getInstance(configuration).createReader(fs, path, null, false);
    }

    static WALProvider.Writer createRecoveredEditsWriter(FileSystem fs, Path path, Configuration configuration) throws IOException {
        return DefaultWALProvider.createWriter(configuration, fs, path, true);
    }

    @VisibleForTesting
    public static WALProvider.Writer createWALWriter(FileSystem fs, Path path, Configuration configuration) throws IOException {
        return DefaultWALProvider.createWriter(configuration, fs, path, false);
    }

    static enum Providers {
        defaultProvider(DefaultWALProvider.class),
        filesystem(DefaultWALProvider.class),
        multiwal(BoundedRegionGroupingProvider.class);

        Class<? extends WALProvider> clazz;

        private Providers(Class<? extends WALProvider> clazz) {
            this.clazz = clazz;
        }
    }
}

