/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.CheckpointFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class ImageServlet
extends HttpServlet {
    public static final String PATH_SPEC = "/imagetransfer";
    private static final long serialVersionUID = -7669068179452648952L;
    private static final Log LOG = LogFactory.getLog(ImageServlet.class);
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HADOOP_IMAGE_EDITS_HEADER = "X-Image-Edits-Name";
    private static final String TXID_PARAM = "txid";
    private static final String START_TXID_PARAM = "startTxId";
    private static final String END_TXID_PARAM = "endTxId";
    private static final String STORAGEINFO_PARAM = "storageInfo";
    private static final String LATEST_FSIMAGE_VALUE = "latest";
    private static final String IMAGE_FILE_TYPE = "imageFile";
    private static final Set<Long> currentlyDownloadingCheckpoints = Collections.synchronizedSet(new HashSet());

    @Override
    public void doGet(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        try {
            ServletContext context = this.getServletContext();
            final FSImage nnImage = NameNodeHttpServer.getFsImageFromContext(context);
            final GetImageParams parsedParams = new GetImageParams(request, response);
            final Configuration conf = (Configuration)context.getAttribute("current.conf");
            final NameNodeMetrics metrics = NameNode.getNameNodeMetrics();
            this.validateRequest(context, conf, request, response, nnImage, parsedParams.getStorageInfoString());
            UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    if (parsedParams.isGetImage()) {
                        long txid = parsedParams.getTxId();
                        File imageFile = null;
                        String errorMessage = "Could not find image";
                        if (parsedParams.shouldFetchLatest()) {
                            imageFile = nnImage.getStorage().getHighestFsImageName();
                        } else {
                            errorMessage = errorMessage + " with txid " + txid;
                            imageFile = nnImage.getStorage().getFsImage(txid, EnumSet.of(NNStorage.NameNodeFile.IMAGE, NNStorage.NameNodeFile.IMAGE_ROLLBACK));
                        }
                        if (imageFile == null) {
                            throw new IOException(errorMessage);
                        }
                        CheckpointFaultInjector.getInstance().beforeGetImageSetsHeaders();
                        long start = Time.monotonicNow();
                        this.serveFile(imageFile);
                        if (metrics != null) {
                            long elapsed = Time.monotonicNow() - start;
                            metrics.addGetImage(elapsed);
                        }
                    } else if (parsedParams.isGetEdit()) {
                        long startTxId = parsedParams.getStartTxId();
                        long endTxId = parsedParams.getEndTxId();
                        File editFile = nnImage.getStorage().findFinalizedEditsFile(startTxId, endTxId);
                        long start = Time.monotonicNow();
                        this.serveFile(editFile);
                        if (metrics != null) {
                            long elapsed = Time.monotonicNow() - start;
                            metrics.addGetEdit(elapsed);
                        }
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void serveFile(File file) throws IOException {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        ImageServlet.setVerificationHeadersForGet(response, file);
                        ImageServlet.setFileNameHeaders(response, file);
                        if (!file.exists()) {
                            throw new FileNotFoundException(file.toString());
                        }
                        TransferFsImage.copyFileToStream(response.getOutputStream(), file, fis, ImageServlet.getThrottler(conf));
                    }
                    finally {
                        IOUtils.closeStream(fis);
                    }
                }
            });
        }
        catch (Throwable t) {
            String errMsg = "GetImage failed. " + StringUtils.stringifyException(t);
            response.sendError(410, errMsg);
            throw new IOException(errMsg);
        }
        finally {
            response.getOutputStream().close();
        }
    }

    private void validateRequest(ServletContext context, Configuration conf, HttpServletRequest request, HttpServletResponse response, FSImage nnImage, String theirStorageInfoString) throws IOException {
        if (UserGroupInformation.isSecurityEnabled() && !ImageServlet.isValidRequestor(context, request.getUserPrincipal().getName(), conf)) {
            String errorMsg = "Only Namenode, Secondary Namenode, and administrators may access this servlet";
            response.sendError(403, errorMsg);
            LOG.warn((Object)("Received non-NN/SNN/administrator request for image or edits from " + request.getUserPrincipal().getName() + " at " + request.getRemoteHost()));
            throw new IOException(errorMsg);
        }
        String myStorageInfoString = nnImage.getStorage().toColonSeparatedString();
        if (theirStorageInfoString != null && !myStorageInfoString.equals(theirStorageInfoString)) {
            String errorMsg = "This namenode has storage info " + myStorageInfoString + " but the secondary expected " + theirStorageInfoString;
            response.sendError(403, errorMsg);
            LOG.warn((Object)("Received an invalid request file transfer request from a secondary with storage info " + theirStorageInfoString));
            throw new IOException(errorMsg);
        }
    }

    public static void setFileNameHeaders(HttpServletResponse response, File file) {
        response.setHeader(CONTENT_DISPOSITION, "attachment; filename=" + file.getName());
        response.setHeader(HADOOP_IMAGE_EDITS_HEADER, file.getName());
    }

    public static final DataTransferThrottler getThrottler(Configuration conf) {
        long transferBandwidth = conf.getLong("dfs.image.transfer.bandwidthPerSec", 0L);
        DataTransferThrottler throttler = null;
        if (transferBandwidth > 0L) {
            throttler = new DataTransferThrottler(transferBandwidth);
        }
        return throttler;
    }

    @VisibleForTesting
    static boolean isValidRequestor(ServletContext context, String remoteUser, Configuration conf) throws IOException {
        if (remoteUser == null) {
            LOG.warn((Object)"Received null remoteUser while authorizing access to getImage servlet");
            return false;
        }
        HashSet<String> validRequestors = new HashSet<String>();
        validRequestors.add(SecurityUtil.getServerPrincipal(conf.get("dfs.namenode.kerberos.principal"), NameNode.getAddress(conf).getHostName()));
        validRequestors.add(SecurityUtil.getServerPrincipal(conf.get("dfs.secondary.namenode.kerberos.principal"), SecondaryNameNode.getHttpAddress(conf).getHostName()));
        if (HAUtil.isHAEnabled(conf, DFSUtil.getNamenodeNameServiceId(conf))) {
            Configuration otherNnConf = HAUtil.getConfForOtherNode(conf);
            validRequestors.add(SecurityUtil.getServerPrincipal(otherNnConf.get("dfs.namenode.kerberos.principal"), NameNode.getAddress(otherNnConf).getHostName()));
        }
        for (String v : validRequestors) {
            if (v == null || !v.equals(remoteUser)) continue;
            LOG.info((Object)("ImageServlet allowing checkpointer: " + remoteUser));
            return true;
        }
        if (HttpServer2.userHasAdministratorAccess(context, remoteUser)) {
            LOG.info((Object)("ImageServlet allowing administrator: " + remoteUser));
            return true;
        }
        LOG.info((Object)("ImageServlet rejecting: " + remoteUser));
        return false;
    }

    public static void setVerificationHeadersForGet(HttpServletResponse response, File file) throws IOException {
        response.setHeader("Content-Length", String.valueOf(file.length()));
        MD5Hash hash = MD5FileUtils.readStoredMd5ForFile(file);
        if (hash != null) {
            response.setHeader("X-MD5-Digest", hash.toString());
        }
    }

    static String getParamStringForMostRecentImage() {
        return "getimage=1&txid=latest";
    }

    static String getParamStringForImage(NNStorage.NameNodeFile nnf, long txid, StorageInfo remoteStorageInfo) {
        String imageType = nnf == null ? "" : "&imageFile=" + nnf.name();
        return "getimage=1&txid=" + txid + imageType + "&" + STORAGEINFO_PARAM + "=" + remoteStorageInfo.toColonSeparatedString();
    }

    static String getParamStringForLog(RemoteEditLog log, StorageInfo remoteStorageInfo) {
        return "getedit=1&startTxId=" + log.getStartTxId() + "&" + END_TXID_PARAM + "=" + log.getEndTxId() + "&" + STORAGEINFO_PARAM + "=" + remoteStorageInfo.toColonSeparatedString();
    }

    static void setVerificationHeadersForPut(HttpURLConnection connection, File file) throws IOException {
        connection.setRequestProperty("Content-Length", String.valueOf(file.length()));
        MD5Hash hash = MD5FileUtils.readStoredMd5ForFile(file);
        if (hash != null) {
            connection.setRequestProperty("X-MD5-Digest", hash.toString());
        }
    }

    static Map<String, String> getParamsForPutImage(Storage storage, long txid, long imageFileSize, NNStorage.NameNodeFile nnf) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(TXID_PARAM, Long.toString(txid));
        params.put(STORAGEINFO_PARAM, storage.toColonSeparatedString());
        params.put("File-Length", Long.toString(imageFileSize));
        params.put(IMAGE_FILE_TYPE, nnf.name());
        return params;
    }

    @Override
    protected void doPut(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        try {
            ServletContext context = this.getServletContext();
            final FSImage nnImage = NameNodeHttpServer.getFsImageFromContext(context);
            final Configuration conf = (Configuration)this.getServletContext().getAttribute("current.conf");
            final PutImageParams parsedParams = new PutImageParams(request, response, conf);
            final NameNodeMetrics metrics = NameNode.getNameNodeMetrics();
            this.validateRequest(context, conf, request, response, nnImage, parsedParams.getStorageInfoString());
            UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    long txid = parsedParams.getTxId();
                    NNStorage.NameNodeFile nnf = parsedParams.getNameNodeFile();
                    if (!currentlyDownloadingCheckpoints.add(txid)) {
                        response.sendError(409, "Another checkpointer is already in the process of uploading a checkpoint made at transaction ID " + txid);
                        return null;
                    }
                    try {
                        if (nnImage.getStorage().findImageFile(nnf, txid) != null) {
                            response.sendError(409, "Another checkpointer already uploaded an checkpoint for txid " + txid);
                            Void void_ = null;
                            return void_;
                        }
                        ServletInputStream stream = request.getInputStream();
                        try {
                            long start = Time.monotonicNow();
                            MD5Hash downloadImageDigest = TransferFsImage.handleUploadImageRequest(request, txid, nnImage.getStorage(), stream, parsedParams.getFileSize(), ImageServlet.getThrottler(conf));
                            nnImage.saveDigestAndRenameCheckpointImage(nnf, txid, downloadImageDigest);
                            if (metrics != null) {
                                long elapsed = Time.monotonicNow() - start;
                                metrics.addPutImage(elapsed);
                            }
                            nnImage.purgeOldStorage(nnf);
                        }
                        finally {
                            stream.close();
                        }
                    }
                    finally {
                        currentlyDownloadingCheckpoints.remove(txid);
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            String errMsg = "PutImage failed. " + StringUtils.stringifyException(t);
            response.sendError(410, errMsg);
            throw new IOException(errMsg);
        }
    }

    static class PutImageParams {
        private long txId = -1L;
        private String storageInfoString = null;
        private long fileSize = 0L;
        private NNStorage.NameNodeFile nnf;

        public PutImageParams(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws IOException {
            this.txId = ServletUtil.parseLongParam(request, ImageServlet.TXID_PARAM);
            this.storageInfoString = ServletUtil.getParameter(request, ImageServlet.STORAGEINFO_PARAM);
            this.fileSize = ServletUtil.parseLongParam(request, "File-Length");
            String imageType = ServletUtil.getParameter(request, ImageServlet.IMAGE_FILE_TYPE);
            NNStorage.NameNodeFile nameNodeFile = this.nnf = imageType == null ? NNStorage.NameNodeFile.IMAGE : NNStorage.NameNodeFile.valueOf(imageType);
            if (this.fileSize == 0L || this.txId == -1L || this.storageInfoString == null || this.storageInfoString.isEmpty()) {
                throw new IOException("Illegal parameters to TransferFsImage");
            }
        }

        public long getTxId() {
            return this.txId;
        }

        public String getStorageInfoString() {
            return this.storageInfoString;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public NNStorage.NameNodeFile getNameNodeFile() {
            return this.nnf;
        }
    }

    static class GetImageParams {
        private boolean isGetImage;
        private boolean isGetEdit;
        private NNStorage.NameNodeFile nnf;
        private long startTxId;
        private long endTxId;
        private long txId;
        private String storageInfoString;
        private boolean fetchLatest;

        public GetImageParams(HttpServletRequest request, HttpServletResponse response) throws IOException {
            Map pmap = request.getParameterMap();
            this.fetchLatest = false;
            this.isGetEdit = false;
            this.isGetImage = false;
            for (Map.Entry entry : pmap.entrySet()) {
                String key = (String)entry.getKey();
                String[] val = (String[])entry.getValue();
                if (key.equals("getimage")) {
                    this.isGetImage = true;
                    try {
                        this.txId = ServletUtil.parseLongParam(request, ImageServlet.TXID_PARAM);
                        String imageType = ServletUtil.getParameter(request, ImageServlet.IMAGE_FILE_TYPE);
                        this.nnf = imageType == null ? NNStorage.NameNodeFile.IMAGE : NNStorage.NameNodeFile.valueOf(imageType);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        if (request.getParameter(ImageServlet.TXID_PARAM).equals(ImageServlet.LATEST_FSIMAGE_VALUE)) {
                            this.fetchLatest = true;
                            continue;
                        }
                        throw nfe;
                    }
                }
                if (key.equals("getedit")) {
                    this.isGetEdit = true;
                    this.startTxId = ServletUtil.parseLongParam(request, ImageServlet.START_TXID_PARAM);
                    this.endTxId = ServletUtil.parseLongParam(request, ImageServlet.END_TXID_PARAM);
                    continue;
                }
                if (!key.equals(ImageServlet.STORAGEINFO_PARAM)) continue;
                this.storageInfoString = val[0];
            }
            int numGets = (this.isGetImage ? 1 : 0) + (this.isGetEdit ? 1 : 0);
            if (numGets > 1 || numGets == 0) {
                throw new IOException("Illegal parameters to TransferFsImage");
            }
        }

        public String getStorageInfoString() {
            return this.storageInfoString;
        }

        public long getTxId() {
            Preconditions.checkState(this.isGetImage);
            return this.txId;
        }

        public NNStorage.NameNodeFile getNameNodeFile() {
            Preconditions.checkState(this.isGetImage);
            return this.nnf;
        }

        public long getStartTxId() {
            Preconditions.checkState(this.isGetEdit);
            return this.startTxId;
        }

        public long getEndTxId() {
            Preconditions.checkState(this.isGetEdit);
            return this.endTxId;
        }

        boolean isGetEdit() {
            return this.isGetEdit;
        }

        boolean isGetImage() {
            return this.isGetImage;
        }

        boolean shouldFetchLatest() {
            return this.fetchLatest;
        }
    }
}

