/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.security.AccessControlException;

@InterfaceAudience.Private
public class XAttrPermissionFilter {
    static void checkPermissionForApi(FSPermissionChecker pc, XAttr xAttr) throws AccessControlException {
        if (xAttr.getNameSpace() == XAttr.NameSpace.USER || xAttr.getNameSpace() == XAttr.NameSpace.TRUSTED && pc.isSuperUser()) {
            return;
        }
        throw new AccessControlException("User doesn't have permission for xattr: " + XAttrHelper.getPrefixName(xAttr));
    }

    static void checkPermissionForApi(FSPermissionChecker pc, List<XAttr> xAttrs) throws AccessControlException {
        Preconditions.checkArgument(xAttrs != null);
        if (xAttrs.isEmpty()) {
            return;
        }
        for (XAttr xAttr : xAttrs) {
            XAttrPermissionFilter.checkPermissionForApi(pc, xAttr);
        }
    }

    static List<XAttr> filterXAttrsForApi(FSPermissionChecker pc, List<XAttr> xAttrs) {
        assert (xAttrs != null) : "xAttrs can not be null";
        if (xAttrs == null || xAttrs.isEmpty()) {
            return xAttrs;
        }
        ArrayList<XAttr> filteredXAttrs = Lists.newArrayListWithCapacity(xAttrs.size());
        for (XAttr xAttr : xAttrs) {
            if (xAttr.getNameSpace() == XAttr.NameSpace.USER) {
                filteredXAttrs.add(xAttr);
                continue;
            }
            if (xAttr.getNameSpace() != XAttr.NameSpace.TRUSTED || !pc.isSuperUser()) continue;
            filteredXAttrs.add(xAttr);
        }
        return filteredXAttrs;
    }
}

