/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.hbase.shaded.com.yammer.metrics.stats.ExponentiallyDecayingSample;
import org.apache.hadoop.hbase.shaded.com.yammer.metrics.stats.Sample;
import org.apache.hadoop.hbase.shaded.com.yammer.metrics.stats.Snapshot;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableMetric;

@InterfaceAudience.Private
public class MutableHistogram
extends MutableMetric
implements MetricHistogram {
    private static final int DEFAULT_SAMPLE_SIZE = 2046;
    private static final double DEFAULT_ALPHA = 0.015;
    protected final String name;
    protected final String desc;
    private final Sample sample;
    private final AtomicLong min;
    private final AtomicLong max;
    private final AtomicLong sum;
    private final AtomicLong count;
    private boolean metricsInfoStringInited = false;
    private String NUM_OPS_METRIC;
    private String MIN_METRIC;
    private String MAX_METRIC;
    private String MEAN_METRIC;
    private String MEDIAN_METRIC;
    private String SEVENTY_FIFTH_PERCENTILE_METRIC;
    private String NINETIETH_PERCENTILE_METRIC;
    private String NINETY_FIFTH_PERCENTILE_METRIC;
    private String NINETY_NINETH_PERCENTILE_METRIC;

    public MutableHistogram(MetricsInfo info) {
        this(info.name(), info.description());
    }

    public MutableHistogram(String name, String description) {
        this.name = StringUtils.capitalize(name);
        this.desc = StringUtils.uncapitalize(description);
        this.sample = new ExponentiallyDecayingSample(2046, 0.015);
        this.count = new AtomicLong();
        this.min = new AtomicLong(Long.MAX_VALUE);
        this.max = new AtomicLong(Long.MIN_VALUE);
        this.sum = new AtomicLong();
    }

    @Override
    public void add(long val) {
        this.setChanged();
        this.count.incrementAndGet();
        this.sample.update(val);
        this.setMax(val);
        this.setMin(val);
        this.sum.getAndAdd(val);
    }

    private void setMax(long potentialMax) {
        boolean done = false;
        while (!done) {
            long currentMax = this.max.get();
            done = currentMax >= potentialMax || this.max.compareAndSet(currentMax, potentialMax);
        }
    }

    private void setMin(long potentialMin) {
        boolean done = false;
        while (!done) {
            long currentMin = this.min.get();
            done = currentMin <= potentialMin || this.min.compareAndSet(currentMin, potentialMin);
        }
    }

    public long getMax() {
        if (this.count.get() > 0L) {
            return this.max.get();
        }
        return 0L;
    }

    public long getMin() {
        if (this.count.get() > 0L) {
            return this.min.get();
        }
        return 0L;
    }

    public double getMean() {
        long cCount = this.count.get();
        if (cCount > 0L) {
            return (double)this.sum.get() / (double)cCount;
        }
        return 0.0;
    }

    @Override
    public void snapshot(MetricsRecordBuilder metricsRecordBuilder, boolean all) {
        if (all || this.changed()) {
            this.clearChanged();
            this.updateSnapshotMetrics(metricsRecordBuilder);
        }
    }

    public void updateSnapshotMetrics(MetricsRecordBuilder metricsRecordBuilder) {
        Snapshot s = this.sample.getSnapshot();
        if (!this.metricsInfoStringInited) {
            this.NUM_OPS_METRIC = this.name + "_num_ops";
            this.MIN_METRIC = this.name + "_min";
            this.MAX_METRIC = this.name + "_max";
            this.MEAN_METRIC = this.name + "_mean";
            this.MEDIAN_METRIC = this.name + "_median";
            this.SEVENTY_FIFTH_PERCENTILE_METRIC = this.name + "_75th_percentile";
            this.NINETIETH_PERCENTILE_METRIC = this.name + "_90th_percentile";
            this.NINETY_FIFTH_PERCENTILE_METRIC = this.name + "_95th_percentile";
            this.NINETY_NINETH_PERCENTILE_METRIC = this.name + "_99th_percentile";
            this.metricsInfoStringInited = true;
        }
        metricsRecordBuilder.addCounter(Interns.info(this.NUM_OPS_METRIC, this.desc), this.count.get());
        metricsRecordBuilder.addGauge(Interns.info(this.MIN_METRIC, this.desc), this.getMin());
        metricsRecordBuilder.addGauge(Interns.info(this.MAX_METRIC, this.desc), this.getMax());
        metricsRecordBuilder.addGauge(Interns.info(this.MEAN_METRIC, this.desc), this.getMean());
        metricsRecordBuilder.addGauge(Interns.info(this.MEDIAN_METRIC, this.desc), s.getMedian());
        metricsRecordBuilder.addGauge(Interns.info(this.SEVENTY_FIFTH_PERCENTILE_METRIC, this.desc), s.get75thPercentile());
        metricsRecordBuilder.addGauge(Interns.info(this.NINETIETH_PERCENTILE_METRIC, this.desc), s.getValue(0.9));
        metricsRecordBuilder.addGauge(Interns.info(this.NINETY_FIFTH_PERCENTILE_METRIC, this.desc), s.get95thPercentile());
        metricsRecordBuilder.addGauge(Interns.info(this.NINETY_NINETH_PERCENTILE_METRIC, this.desc), s.get99thPercentile());
    }
}

