/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.decode;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.SettableSequenceId;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class PrefixTreeCell
implements Cell,
SettableSequenceId,
Comparable<Cell> {
    public static final KeyValue.Type[] TYPES = new KeyValue.Type[256];
    public static final KeyValue.Type DEFAULT_TYPE;
    protected byte[] block;
    protected boolean includeMvccVersion;
    protected byte[] rowBuffer;
    protected int rowLength;
    protected byte[] familyBuffer;
    protected int familyOffset;
    protected int familyLength;
    protected byte[] qualifierBuffer;
    protected int qualifierOffset;
    protected int qualifierLength;
    protected Long timestamp;
    protected Long mvccVersion;
    protected KeyValue.Type type;
    protected int absoluteValueOffset;
    protected int valueLength;
    protected byte[] tagsBuffer;
    protected int tagsOffset;
    protected int tagsLength;

    public String toString() {
        return this.getKeyValueString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cell)) {
            return false;
        }
        return CellComparator.equalsIgnoreMvccVersion(this, (Cell)obj);
    }

    public int hashCode() {
        return CellComparator.hashCodeIgnoreMvcc(this);
    }

    @Override
    public int compareTo(Cell other) {
        return CellComparator.compare(this, other, false);
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getMvccVersion() {
        if (!this.includeMvccVersion) {
            return 0L;
        }
        return this.mvccVersion;
    }

    @Override
    public long getSequenceId() {
        return this.getMvccVersion();
    }

    @Override
    public int getValueLength() {
        return this.valueLength;
    }

    @Override
    public byte[] getRowArray() {
        return this.rowBuffer;
    }

    @Override
    public int getRowOffset() {
        return 0;
    }

    @Override
    public short getRowLength() {
        return (short)this.rowLength;
    }

    @Override
    public byte[] getFamilyArray() {
        return this.familyBuffer;
    }

    @Override
    public int getFamilyOffset() {
        return this.familyOffset;
    }

    @Override
    public byte getFamilyLength() {
        return (byte)this.familyLength;
    }

    @Override
    public byte[] getQualifierArray() {
        return this.qualifierBuffer;
    }

    @Override
    public int getQualifierOffset() {
        return this.qualifierOffset;
    }

    @Override
    public int getQualifierLength() {
        return this.qualifierLength;
    }

    @Override
    public byte[] getValueArray() {
        return this.block;
    }

    @Override
    public int getValueOffset() {
        return this.absoluteValueOffset;
    }

    @Override
    public byte getTypeByte() {
        return this.type.getCode();
    }

    @Override
    public byte[] getValue() {
        return CellUtil.cloneValue(this);
    }

    @Override
    public byte[] getFamily() {
        return CellUtil.cloneFamily(this);
    }

    @Override
    public byte[] getQualifier() {
        return CellUtil.cloneQualifier(this);
    }

    @Override
    public byte[] getRow() {
        return CellUtil.cloneRow(this);
    }

    protected String getKeyValueString() {
        KeyValue kv = KeyValueUtil.copyToNewKeyValue(this);
        return kv.toString();
    }

    @Override
    public int getTagsOffset() {
        return this.tagsOffset;
    }

    @Override
    public int getTagsLength() {
        return this.tagsLength;
    }

    @Override
    public byte[] getTagsArray() {
        return this.tagsBuffer;
    }

    @Override
    public void setSequenceId(long seqId) {
        this.mvccVersion = seqId;
    }

    static {
        KeyValue.Type[] arr$ = KeyValue.Type.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            KeyValue.Type type;
            PrefixTreeCell.TYPES[type.getCode() & 0xFF] = type = arr$[i$];
        }
        DEFAULT_TYPE = KeyValue.Type.Put;
    }
}

