/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import javax.net.ssl.SSLServerSocket;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.security.SslSocketConnector;

public class SslSocketConnectorSecure
extends SslSocketConnector {
    @Override
    protected ServerSocket newServerSocket(String host, int port, int backlog) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)super.newServerSocket(host, port, backlog);
        ArrayList<String> nonSSLProtocols = new ArrayList<String>();
        for (String p : socket.getEnabledProtocols()) {
            if (p.contains("SSLv3")) continue;
            nonSSLProtocols.add(p);
        }
        socket.setEnabledProtocols(nonSSLProtocols.toArray(new String[nonSSLProtocols.size()]));
        return socket;
    }
}

