/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSource;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;

@InterfaceAudience.Private
public class MetricsHBaseServerSourceImpl
extends BaseSourceImpl
implements MetricsHBaseServerSource {
    private final MetricsHBaseServerWrapper wrapper;
    private final MutableFastCounter authorizationSuccesses;
    private final MutableFastCounter authorizationFailures;
    private final MutableFastCounter authenticationSuccesses;
    private final MutableFastCounter authenticationFailures;
    private final MutableFastCounter authenticationFallbacks;
    private final MutableFastCounter sentBytes;
    private final MutableFastCounter receivedBytes;
    private final MutableFastCounter exceptions;
    private final MutableFastCounter exceptionsOOO;
    private final MutableFastCounter exceptionsBusy;
    private final MutableFastCounter exceptionsUnknown;
    private final MutableFastCounter exceptionsScannerReset;
    private final MutableFastCounter exceptionsSanity;
    private final MutableFastCounter exceptionsNSRE;
    private final MutableFastCounter exceptionsMoved;
    private final MutableFastCounter exceptionsMultiTooLarge;
    private final MutableFastCounter exceptionsCallQueueTooBig;
    private MetricHistogram queueCallTime;
    private MetricHistogram processCallTime;
    private MetricHistogram totalCallTime;
    private MetricHistogram requestSize;
    private MetricHistogram responseSize;

    public MetricsHBaseServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsHBaseServerWrapper wrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.wrapper = wrapper;
        this.authorizationSuccesses = this.getMetricsRegistry().newCounter("authorizationSuccesses", "Number of authorization successes.", 0L);
        this.authorizationFailures = this.getMetricsRegistry().newCounter("authorizationFailures", "Number of authorization failures.", 0L);
        this.exceptions = this.getMetricsRegistry().newCounter("exceptions", "Exceptions caused by requests", 0L);
        this.exceptionsOOO = this.getMetricsRegistry().newCounter("exceptions.OutOfOrderScannerNextException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsBusy = this.getMetricsRegistry().newCounter("exceptions.RegionTooBusyException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsUnknown = this.getMetricsRegistry().newCounter("exceptions.UnknownScannerException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsScannerReset = this.getMetricsRegistry().newCounter("exceptions.ScannerResetException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsSanity = this.getMetricsRegistry().newCounter("exceptions.FailedSanityCheckException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsMoved = this.getMetricsRegistry().newCounter("exceptions.RegionMovedException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsNSRE = this.getMetricsRegistry().newCounter("exceptions.NotServingRegionException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsMultiTooLarge = this.getMetricsRegistry().newCounter("exceptions.multiResponseTooLarge", "A response to a multi request was too large and the rest of the requests will have to be retried.", 0L);
        this.exceptionsCallQueueTooBig = this.getMetricsRegistry().newCounter("exceptions.callQueueTooBig", "Call queue is full", 0L);
        this.authenticationSuccesses = this.getMetricsRegistry().newCounter("authenticationSuccesses", "Number of authentication successes.", 0L);
        this.authenticationFailures = this.getMetricsRegistry().newCounter("authenticationFailures", "Number of authentication failures.", 0L);
        this.authenticationFallbacks = this.getMetricsRegistry().newCounter("authenticationFallbacks", "Number of fallbacks to insecure authentication.", 0L);
        this.sentBytes = this.getMetricsRegistry().newCounter("sentBytes", "Number of bytes sent.", 0L);
        this.receivedBytes = this.getMetricsRegistry().newCounter("receivedBytes", "Number of bytes received.", 0L);
        this.queueCallTime = this.getMetricsRegistry().newTimeHistogram("queueCallTime", "Queue Call Time.");
        this.processCallTime = this.getMetricsRegistry().newTimeHistogram("processCallTime", "Processing call time.");
        this.totalCallTime = this.getMetricsRegistry().newTimeHistogram("totalCallTime", "Total call time, including both queued and processing time.");
        this.requestSize = this.getMetricsRegistry().newSizeHistogram("requestSize", "Request size in bytes.");
        this.responseSize = this.getMetricsRegistry().newSizeHistogram("responseSize", "Response size in bytes.");
    }

    @Override
    public void authorizationSuccess() {
        this.authorizationSuccesses.incr();
    }

    @Override
    public void authorizationFailure() {
        this.authorizationFailures.incr();
    }

    @Override
    public void authenticationFailure() {
        this.authenticationFailures.incr();
    }

    @Override
    public void authenticationFallback() {
        this.authenticationFallbacks.incr();
    }

    @Override
    public void exception() {
        this.exceptions.incr();
    }

    @Override
    public void outOfOrderException() {
        this.exceptionsOOO.incr();
    }

    @Override
    public void failedSanityException() {
        this.exceptionsSanity.incr();
    }

    @Override
    public void movedRegionException() {
        this.exceptionsMoved.incr();
    }

    @Override
    public void notServingRegionException() {
        this.exceptionsNSRE.incr();
    }

    @Override
    public void unknownScannerException() {
        this.exceptionsUnknown.incr();
    }

    @Override
    public void scannerResetException() {
        this.exceptionsScannerReset.incr();
    }

    @Override
    public void tooBusyException() {
        this.exceptionsBusy.incr();
    }

    @Override
    public void multiActionTooLargeException() {
        this.exceptionsMultiTooLarge.incr();
    }

    @Override
    public void callQueueTooBigException() {
        this.exceptionsCallQueueTooBig.incr();
    }

    @Override
    public void authenticationSuccess() {
        this.authenticationSuccesses.incr();
    }

    @Override
    public void sentBytes(long count) {
        this.sentBytes.incr(count);
    }

    @Override
    public void receivedBytes(int count) {
        this.receivedBytes.incr(count);
    }

    @Override
    public void sentResponse(long count) {
        this.responseSize.add(count);
    }

    @Override
    public void receivedRequest(long count) {
        this.requestSize.add(count);
    }

    @Override
    public void dequeuedCall(int qTime) {
        this.queueCallTime.add(qTime);
    }

    @Override
    public void processedCall(int processingTime) {
        this.processCallTime.add(processingTime);
    }

    @Override
    public void queuedAndProcessedCall(int totalTime) {
        this.totalCallTime.add(totalTime);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder mrb = metricsCollector.addRecord(this.metricsName);
        if (this.wrapper != null) {
            mrb.addGauge(Interns.info("queueSize", "Number of bytes in the call queues."), this.wrapper.getTotalQueueSize()).addGauge(Interns.info("numCallsInGeneralQueue", "Number of calls in the general call queue."), this.wrapper.getGeneralQueueLength()).addGauge(Interns.info("numCallsInReplicationQueue", "Number of calls in the replication call queue."), this.wrapper.getReplicationQueueLength()).addGauge(Interns.info("numCallsInPriorityQueue", "Number of calls in the priority call queue."), this.wrapper.getPriorityQueueLength()).addGauge(Interns.info("numOpenConnections", "Number of open connections."), this.wrapper.getNumOpenConnections()).addGauge(Interns.info("numActiveHandler", "Number of active rpc handlers."), this.wrapper.getActiveRpcHandlerCount()).addCounter(Interns.info("numGeneralCallsDropped", "Total number of calls in general queue which were dropped by CoDel RPC executor"), this.wrapper.getNumGeneralCallsDropped()).addCounter(Interns.info("numLifoModeSwitches", "Total number of calls in general queue which were served from the tail of the queue"), this.wrapper.getNumLifoModeSwitches());
        }
        this.metricsRegistry.snapshot(mrb, all);
    }
}

