/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Partitioner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HRegionPartitioner<KEY, VALUE>
extends Partitioner<ImmutableBytesWritable, VALUE>
implements Configurable {
    private static final Log LOG = LogFactory.getLog(HRegionPartitioner.class);
    private Configuration conf = null;
    private Connection connection;
    private RegionLocator locator;
    private byte[][] startKeys;

    @Override
    public int getPartition(ImmutableBytesWritable key, VALUE value, int numPartitions) {
        byte[] region = null;
        if (this.startKeys.length == 1) {
            return 0;
        }
        try {
            region = this.locator.getRegionLocation(key.get()).getRegionInfo().getStartKey();
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        for (int i = 0; i < this.startKeys.length; ++i) {
            if (Bytes.compareTo(region, this.startKeys[i]) != 0) continue;
            if (i >= numPartitions - 1) {
                return (Integer.toString(i).hashCode() & Integer.MAX_VALUE) % numPartitions;
            }
            return i;
        }
        return 0;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration configuration) {
        this.conf = HBaseConfiguration.create(configuration);
        try {
            this.connection = ConnectionFactory.createConnection(HBaseConfiguration.create(this.conf));
            TableName tableName = TableName.valueOf(this.conf.get("hbase.mapred.outputtable"));
            this.locator = this.connection.getRegionLocator(tableName);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        try {
            this.startKeys = this.locator.getStartKeys();
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }
}

