/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.shaded.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.hbase.shaded.com.google.common.cache.CacheLoader;
import org.apache.hadoop.hbase.shaded.com.google.common.cache.LoadingCache;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
class RegionLocationFinder {
    private static final Log LOG = LogFactory.getLog(RegionLocationFinder.class);
    private static final long CACHE_TIME = 14400000L;
    private Configuration conf;
    private volatile ClusterStatus status;
    private MasterServices services;
    private final ListeningExecutorService executor;
    private long lastFullRefresh = 0L;
    private CacheLoader<HRegionInfo, HDFSBlocksDistribution> loader = new CacheLoader<HRegionInfo, HDFSBlocksDistribution>(){

        @Override
        public ListenableFuture<HDFSBlocksDistribution> reload(final HRegionInfo hri, HDFSBlocksDistribution oldValue) throws Exception {
            return RegionLocationFinder.this.executor.submit(new Callable<HDFSBlocksDistribution>(){

                @Override
                public HDFSBlocksDistribution call() throws Exception {
                    return RegionLocationFinder.this.internalGetTopBlockLocation(hri);
                }
            });
        }

        @Override
        public HDFSBlocksDistribution load(HRegionInfo key) throws Exception {
            return RegionLocationFinder.this.internalGetTopBlockLocation(key);
        }
    };
    private LoadingCache<HRegionInfo, HDFSBlocksDistribution> cache = this.createCache();

    RegionLocationFinder() {
        this.executor = MoreExecutors.listeningDecorator(Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("region-location-%d").build()));
    }

    private LoadingCache<HRegionInfo, HDFSBlocksDistribution> createCache() {
        return CacheBuilder.newBuilder().expireAfterWrite(14400000L, TimeUnit.MILLISECONDS).build(this.loader);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public void setServices(MasterServices services) {
        this.services = services;
    }

    public void setClusterStatus(ClusterStatus status) {
        long currentTime = EnvironmentEdgeManager.currentTime();
        this.status = status;
        if (currentTime > this.lastFullRefresh + 0x6DDD00L) {
            this.lastFullRefresh = this.scheduleFullRefresh() ? currentTime : this.lastFullRefresh;
        }
    }

    private boolean scheduleFullRefresh() {
        if (this.services == null) {
            return false;
        }
        AssignmentManager am = this.services.getAssignmentManager();
        if (am == null) {
            return false;
        }
        RegionStates regionStates = am.getRegionStates();
        if (regionStates == null) {
            return false;
        }
        Set<HRegionInfo> regions = regionStates.getRegionAssignments().keySet();
        boolean includesUserTables = false;
        for (HRegionInfo hri : regions) {
            this.cache.refresh(hri);
            includesUserTables = includesUserTables || !hri.isSystemTable();
        }
        return includesUserTables;
    }

    protected List<ServerName> getTopBlockLocations(HRegionInfo region) {
        HDFSBlocksDistribution blocksDistribution = this.getBlockDistribution(region);
        List<String> topHosts = blocksDistribution.getTopHosts();
        return this.mapHostNameToServerName(topHosts);
    }

    protected List<ServerName> getTopBlockLocations(HRegionInfo region, String currentHost) {
        HDFSBlocksDistribution blocksDistribution = this.getBlockDistribution(region);
        ArrayList<String> topHosts = new ArrayList<String>();
        for (String host : blocksDistribution.getTopHosts()) {
            if (host.equals(currentHost)) break;
            topHosts.add(host);
        }
        return this.mapHostNameToServerName(topHosts);
    }

    protected HDFSBlocksDistribution internalGetTopBlockLocation(HRegionInfo region) {
        try {
            HTableDescriptor tableDescriptor = this.getTableDescriptor(region.getTable());
            if (tableDescriptor != null) {
                HDFSBlocksDistribution blocksDistribution = HRegion.computeHDFSBlocksDistribution(this.getConf(), tableDescriptor, region);
                return blocksDistribution;
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("IOException during HDFSBlocksDistribution computation. for region = " + region.getEncodedName()), (Throwable)ioe);
        }
        return new HDFSBlocksDistribution();
    }

    protected HTableDescriptor getTableDescriptor(TableName tableName) throws IOException {
        HTableDescriptor tableDescriptor = null;
        try {
            if (this.services != null && this.services.getTableDescriptors() != null) {
                tableDescriptor = this.services.getTableDescriptors().get(tableName);
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.debug((Object)("FileNotFoundException during getTableDescriptors. Current table name = " + tableName), (Throwable)fnfe);
        }
        return tableDescriptor;
    }

    protected List<ServerName> mapHostNameToServerName(List<String> hosts) {
        if (hosts == null || this.status == null) {
            if (hosts == null) {
                LOG.warn((Object)"RegionLocationFinder top hosts is null");
            }
            return Lists.newArrayList();
        }
        ArrayList<ServerName> topServerNames = new ArrayList<ServerName>();
        Collection<ServerName> regionServers = this.status.getServers();
        HashMap hostToServerName = new HashMap();
        for (ServerName sn : regionServers) {
            String host = sn.getHostname();
            if (!hostToServerName.containsKey(host)) {
                hostToServerName.put(host, new ArrayList());
            }
            ((List)hostToServerName.get(host)).add(sn);
        }
        for (String host : hosts) {
            if (!hostToServerName.containsKey(host)) continue;
            for (ServerName sn : (List)hostToServerName.get(host)) {
                if (sn == null) continue;
                topServerNames.add(sn);
            }
        }
        return topServerNames;
    }

    public HDFSBlocksDistribution getBlockDistribution(HRegionInfo hri) {
        HDFSBlocksDistribution blockDistbn = null;
        try {
            if (this.cache.asMap().containsKey(hri)) {
                blockDistbn = this.cache.get(hri);
                return blockDistbn;
            }
            LOG.debug((Object)("HDFSBlocksDistribution not found in cache for region " + hri.getRegionNameAsString()));
            blockDistbn = this.internalGetTopBlockLocation(hri);
            this.cache.put(hri, blockDistbn);
            return blockDistbn;
        }
        catch (ExecutionException e) {
            LOG.warn((Object)"Error while fetching cache entry ", (Throwable)e);
            blockDistbn = this.internalGetTopBlockLocation(hri);
            this.cache.put(hri, blockDistbn);
            return blockDistbn;
        }
    }
}

